/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring.context.support;

import grails.util.CacheEntry;
import grails.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class ReloadableResourceBundleMessageSource
extends AbstractMessageSource
implements ResourceLoaderAware {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    private String[] basenames = new String[0];
    private String defaultEncoding;
    private Properties fileEncodings;
    private boolean fallbackToSystemLocale = true;
    protected long cacheMillis = -1L;
    protected long fileCacheMillis = Long.MIN_VALUE;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final ConcurrentMap<Pair<String, Locale>, CacheEntry<List<Pair<String, Resource>>>> cachedFilenames = new ConcurrentHashMap<Pair<String, Locale>, CacheEntry<List<Pair<String, Resource>>>>();
    private final ConcurrentMap<String, CacheEntry<PropertiesHolder>> cachedProperties = new ConcurrentHashMap<String, CacheEntry<PropertiesHolder>>();
    private final ConcurrentMap<Locale, CacheEntry<PropertiesHolder>> cachedMergedProperties = new ConcurrentHashMap<Locale, CacheEntry<PropertiesHolder>>();
    private final ConcurrentMap<String, CacheEntry<Resource>> cachedResources = new ConcurrentHashMap<String, CacheEntry<Resource>>();

    public void setBasename(String basename) {
        this.setBasenames(basename);
    }

    public void setBasenames(String ... basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            for (int i = 0; i < basenames.length; ++i) {
                String basename = basenames[i];
                Assert.hasText((String)basename, (String)"Basename must not be empty");
                this.basenames[i] = basename.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setFileEncodings(Properties fileEncodings) {
        this.fileEncodings = fileEncodings;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = cacheSeconds * 1000;
        if (this.fileCacheMillis == Long.MIN_VALUE) {
            this.fileCacheMillis = this.cacheMillis;
        }
    }

    public void setFileCacheSeconds(int fileCacheSeconds) {
        this.fileCacheMillis = fileCacheSeconds * 1000;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            String result = propHolder.getProperty(code);
            if (result != null) {
                return result;
            }
        } else {
            for (String basename : this.basenames) {
                List<Pair<String, Resource>> filenamesAndResources = this.calculateAllFilenames(basename, locale);
                for (Pair<String, Resource> filenameAndResource : filenamesAndResources) {
                    PropertiesHolder propHolder;
                    String result;
                    if (filenameAndResource.getbValue() == null || (result = (propHolder = this.getProperties(filenameAndResource.getaValue(), filenameAndResource.getbValue())).getProperty(code)) == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            MessageFormat result = propHolder.getMessageFormat(code, locale);
            if (result != null) {
                return result;
            }
        } else {
            for (String basename : this.basenames) {
                List<Pair<String, Resource>> filenamesAndResources = this.calculateAllFilenames(basename, locale);
                for (Pair<String, Resource> filenameAndResource : filenamesAndResources) {
                    PropertiesHolder propHolder;
                    MessageFormat result;
                    if (filenameAndResource.getbValue() == null || (result = (propHolder = this.getProperties(filenameAndResource.getaValue(), filenameAndResource.getbValue())).getMessageFormat(code, locale)) == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    protected PropertiesHolder getMergedProperties(final Locale locale) {
        return CacheEntry.getValue(this.cachedMergedProperties, locale, this.cacheMillis, new Callable<PropertiesHolder>(){

            @Override
            public PropertiesHolder call() throws Exception {
                Properties mergedProps = new Properties();
                PropertiesHolder mergedHolder = new PropertiesHolder(mergedProps);
                for (int i = ReloadableResourceBundleMessageSource.this.basenames.length - 1; i >= 0; --i) {
                    List<Pair<String, Resource>> filenamesAndResources = ReloadableResourceBundleMessageSource.this.calculateAllFilenames(ReloadableResourceBundleMessageSource.this.basenames[i], locale);
                    for (int j = filenamesAndResources.size() - 1; j >= 0; --j) {
                        Pair<String, Resource> filenameAndResource = filenamesAndResources.get(j);
                        if (filenameAndResource.getbValue() == null) continue;
                        PropertiesHolder propHolder = ReloadableResourceBundleMessageSource.this.getProperties(filenameAndResource.getaValue(), filenameAndResource.getbValue());
                        mergedProps.putAll((Map<?, ?>)propHolder.getProperties());
                    }
                }
                return mergedHolder;
            }
        });
    }

    protected List<Pair<String, Resource>> calculateAllFilenames(final String basename, final Locale locale) {
        Pair<String, Locale> cacheKey = new Pair<String, Locale>(basename, locale);
        return CacheEntry.getValue(this.cachedFilenames, cacheKey, this.cacheMillis, new Callable<List<Pair<String, Resource>>>(){

            @Override
            public List<Pair<String, Resource>> call() throws Exception {
                ArrayList<String> filenames = new ArrayList<String>(7);
                filenames.addAll(ReloadableResourceBundleMessageSource.this.calculateFilenamesForLocale(basename, locale));
                if (ReloadableResourceBundleMessageSource.this.fallbackToSystemLocale && !locale.equals(Locale.getDefault())) {
                    List<String> fallbackFilenames = ReloadableResourceBundleMessageSource.this.calculateFilenamesForLocale(basename, Locale.getDefault());
                    for (String fallbackFilename : fallbackFilenames) {
                        if (filenames.contains(fallbackFilename)) continue;
                        filenames.add(fallbackFilename);
                    }
                }
                filenames.add(basename);
                ArrayList<Pair<String, Resource>> filenamesAndResources = new ArrayList<Pair<String, Resource>>(filenames.size());
                for (String filename : filenames) {
                    filenamesAndResources.add(new Pair<String, Resource>(filename, ReloadableResourceBundleMessageSource.this.locateResource(filename)));
                }
                return filenamesAndResources;
            }
        });
    }

    protected List<String> calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        temp.append('_');
        if (language.length() > 0) {
            temp.append(language);
            result.add(0, temp.toString());
        }
        temp.append('_');
        if (country.length() > 0) {
            temp.append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0 && (language.length() > 0 || country.length() > 0)) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    protected PropertiesHolder getProperties(final String filename, final Resource resource) {
        return CacheEntry.getValue(this.cachedProperties, filename, this.fileCacheMillis, new Callable<PropertiesHolder>(){

            @Override
            public PropertiesHolder call() throws Exception {
                return new PropertiesHolder(filename, resource);
            }
        }, (Callable<? extends CacheEntry>)new Callable<CacheEntry>(){

            @Override
            public CacheEntry call() throws Exception {
                return new PropertiesHolderCacheEntry();
            }
        }, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(Resource resource, String filename) throws IOException {
        Properties props = new Properties();
        try (InputStream is = resource.getInputStream();){
            if (resource.getFilename().endsWith(XML_SUFFIX)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loading properties [" + resource.getFilename() + "]"));
                }
                this.propertiesPersister.loadFromXml(props, is);
            } else {
                String encoding = null;
                if (this.fileEncodings != null) {
                    encoding = this.fileEncodings.getProperty(filename);
                }
                if (encoding == null) {
                    encoding = this.defaultEncoding;
                }
                if (encoding != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loading properties [" + resource.getFilename() + "] with encoding '" + encoding + "'"));
                    }
                    this.propertiesPersister.load(props, (Reader)new InputStreamReader(is, encoding));
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loading properties [" + resource.getFilename() + "]"));
                    }
                    this.propertiesPersister.load(props, is);
                }
            }
            Properties properties = props;
            return properties;
        }
    }

    public void clearCache() {
        this.logger.debug((Object)"Clearing entire resource bundle cache");
        this.cachedProperties.clear();
        this.cachedMergedProperties.clear();
        this.cachedFilenames.clear();
        this.cachedResources.clear();
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        if (this.getParentMessageSource() instanceof ReloadableResourceBundleMessageSource) {
            ((ReloadableResourceBundleMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        } else if (this.getParentMessageSource() instanceof org.springframework.context.support.ReloadableResourceBundleMessageSource) {
            ((org.springframework.context.support.ReloadableResourceBundleMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString((Object[])this.basenames) + "]";
    }

    protected Resource locateResource(final String filename) {
        return CacheEntry.getValue(this.cachedResources, filename, this.cacheMillis, new Callable<Resource>(){

            @Override
            public Resource call() throws Exception {
                return ReloadableResourceBundleMessageSource.this.locateResourceWithoutCache(filename);
            }
        });
    }

    protected Resource locateResourceWithoutCache(String filename) {
        Resource resource = this.resourceLoader.getResource("classpath:" + filename + PROPERTIES_SUFFIX);
        if (!resource.exists()) {
            resource = this.resourceLoader.getResource(filename + PROPERTIES_SUFFIX);
        }
        if (!resource.exists()) {
            resource = this.resourceLoader.getResource(filename + XML_SUFFIX);
        }
        if (resource.exists()) {
            return resource;
        }
        return null;
    }

    protected class PropertiesHolder {
        private Properties properties;
        private String filename;
        private Resource resource;
        private long fileTimestamp = -1L;
        private final ConcurrentMap<Pair<String, Locale>, CacheEntry<MessageFormat>> cachedMessageFormats = new ConcurrentHashMap<Pair<String, Locale>, CacheEntry<MessageFormat>>();

        public PropertiesHolder(String filename, Resource resource) {
            this.filename = filename;
            this.resource = resource;
            this.doUpdate(true);
        }

        public PropertiesHolder(Properties properties) {
            this.properties = properties;
        }

        public boolean update() {
            return this.doUpdate(false);
        }

        private boolean doUpdate(boolean initialization) {
            if (this.filename == null) {
                return false;
            }
            if (!initialization && ReloadableResourceBundleMessageSource.this.cacheMillis >= 0L) {
                this.resource = ReloadableResourceBundleMessageSource.this.locateResource(this.filename);
            }
            if (this.resource != null) {
                block10: {
                    long newFileTimestamp;
                    try {
                        newFileTimestamp = this.resource.lastModified();
                    }
                    catch (IOException ex) {
                        if (ReloadableResourceBundleMessageSource.this.logger.isDebugEnabled()) {
                            ReloadableResourceBundleMessageSource.this.logger.debug((Object)(this.resource + " could not be resolved in the file system - assuming that is hasn't changed"), (Throwable)ex);
                        }
                        newFileTimestamp = -1L;
                    }
                    if (ReloadableResourceBundleMessageSource.this.fileCacheMillis >= 0L && newFileTimestamp == this.fileTimestamp && this.properties != null) {
                        return false;
                    }
                    try {
                        this.properties = ReloadableResourceBundleMessageSource.this.loadProperties(this.resource, this.filename);
                        this.fileTimestamp = newFileTimestamp;
                        this.cachedMessageFormats.clear();
                    }
                    catch (IOException ex) {
                        if (!ReloadableResourceBundleMessageSource.this.logger.isWarnEnabled()) break block10;
                        ReloadableResourceBundleMessageSource.this.logger.warn((Object)("Could not parse properties file [" + this.resource.getFilename() + "]"), (Throwable)ex);
                    }
                }
                return true;
            }
            if (ReloadableResourceBundleMessageSource.this.logger.isDebugEnabled()) {
                ReloadableResourceBundleMessageSource.this.logger.debug((Object)("No properties file found for [" + this.filename + "] - neither plain properties nor XML"));
            }
            this.properties = new Properties();
            this.fileTimestamp = -1L;
            this.cachedMessageFormats.clear();
            return true;
        }

        public String getFilename() {
            return this.filename;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public long getFileTimestamp() {
            return this.fileTimestamp;
        }

        public String getProperty(String code) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.getProperty(code);
        }

        public MessageFormat getMessageFormat(final String code, final Locale locale) {
            if (this.properties == null) {
                return null;
            }
            Pair<String, Locale> cacheKey = new Pair<String, Locale>(code, locale);
            return CacheEntry.getValue(this.cachedMessageFormats, cacheKey, -1L, new Callable<MessageFormat>(){

                @Override
                public MessageFormat call() throws Exception {
                    String msg = PropertiesHolder.this.properties.getProperty(code);
                    if (msg != null) {
                        return ReloadableResourceBundleMessageSource.this.createMessageFormat(msg, locale);
                    }
                    return null;
                }
            });
        }
    }

    protected static class PropertiesHolderCacheEntry
    extends CacheEntry<PropertiesHolder> {
        @Override
        protected PropertiesHolder updateValue(PropertiesHolder oldValue, Callable<PropertiesHolder> updater, Object cacheRequestObject) throws Exception {
            if (oldValue != null) {
                oldValue.update();
                return oldValue;
            }
            return updater.call();
        }
    }
}

