/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.Holders;
import grails.util.Metadata;
import groovy.lang.GroovyObjectSupport;
import groovy.util.ConfigObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.cfg.ConfigurationHelper;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsConfigurationAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;

abstract class AbstractGrailsApplication
extends GroovyObjectSupport
implements GrailsApplication,
ApplicationContextAware,
BeanClassLoaderAware {
    protected ClassLoader classLoader;
    protected ConfigObject config;
    protected Map flatConfig = Collections.emptyMap();
    protected ApplicationContext parentContext;
    protected ApplicationContext mainContext;
    protected Metadata applicationMeta = Metadata.getCurrent();

    public AbstractGrailsApplication() {
        ConfigurationHelper.clearCachedConfig(this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    @Override
    public Metadata getMetadata() {
        return this.applicationMeta;
    }

    @Override
    public boolean isWarDeployed() {
        return this.getMetadata().isWarDeployed();
    }

    @Override
    public ConfigObject getConfig() {
        return this.config;
    }

    public void setConfig(ConfigObject config) {
        this.config = config;
        Holders.setConfig(config);
        this.updateFlatConfig();
    }

    public void updateFlatConfig() {
        this.flatConfig = this.config == null ? new LinkedHashMap() : this.config.flatten(new LinkedHashMap());
    }

    @Override
    public Map<String, Object> getFlatConfig() {
        return this.flatConfig;
    }

    @Override
    public void configChanged() {
        this.updateFlatConfig();
        ArtefactHandler[] handlers = this.getArtefactHandlers();
        if (handlers != null) {
            for (ArtefactHandler handler : handlers) {
                if (!(handler instanceof GrailsConfigurationAware)) continue;
                ((GrailsConfigurationAware)((Object)handler)).setConfiguration(this.config);
            }
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Class getClassForName(String className) {
        return ClassUtils.resolveClassName((String)className, (ClassLoader)this.getClassLoader());
    }

    @Override
    public ApplicationContext getMainContext() {
        return this.mainContext;
    }

    @Override
    public void setMainContext(ApplicationContext context) {
        this.mainContext = context;
        if (this.mainContext == null) {
            return;
        }
        if (!this.mainContext.containsBean("pluginManager")) {
            return;
        }
        if (this.mainContext instanceof ConfigurableApplicationContext && !((ConfigurableApplicationContext)this.mainContext).isActive()) {
            return;
        }
        ((GrailsPluginManager)this.mainContext.getBean("pluginManager", GrailsPluginManager.class)).setApplicationContext(context);
    }

    @Override
    public ApplicationContext getParentContext() {
        return this.parentContext;
    }
}

