/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.transaction.transform;

import grails.transaction.NotTransactional;
import grails.transaction.Transactional;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.CompileStatic;
import groovy.transform.TypeChecked;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.orm.support.GrailsTransactionTemplate;
import org.codehaus.groovy.grails.orm.support.TransactionManagerAware;
import org.codehaus.groovy.grails.transaction.GrailsTransactionAttribute;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class TransactionalTransform
implements ASTTransformation,
GroovyObject {
    public static final ClassNode MY_TYPE;
    public static final ClassNode COMPILE_STATIC_TYPE;
    public static final ClassNode TYPE_CHECKED_TYPE;
    private static final String PROPERTY_TRANSACTION_MANAGER = "transactionManager";
    private static final String METHOD_EXECUTE = "execute";
    private static final Set<String> METHOD_NAME_EXCLUDES;
    private static final Set<String> ANNOTATION_NAME_EXCLUDES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public TransactionalTransform() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void visit(ASTNode[] astNodes, SourceUnit source) {
        if (!(BytecodeInterface8.objectArrayGet((Object[])astNodes, (int)0) instanceof AnnotationNode) || !(BytecodeInterface8.objectArrayGet((Object[])astNodes, (int)1) instanceof AnnotatedNode)) {
            throw (Throwable)new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])astNodes, (int)1), AnnotatedNode.class);
        AnnotationNode annotationNode = (AnnotationNode)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])astNodes, (int)0), AnnotationNode.class);
        if (!this.isTransactionAnnotation(annotationNode)) {
            return;
        }
        if (parent instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)ScriptBytecodeAdapter.castToType((Object)parent, MethodNode.class);
            ClassNode declaringClassNode = methodNode.getDeclaringClass();
            this.weaveTransactionManagerAware(source, declaringClassNode);
            this.weaveTransactionalMethod(source, declaringClassNode, annotationNode, methodNode);
        } else if (parent instanceof ClassNode) {
            this.weaveTransactionalBehavior(source, (ClassNode)ScriptBytecodeAdapter.castToType((Object)parent, ClassNode.class), annotationNode);
        }
    }

    protected boolean isTransactionAnnotation(AnnotationNode annotationNode) {
        return MY_TYPE.equals((Object)annotationNode.getClassNode());
    }

    public void weaveTransactionalBehavior(SourceUnit source, ClassNode classNode, AnnotationNode annotationNode) {
        this.weaveTransactionManagerAware(source, classNode);
        ArrayList methods = new ArrayList(classNode.getMethods());
        MethodNode md = null;
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            md = (MethodNode)ScriptBytecodeAdapter.castToType(iterator.next(), MethodNode.class);
            String methodName = md.getName();
            int modifiers = md.getModifiers();
            if (!(!md.isSynthetic() && !methodName.contains("$") && Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers)) || this.hasExcludedAnnotation(md) || METHOD_NAME_EXCLUDES.contains(methodName) || GrailsASTUtils.isSetterOrGetterMethod(md)) continue;
            this.weaveTransactionalMethod(source, classNode, annotationNode, md);
        }
    }

    private boolean hasExcludedAnnotation(MethodNode md) {
        boolean excludedAnnotation = false;
        AnnotationNode annotation = null;
        Iterator iterator = md.getAnnotations().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            annotation = (AnnotationNode)ScriptBytecodeAdapter.castToType(iterator.next(), AnnotationNode.class);
            if (!ANNOTATION_NAME_EXCLUDES.contains(annotation.getClassNode().getName())) continue;
            excludedAnnotation = bl = true;
            break;
        }
        return excludedAnnotation;
    }

    public ClassNode getAnnotationClassNode(String annotationName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(annotationName);
        ClassNode classNode = new ClassNode(clazz);
        try {
            return classNode;
        }
        catch (Exception e) {
            ClassNode classNode2 = (ClassNode)ScriptBytecodeAdapter.castToType(null, ClassNode.class);
            return classNode2;
        }
    }

    protected void weaveTransactionalMethod(SourceUnit source, ClassNode classNode, AnnotationNode annotationNode, MethodNode methodNode) {
        if (GrailsASTUtils.isApplied((ASTNode)methodNode, this.getClass())) {
            return;
        }
        GrailsASTUtils.markApplied((ASTNode)methodNode, this.getClass());
        MethodCallExpression originalMethodCall = this.moveOriginalCodeToNewMethod(source, classNode, methodNode);
        BlockStatement methodBody = new BlockStatement();
        ClassNode transactionAttributeClassNode = ClassHelper.make(GrailsTransactionAttribute.class);
        VariableExpression transactionAttributeVar = new VariableExpression("$transactionAttribute", transactionAttributeClassNode);
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new DeclarationExpression(transactionAttributeVar, GrailsASTUtils.ASSIGNMENT_OPERATOR, (Expression)new ConstructorCallExpression(transactionAttributeClassNode, (Expression)GrailsASTUtils.ZERO_ARGUMENTS))));
        this.applyTransactionalAttributeSettings(annotationNode, transactionAttributeVar, methodBody);
        Parameter transactionStatusParam = new Parameter(ClassHelper.make(TransactionStatus.class), "transactionStatus");
        Parameter[] executeMethodParameterTypes = new Parameter[]{transactionStatusParam};
        ClosureExpression callCallExpression = new ClosureExpression(executeMethodParameterTypes, this.createTransactionalMethodCallBody(transactionStatusParam, originalMethodCall));
        ArgumentListExpression constructorArgs = new ArgumentListExpression();
        constructorArgs.addExpression((Expression)new PropertyExpression(GrailsASTUtils.buildThisExpression(), PROPERTY_TRANSACTION_MANAGER));
        constructorArgs.addExpression((Expression)transactionAttributeVar);
        ClassNode transactionTemplateClassNode = ClassHelper.make(GrailsTransactionTemplate.class);
        VariableExpression transactionTemplateVar = new VariableExpression("$transactionTemplate", transactionTemplateClassNode);
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new DeclarationExpression(transactionTemplateVar, GrailsASTUtils.ASSIGNMENT_OPERATOR, (Expression)new ConstructorCallExpression(transactionTemplateClassNode, (Expression)constructorArgs))));
        ArgumentListExpression methodArgs = new ArgumentListExpression();
        methodArgs.addExpression((Expression)callCallExpression);
        MethodCallExpression executeMethodCallExpression = new MethodCallExpression((Expression)transactionTemplateVar, this.getTransactionTemplateMethodName(), (Expression)methodArgs);
        Parameter[] executeMethodParameters = new Parameter[]{new Parameter(ClassHelper.make(Closure.class), null)};
        MethodNode executeMethodNode = transactionTemplateClassNode.getMethod(this.getTransactionTemplateMethodName(), executeMethodParameters);
        executeMethodCallExpression.setMethodTarget(executeMethodNode);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)methodNode.getReturnType(), (Object)ClassHelper.VOID_TYPE)) {
            methodBody.addStatement((Statement)new ReturnStatement((Expression)new CastExpression(methodNode.getReturnType(), (Expression)executeMethodCallExpression)));
        } else {
            methodBody.addStatement((Statement)new ExpressionStatement((Expression)executeMethodCallExpression));
        }
        methodNode.setCode((Statement)methodBody);
        GrailsASTUtils.processVariableScopes(source, classNode, methodNode);
    }

    protected String getTransactionTemplateMethodName() {
        return METHOD_EXECUTE;
    }

    protected Statement createTransactionalMethodCallBody(Parameter transactionStatusParam, MethodCallExpression originalMethodCall) {
        return new ExpressionStatement((Expression)originalMethodCall);
    }

    /*
     * WARNING - void declaration
     */
    protected Object applyTransactionalAttributeSettings(AnnotationNode annotationNode, VariableExpression transactionAttributeVar, BlockStatement methodBody) {
        void var3_3;
        Reference transactionAttributeVar2 = new Reference((Object)transactionAttributeVar);
        Reference methodBody2 = new Reference((Object)var3_3);
        Reference rollbackRuleAttributeClassNode = new Reference((Object)ClassHelper.make(RollbackRuleAttribute.class));
        Reference noRollbackRuleAttributeClassNode = new Reference((Object)ClassHelper.make(NoRollbackRuleAttribute.class));
        Map members = annotationNode.getMembers();
        boolean rollbackRuleId = false;
        class _applyTransactionalAttributeSettings_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference transactionAttributeVar;
            private /* synthetic */ Reference methodBody;
            private /* synthetic */ Reference noRollbackRuleAttributeClassNode;
            private /* synthetic */ Reference rollbackRuleAttributeClassNode;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _applyTransactionalAttributeSettings_closure1(Object _outerInstance, Object _thisObject, Reference transactionAttributeVar, Reference methodBody, Reference noRollbackRuleAttributeClassNode, Reference rollbackRuleAttributeClassNode) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.transactionAttributeVar = reference4 = transactionAttributeVar;
                this.methodBody = reference3 = methodBody;
                this.noRollbackRuleAttributeClassNode = reference2 = noRollbackRuleAttributeClassNode;
                this.rollbackRuleAttributeClassNode = reference = rollbackRuleAttributeClassNode;
            }

            public Object doCall(String name, Expression expr) {
                if (ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"rollbackFor") || ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"rollbackForClassName") || ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"noRollbackFor") || ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"noRollbackForClassName")) {
                    String string;
                    ClassNode targetClassNode = ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"rollbackFor") || ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"rollbackForClassName") ? (ClassNode)ScriptBytecodeAdapter.castToType((Object)this.rollbackRuleAttributeClassNode.get(), ClassNode.class) : (ClassNode)ScriptBytecodeAdapter.castToType((Object)this.noRollbackRuleAttributeClassNode.get(), ClassNode.class);
                    name = string = "rollbackRules";
                    if (expr instanceof ListExpression) {
                        Expression exprItem = null;
                        Iterator iterator = ((ListExpression)ScriptBytecodeAdapter.castToType((Object)expr, ListExpression.class)).getExpressions().iterator();
                        while (iterator.hasNext()) {
                            exprItem = (Expression)ScriptBytecodeAdapter.castToType(iterator.next(), Expression.class);
                            ((TransactionalTransform)this.getThisObject()).appendRuleElement((BlockStatement)ScriptBytecodeAdapter.castToType((Object)this.methodBody.get(), BlockStatement.class), (VariableExpression)ScriptBytecodeAdapter.castToType((Object)this.transactionAttributeVar.get(), VariableExpression.class), name, (Expression)new ConstructorCallExpression(targetClassNode, exprItem));
                        }
                        return null;
                    }
                    return ((TransactionalTransform)this.getThisObject()).appendRuleElement((BlockStatement)ScriptBytecodeAdapter.castToType((Object)this.methodBody.get(), BlockStatement.class), (VariableExpression)ScriptBytecodeAdapter.castToType((Object)this.transactionAttributeVar.get(), VariableExpression.class), name, (Expression)new ConstructorCallExpression(targetClassNode, expr));
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"isolation")) {
                    String string;
                    name = string = "isolationLevel";
                    MethodCallExpression methodCallExpression = new MethodCallExpression(expr, "value", (Expression)new ArgumentListExpression());
                    expr = methodCallExpression;
                } else if (ScriptBytecodeAdapter.compareEqual((Object)name, (Object)"propagation")) {
                    String string;
                    name = string = "propagationBehavior";
                    MethodCallExpression methodCallExpression = new MethodCallExpression(expr, "value", (Expression)new ArgumentListExpression());
                    expr = methodCallExpression;
                }
                ((BlockStatement)this.methodBody.get()).addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)new PropertyExpression((Expression)ScriptBytecodeAdapter.castToType((Object)this.transactionAttributeVar.get(), Expression.class), name), Token.newSymbol((int)Types.EQUAL, (int)0, (int)0), expr)));
                return null;
            }

            public Object call(String name, Expression expr) {
                return this.doCall(name, expr);
            }

            public VariableExpression getTransactionAttributeVar() {
                return (VariableExpression)ScriptBytecodeAdapter.castToType((Object)this.transactionAttributeVar.get(), VariableExpression.class);
            }

            public BlockStatement getMethodBody() {
                return (BlockStatement)ScriptBytecodeAdapter.castToType((Object)this.methodBody.get(), BlockStatement.class);
            }

            public Object getNoRollbackRuleAttributeClassNode() {
                return this.noRollbackRuleAttributeClassNode.get();
            }

            public Object getRollbackRuleAttributeClassNode() {
                return this.rollbackRuleAttributeClassNode.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _applyTransactionalAttributeSettings_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.each((Map)members, (Closure)new _applyTransactionalAttributeSettings_closure1(this, this, transactionAttributeVar2, methodBody2, noRollbackRuleAttributeClassNode, rollbackRuleAttributeClassNode));
    }

    private Object appendRuleElement(BlockStatement methodBody, VariableExpression transactionAttributeVar, String name, Expression expr) {
        ClassNode rollbackRuleAttributeClassNode = ClassHelper.make(RollbackRuleAttribute.class);
        ClassNode rollbackRulesListClassNode = GrailsASTUtils.nonGeneric(ClassHelper.make(List.class), rollbackRuleAttributeClassNode);
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new CastExpression(rollbackRulesListClassNode, (Expression)GrailsASTUtils.buildGetPropertyExpression((Expression)transactionAttributeVar, name, transactionAttributeVar.getType())), "add", expr)));
        return null;
    }

    protected MethodCallExpression moveOriginalCodeToNewMethod(SourceUnit source, ClassNode classNode, MethodNode methodNode) {
        Parameter[] parameterArray;
        String renamedMethodName = TransactionalTransform.getTransactionHandlingMethodName(methodNode);
        Parameter transactionStatusParameter = new Parameter(ClassHelper.make(TransactionStatus.class), "transactionStatus");
        if (DefaultTypeTransformation.booleanUnbox((Object)methodNode.getParameters())) {
            parameterArray = GrailsASTUtils.copyParameters((Parameter[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.asType((Object)methodNode.getParameters(), List.class)), (Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{transactionStatusParameter})), Parameter[].class));
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = transactionStatusParameter;
        }
        Parameter[] newParameters = parameterArray;
        MethodNode renamedMethodNode = new MethodNode(renamedMethodName, Modifier.PROTECTED, methodNode.getReturnType().getPlainNodeReference(), newParameters, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, methodNode.getCode());
        renamedMethodNode.addAnnotations(methodNode.getAnnotations(COMPILE_STATIC_TYPE));
        renamedMethodNode.addAnnotations(methodNode.getAnnotations(TYPE_CHECKED_TYPE));
        methodNode.setCode(null);
        classNode.addMethod(renamedMethodNode);
        GrailsASTUtils.processVariableScopes(source, classNode, renamedMethodNode);
        MethodCallExpression originalMethodCall = new MethodCallExpression((Expression)new VariableExpression("this"), renamedMethodName, (Expression)new ArgumentListExpression(renamedMethodNode.getParameters()));
        originalMethodCall.setImplicitThis(false);
        originalMethodCall.setMethodTarget(renamedMethodNode);
        return originalMethodCall;
    }

    public static String getTransactionHandlingMethodName(MethodNode methodNode) {
        return StringGroovyMethods.plus((String)"$tt__", (CharSequence)methodNode.getName());
    }

    protected void weaveTransactionManagerAware(SourceUnit source, ClassNode declaringClassNode) {
        ClassNode transactionManagerAwareInterface = ClassHelper.make(TransactionManagerAware.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)GrailsASTUtils.findInterface(declaringClassNode, transactionManagerAwareInterface))) {
            declaringClassNode.addInterface(transactionManagerAwareInterface);
            if (!GrailsASTUtils.hasProperty(declaringClassNode, PROPERTY_TRANSACTION_MANAGER)) {
                declaringClassNode.addProperty(PROPERTY_TRANSACTION_MANAGER, Modifier.PUBLIC, ClassHelper.make(PlatformTransactionManager.class), null, null, null);
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TransactionalTransform.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        ClassNode classNode;
        ClassNode classNode2;
        ClassNode classNode3;
        MY_TYPE = classNode3 = new ClassNode(Transactional.class);
        COMPILE_STATIC_TYPE = classNode2 = ClassHelper.make(CompileStatic.class);
        TYPE_CHECKED_TYPE = classNode = ClassHelper.make(TypeChecked.class);
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList("afterPropertiesSet", "destroy"));
        METHOD_NAME_EXCLUDES = hashSet;
        HashSet<Object> hashSet2 = new HashSet<Object>(Arrays.asList(PostConstruct.class.getName(), PreDestroy.class.getName(), Transactional.class.getName(), "grails.web.controllers.ControllerMethod", NotTransactional.class.getName()));
        ANNOTATION_NAME_EXCLUDES = hashSet2;
    }
}

