/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.artefact.Enhanced;
import grails.util.BuildScope;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.cfg.ConfigurationHelper;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.codehaus.groovy.grails.plugins.metadata.GrailsPlugin;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractGrailsPluginManager
implements GrailsPluginManager {
    private static final Log LOG = LogFactory.getLog(AbstractGrailsPluginManager.class);
    private static final String BLANK = "";
    public static final String CONFIG_FILE = "Config";
    protected List<org.codehaus.groovy.grails.plugins.GrailsPlugin> pluginList = new ArrayList<org.codehaus.groovy.grails.plugins.GrailsPlugin>();
    protected GrailsApplication application;
    protected Resource[] pluginResources = new Resource[0];
    protected Map<String, org.codehaus.groovy.grails.plugins.GrailsPlugin> plugins = new HashMap<String, org.codehaus.groovy.grails.plugins.GrailsPlugin>();
    protected Map<String, org.codehaus.groovy.grails.plugins.GrailsPlugin> classNameToPluginMap = new HashMap<String, org.codehaus.groovy.grails.plugins.GrailsPlugin>();
    protected Class<?>[] pluginClasses = new Class[0];
    protected boolean initialised = false;
    protected boolean shutdown = false;
    protected ApplicationContext applicationContext;
    protected Map<String, org.codehaus.groovy.grails.plugins.GrailsPlugin> failedPlugins = new HashMap<String, org.codehaus.groovy.grails.plugins.GrailsPlugin>();
    protected boolean loadCorePlugins = true;

    public AbstractGrailsPluginManager(GrailsApplication application) {
        Assert.notNull((Object)application, (String)"Argument [application] cannot be null!");
        this.application = application;
    }

    @Override
    public List<TypeFilter> getTypeFilters() {
        ArrayList<? extends TypeFilter> list = new ArrayList<TypeFilter>();
        for (org.codehaus.groovy.grails.plugins.GrailsPlugin grailsPlugin : this.pluginList) {
            list.addAll(grailsPlugin.getTypeFilters());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin[] getAllPlugins() {
        return this.pluginList.toArray(new org.codehaus.groovy.grails.plugins.GrailsPlugin[this.pluginList.size()]);
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin[] getFailedLoadPlugins() {
        return this.failedPlugins.values().toArray(new org.codehaus.groovy.grails.plugins.GrailsPlugin[this.failedPlugins.size()]);
    }

    @Override
    public boolean isInitialised() {
        return this.initialised;
    }

    protected void checkInitialised() {
        Assert.state((boolean)this.initialised, (String)"Must call loadPlugins() before invoking configurational methods on GrailsPluginManager");
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin getFailedPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        return this.failedPlugins.get(name);
    }

    @Override
    public void doRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        this.checkInitialised();
        for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            plugin.doWithRuntimeConfiguration(springConfig);
        }
    }

    @Override
    public void doRuntimeConfiguration(String pluginName, RuntimeSpringConfiguration springConfig) {
        String[] loadAfters;
        this.checkInitialised();
        org.codehaus.groovy.grails.plugins.GrailsPlugin plugin = this.getGrailsPlugin(pluginName);
        if (plugin == null) {
            throw new PluginException("Plugin [" + pluginName + "] not found");
        }
        if (!plugin.supportsCurrentScopeAndEnvironment()) {
            return;
        }
        String[] dependencyNames = plugin.getDependencyNames();
        this.doRuntimeConfigurationForDependencies(dependencyNames, springConfig);
        for (String name : loadAfters = plugin.getLoadAfterNames()) {
            org.codehaus.groovy.grails.plugins.GrailsPlugin current = this.getGrailsPlugin(name);
            if (current == null) continue;
            current.doWithRuntimeConfiguration(springConfig);
        }
        plugin.doWithRuntimeConfiguration(springConfig);
    }

    private void doRuntimeConfigurationForDependencies(String[] dependencyNames, RuntimeSpringConfiguration springConfig) {
        for (String dn : dependencyNames) {
            org.codehaus.groovy.grails.plugins.GrailsPlugin current = this.getGrailsPlugin(dn);
            if (current == null) {
                throw new PluginException("Cannot load Plugin. Dependency [" + current + "] not found");
            }
            String[] pluginDependencies = current.getDependencyNames();
            if (pluginDependencies.length > 0) {
                this.doRuntimeConfigurationForDependencies(pluginDependencies, springConfig);
            }
            current.doWithRuntimeConfiguration(springConfig);
        }
    }

    @Override
    public void doPostProcessing(ApplicationContext ctx) {
        this.checkInitialised();
        for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            plugin.doWithApplicationContext(ctx);
        }
    }

    public Resource[] getPluginResources() {
        return this.pluginResources;
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin getGrailsPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        return this.plugins.get(name);
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin getGrailsPluginForClassName(String name) {
        return this.classNameToPluginMap.get(name);
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin getGrailsPlugin(String name, Object version) {
        org.codehaus.groovy.grails.plugins.GrailsPlugin plugin;
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        if ((plugin = this.plugins.get(name)) != null && GrailsPluginUtils.isValidVersion((String)plugin.getVersion(), (String)version.toString())) {
            return plugin;
        }
        return null;
    }

    @Override
    public boolean hasGrailsPlugin(String name) {
        if (name.indexOf(45) > -1) {
            name = GrailsNameUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)name);
        }
        return this.plugins.containsKey(name);
    }

    @Override
    public void doDynamicMethods() {
        this.checkInitialised();
        Class[] allClasses = this.application.getAllClasses();
        if (allClasses != null) {
            for (Class c : allClasses) {
                ExpandoMetaClass emc = new ExpandoMetaClass(c, true, true);
                emc.initialize();
            }
            for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
                plugin.doWithDynamicMethods(this.applicationContext);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext != null) {
            for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
                plugin.setApplicationContext(applicationContext);
            }
        }
    }

    @Override
    public void setApplication(GrailsApplication application) {
        Assert.notNull((Object)application, (String)"Argument [application] cannot be null");
        this.application = application;
        for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
            plugin.setApplication(application);
        }
    }

    @Override
    public void registerProvidedArtefacts(GrailsApplication app) {
        this.checkInitialised();
        for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            for (Class<?> artefact : plugin.getProvidedArtefacts()) {
                String shortName = GrailsNameUtils.getShortName(artefact);
                if (this.isAlreadyRegistered(app, artefact, shortName)) continue;
                app.addOverridableArtefact(artefact);
            }
        }
    }

    private boolean isAlreadyRegistered(GrailsApplication app, Class<?> artefact, String shortName) {
        return app.getClassForName(shortName) != null || app.getClassForName(artefact.getName()) != null;
    }

    @Override
    public void doArtefactConfiguration() {
        this.checkInitialised();
        for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
            if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
            plugin.doArtefactConfiguration();
        }
    }

    @Override
    public void shutdown() {
        this.checkInitialised();
        try {
            for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
                if (!plugin.supportsCurrentScopeAndEnvironment()) continue;
                plugin.notifyOfEvent(2, plugin);
            }
        }
        finally {
            this.shutdown = true;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean supportsCurrentBuildScope(String pluginName) {
        org.codehaus.groovy.grails.plugins.GrailsPlugin plugin = this.getGrailsPlugin(pluginName);
        return plugin == null || plugin.supportsScope(BuildScope.getCurrent());
    }

    @Override
    public void setLoadCorePlugins(boolean shouldLoadCorePlugins) {
        this.loadCorePlugins = shouldLoadCorePlugins;
    }

    @Override
    public void informOfClassChange(Class<?> aClass) {
        if (aClass == null || this.application == null) {
            return;
        }
        ArtefactHandler handler = this.application.getArtefactType(aClass);
        if (handler == null) {
            return;
        }
        String pluginName = handler.getPluginName();
        if (pluginName == null) {
            return;
        }
        org.codehaus.groovy.grails.plugins.GrailsPlugin plugin = this.getGrailsPlugin(pluginName);
        if (plugin != null) {
            plugin.notifyOfEvent(0, aClass);
        }
    }

    @Override
    public String getPluginPath(String name) {
        org.codehaus.groovy.grails.plugins.GrailsPlugin plugin = this.getGrailsPlugin(name);
        if (plugin != null && !plugin.isBasePlugin()) {
            return plugin.getPluginPath();
        }
        return BLANK;
    }

    @Override
    public String getPluginPathForInstance(Object instance) {
        if (instance != null) {
            return this.getPluginPathForClass(instance.getClass());
        }
        return null;
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin getPluginForInstance(Object instance) {
        if (instance != null) {
            return this.getPluginForClass(instance.getClass());
        }
        return null;
    }

    @Override
    public org.codehaus.groovy.grails.plugins.GrailsPlugin getPluginForClass(Class<?> theClass) {
        GrailsPlugin ann;
        if (theClass != null && (ann = theClass.getAnnotation(GrailsPlugin.class)) != null) {
            return this.getGrailsPlugin(ann.name());
        }
        return null;
    }

    public void informPluginsOfConfigChange() {
        for (org.codehaus.groovy.grails.plugins.GrailsPlugin plugin : this.pluginList) {
            plugin.notifyOfEvent(1, this.application.getConfig());
        }
    }

    @Override
    public void informOfFileChange(File file) {
        String className = GrailsResourceUtils.getClassName((String)file.getAbsolutePath());
        Class<?> cls = null;
        if (className != null) {
            cls = this.loadApplicationClass(className);
        }
        this.informOfClassChange(file, cls);
    }

    @Override
    public void informOfClassChange(File file, Class cls) {
        if (cls != null && (cls.getName().equals(CONFIG_FILE) || cls.getName().equals("DataSource"))) {
            ConfigSlurper configSlurper = ConfigurationHelper.getConfigSlurper(Environment.getCurrent().getName(), this.application);
            try {
                ConfigObject c = configSlurper.parse(file.toURI().toURL());
                this.application.getConfig().merge(c);
                this.application.configChanged();
                this.informPluginsOfConfigChange();
            }
            catch (Exception e) {
                LOG.debug((Object)"Error in changing Config", (Throwable)e);
            }
        } else {
            if (cls != null) {
                Class[] mixinClasses;
                MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
                registry.removeMetaClass(cls);
                ExpandoMetaClass newMc = new ExpandoMetaClass(cls, true, true);
                newMc.initialize();
                registry.setMetaClass(cls, (MetaClass)newMc);
                Enhanced en = (Enhanced)AnnotationUtils.findAnnotation((Class)cls, Enhanced.class);
                if (en != null && (mixinClasses = en.mixins()) != null) {
                    DefaultGroovyMethods.mixin((MetaClass)newMc, (Class[])mixinClasses);
                }
            }
            for (org.codehaus.groovy.grails.plugins.GrailsPlugin grailsPlugin : this.pluginList) {
                if (!grailsPlugin.hasInterestInChange(file.getAbsolutePath())) continue;
                try {
                    if (cls == null) {
                        grailsPlugin.notifyOfEvent(0, new FileSystemResource(file));
                    } else {
                        grailsPlugin.notifyOfEvent(0, cls);
                    }
                    Environment.setCurrentReloadError(null);
                }
                catch (Exception e) {
                    LOG.error((Object)("Plugin " + grailsPlugin + " could not reload changes to file [" + file + "]: " + e.getMessage()), (Throwable)e);
                    Environment.setCurrentReloadError((Throwable)e);
                }
            }
        }
    }

    private Class<?> loadApplicationClass(String className) {
        Class<?> cls = null;
        try {
            cls = this.application.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cls;
    }

    public String getPluginPathForClass(Class<?> theClass) {
        GrailsPlugin ann;
        if (theClass != null && (ann = theClass.getAnnotation(GrailsPlugin.class)) != null) {
            return this.getPluginPath(ann.name());
        }
        return null;
    }

    @Override
    public String getPluginViewsPathForInstance(Object instance) {
        if (instance != null) {
            return this.getPluginViewsPathForClass(instance.getClass());
        }
        return null;
    }

    public String getPluginViewsPathForClass(Class<?> theClass) {
        String path;
        if (theClass != null && StringUtils.hasText((String)(path = this.getPluginPathForClass(theClass)))) {
            return path + '/' + "grails-app" + "/views";
        }
        return null;
    }
}

