/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class GrailsAwareInjectionOperation
extends CompilationUnit.PrimaryClassNodeOperation {
    private static final String INJECTOR_SCAN_PACKAGE = "org.codehaus.groovy.grails.compiler";
    private static ClassInjector[] classInjectors;
    private ClassInjector[] localClassInjectors;

    public GrailsAwareInjectionOperation() {
        GrailsAwareInjectionOperation.initializeState();
    }

    public GrailsAwareInjectionOperation(ClassInjector[] classInjectors) {
        this();
        this.localClassInjectors = classInjectors;
    }

    @Deprecated
    public GrailsAwareInjectionOperation(GroovyResourceLoader resourceLoader, ClassInjector[] classInjectors) {
        this.localClassInjectors = classInjectors;
    }

    public static ClassInjector[] getClassInjectors() {
        if (classInjectors == null) {
            GrailsAwareInjectionOperation.initializeState();
        }
        return classInjectors;
    }

    public ClassInjector[] getLocalClassInjectors() {
        if (this.localClassInjectors == null) {
            return GrailsAwareInjectionOperation.getClassInjectors();
        }
        return this.localClassInjectors;
    }

    private static void initializeState() {
        if (classInjectors != null) {
            return;
        }
        SimpleBeanDefinitionRegistry registry = new SimpleBeanDefinitionRegistry();
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)registry, false);
        scanner.setIncludeAnnotationConfig(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(AstTransformer.class));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        scanner.setResourceLoader((ResourceLoader)new DefaultResourceLoader(classLoader));
        scanner.scan(new String[]{INJECTOR_SCAN_PACKAGE});
        if (registry.getBeanDefinitionCount() == 0) {
            classLoader = GrailsAwareInjectionOperation.class.getClassLoader();
            scanner.setResourceLoader((ResourceLoader)new DefaultResourceLoader(classLoader));
            scanner.scan(new String[]{INJECTOR_SCAN_PACKAGE});
        }
        ArrayList<ClassInjector> injectors = new ArrayList<ClassInjector>();
        for (String beanName : registry.getBeanDefinitionNames()) {
            try {
                Class<?> injectorClass = classLoader.loadClass(registry.getBeanDefinition(beanName).getBeanClassName());
                if (!ClassInjector.class.isAssignableFrom(injectorClass)) continue;
                injectors.add((ClassInjector)injectorClass.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        Collections.sort(injectors, new Comparator<ClassInjector>(){

            @Override
            public int compare(ClassInjector classInjectorA, ClassInjector classInjectorB) {
                if (classInjectorA instanceof Comparable) {
                    return ((Comparable)((Object)classInjectorA)).compareTo(classInjectorB);
                }
                return 0;
            }
        });
        classInjectors = injectors.toArray(new ClassInjector[injectors.size()]);
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        ClassInjector[] classInjectors1;
        URL url = null;
        String filename = source.getName();
        FileSystemResource resource = new FileSystemResource(filename);
        if (resource.exists()) {
            try {
                url = resource.getURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((classInjectors1 = this.getLocalClassInjectors()) == null || classInjectors1.length == 0) {
            classInjectors1 = GrailsAwareInjectionOperation.getClassInjectors();
        }
        for (ClassInjector classInjector : classInjectors1) {
            if (!classInjector.shouldInject(url)) continue;
            classInjector.performInjection(source, context, classNode);
        }
    }
}

