/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.persistence.Entity;
import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.validation.ConstraintEvalUtils;

public class DomainClassArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsApplicationAware {
    public static final String TYPE = "Domain";
    private Map<String, Object> defaultConstraints;
    private static boolean developmentMode = Environment.isDevelopmentMode();
    static final Map<Integer, Boolean> DOMAIN_CLASS_CHECK_CACHE = new ConcurrentHashMap<Integer, Boolean>();

    public DomainClassArtefactHandler() {
        super(TYPE, GrailsDomainClass.class, DefaultGrailsDomainClass.class, null, true);
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        if (grailsApplication != null) {
            this.defaultConstraints = ConstraintEvalUtils.getDefaultConstraints(grailsApplication.getConfig());
        }
    }

    @Override
    public GrailsClass newArtefactClass(Class artefactClass) {
        return new DefaultGrailsDomainClass(artefactClass, this.defaultConstraints);
    }

    @Override
    public void initialize(ArtefactInfo artefacts) {
        this.log.debug((Object)"Configuring domain class relationships");
        GrailsDomainConfigurationUtil.configureDomainClassRelationships(artefacts.getGrailsClasses(), artefacts.getGrailsClassesByName());
    }

    @Override
    public boolean isArtefactClass(Class clazz) {
        return DomainClassArtefactHandler.isDomainClass(clazz);
    }

    public static boolean isDomainClass(Class<?> clazz, boolean allowProxyClass) {
        boolean retval = DomainClassArtefactHandler.isDomainClass(clazz);
        if (!retval && allowProxyClass && clazz != null && clazz.getSimpleName().contains("$")) {
            retval = DomainClassArtefactHandler.isDomainClass(clazz.getSuperclass());
        }
        return retval;
    }

    public static boolean isDomainClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        Integer cacheKey = System.identityHashCode(clazz);
        Boolean retval = DOMAIN_CLASS_CHECK_CACHE.get(cacheKey);
        if (retval != null) {
            return retval;
        }
        retval = DomainClassArtefactHandler.doIsDomainClassCheck(clazz);
        if (!developmentMode) {
            DOMAIN_CLASS_CHECK_CACHE.put(cacheKey, retval);
        }
        return retval;
    }

    private static boolean doIsDomainClassCheck(Class<?> clazz) {
        if (Closure.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isEnum()) {
            return false;
        }
        if (clazz.getAnnotation(Entity.class) != null) {
            return true;
        }
        for (Class<?> testClass = clazz; testClass != null && !testClass.equals(GroovyObject.class) && !testClass.equals(Object.class); testClass = testClass.getSuperclass()) {
            try {
                testClass.getDeclaredField("id");
                testClass.getDeclaredField("version");
                return true;
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return false;
    }
}

