/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.lifecycle;

import grails.util.Holders;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.cfg.ConfigurationHelper;

public class ShutdownOperations {
    private static final Log LOG = LogFactory.getLog(ShutdownOperations.class);
    private static final Collection<Runnable> shutdownOperations = new LinkedHashSet<Runnable>();
    private static final Collection<Runnable> preservedShutdownOperations = new LinkedHashSet<Runnable>();
    public static final Runnable DEFAULT_SHUTDOWN_OPERATION = new Runnable(){

        @Override
        public void run() {
            Holders.reset();
            ConfigurationHelper.clearCachedConfigs();
            ClassPropertyFetcher.clearClassPropertyFetcherCache();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void runOperations() {
        try {
            for (Runnable shutdownOperation : shutdownOperations) {
                try {
                    shutdownOperation.run();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error occurred running shutdown operation: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            shutdownOperations.clear();
            shutdownOperations.addAll(preservedShutdownOperations);
        }
    }

    public static synchronized void addOperation(Runnable runnable) {
        ShutdownOperations.addOperation(runnable, false);
    }

    public static synchronized void addOperation(Runnable runnable, boolean preserveForNextShutdown) {
        shutdownOperations.add(runnable);
        if (preserveForNextShutdown) {
            preservedShutdownOperations.add(runnable);
        }
    }

    public static synchronized void resetOperations() {
        shutdownOperations.clear();
        preservedShutdownOperations.clear();
        ShutdownOperations.addOperation(DEFAULT_SHUTDOWN_OPERATION, true);
    }

    static {
        ShutdownOperations.resetOperations();
    }
}

