/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.artefact.Artefact;
import grails.build.logging.GrailsConsole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AbstractArtefactTypeAstTransformation;
import org.codehaus.groovy.grails.compiler.injection.AllArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareInjectionOperation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ArtefactTypeAstTransformation
extends AbstractArtefactTypeAstTransformation {
    private static final ClassNode MY_TYPE = new ClassNode(Artefact.class);

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode node = (AnnotationNode)astNodes[0];
        if (!(node instanceof AnnotationNode) || !(parent instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        if (!this.isArtefactAnnotationNode(node) || !(parent instanceof ClassNode)) {
            return;
        }
        ClassNode cNode = (ClassNode)parent;
        if (cNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cNode.getName() + "'. @" + this.getAnnotationType().getNameWithoutPackage() + " not allowed for interfaces.");
        }
        if (this.isApplied(cNode)) {
            return;
        }
        String artefactType = this.resolveArtefactType(sourceUnit, node, cNode);
        this.performInjectionOnArtefactType(sourceUnit, cNode, artefactType);
        this.postProcess(sourceUnit, node, cNode, artefactType);
        this.markApplied(cNode);
    }

    protected boolean isApplied(ClassNode cNode) {
        return GrailsASTUtils.isApplied((ASTNode)cNode, this.getAstAppliedMarkerClass());
    }

    protected void markApplied(ClassNode classNode) {
        GrailsASTUtils.markApplied((ASTNode)classNode, this.getAstAppliedMarkerClass());
    }

    protected Class<?> getAstAppliedMarkerClass() {
        return ArtefactTypeAstTransformation.class;
    }

    protected void postProcess(SourceUnit sourceUnit, AnnotationNode annotationNode, ClassNode classNode, String artefactType) {
        if (!MY_TYPE.equals((Object)annotationNode.getClassNode())) {
            AnnotationNode annotation = new AnnotationNode(MY_TYPE);
            annotation.addMember("value", (Expression)new ConstantExpression((Object)artefactType));
            classNode.addAnnotation(annotation);
        }
    }

    protected String resolveArtefactType(SourceUnit sourceUnit, AnnotationNode annotationNode, ClassNode classNode) {
        Expression value = annotationNode.getMember("value");
        if (value != null && value instanceof ConstantExpression) {
            ConstantExpression ce = (ConstantExpression)value;
            return ce.getText();
        }
        throw new RuntimeException("Class [" + classNode.getName() + "] contains an invalid @Artefact annotation. No artefact found for value specified.");
    }

    protected boolean isArtefactAnnotationNode(AnnotationNode annotationNode) {
        return this.getAnnotationType().equals((Object)annotationNode.getClassNode());
    }

    protected ClassNode getAnnotationType() {
        return MY_TYPE;
    }

    @Override
    public void performInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        ArtefactTypeAstTransformation.doPerformInjectionOnArtefactType(sourceUnit, cNode, artefactType);
    }

    public static void doPerformInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        List<ClassInjector> injectors = ArtefactTypeAstTransformation.findInjectors(artefactType, GrailsAwareInjectionOperation.getClassInjectors());
        ArtefactTypeAstTransformation.performInjection(sourceUnit, cNode, injectors);
    }

    public static void performInjection(SourceUnit sourceUnit, ClassNode cNode, Collection<ClassInjector> injectors) {
        try {
            for (ClassInjector injector : injectors) {
                injector.performInjectionOnAnnotatedClass(sourceUnit, cNode);
            }
        }
        catch (RuntimeException e) {
            try {
                GrailsConsole.getInstance().error("Error occurred calling AST injector: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public static List<ClassInjector> findInjectors(String artefactType, ClassInjector[] classInjectors) {
        ArrayList<ClassInjector> injectors = new ArrayList<ClassInjector>();
        for (ClassInjector classInjector : classInjectors) {
            GrailsArtefactClassInjector gace;
            if (classInjector instanceof AllArtefactClassInjector) {
                injectors.add(classInjector);
                continue;
            }
            if (!(classInjector instanceof GrailsArtefactClassInjector) || !ArtefactTypeAstTransformation.hasArtefactType(artefactType, gace = (GrailsArtefactClassInjector)classInjector)) continue;
            injectors.add(gace);
        }
        return injectors;
    }

    public static boolean hasArtefactType(String artefactType, GrailsArtefactClassInjector gace) {
        for (String _artefactType : gace.getArtefactTypes()) {
            if (_artefactType.equals("*")) {
                return true;
            }
            if (!_artefactType.equals(artefactType)) continue;
            return true;
        }
        return false;
    }
}

