/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.codehaus.groovy.grails.compiler.AbstractDirectoryWatcher;

class PollingDirectoryWatcher
extends AbstractDirectoryWatcher {
    protected Collection<String> extensions = new ConcurrentLinkedQueue<String>();
    private Map<File, Long> lastModifiedMap = new ConcurrentHashMap<File, Long>();
    private Map<File, Collection<String>> directoryToExtensionsMap = new ConcurrentHashMap<File, Collection<String>>();
    private Map<File, Long> directoryWatch = new ConcurrentHashMap<File, Long>();

    PollingDirectoryWatcher() {
    }

    @Override
    public void run() {
        int count = 0;
        while (this.active) {
            Set<File> files = this.lastModifiedMap.keySet();
            for (File file : files) {
                Long cachedTime;
                long currentLastModified = file.lastModified();
                if (currentLastModified <= (cachedTime = this.lastModifiedMap.get(file))) continue;
                this.lastModifiedMap.put(file, currentLastModified);
                this.fireOnChange(file);
            }
            try {
                if (++count > 2) {
                    count = 0;
                    this.checkForNewFiles();
                }
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void addWatchFile(File fileToWatch) {
        this.lastModifiedMap.put(fileToWatch, fileToWatch.lastModified());
    }

    @Override
    public void addWatchDirectory(File dir, List<String> fileExtensions) {
        if (!this.isValidDirectoryToMonitor(dir)) {
            return;
        }
        this.trackDirectoryExtensions(dir, fileExtensions);
        this.cacheFilesForDirectory(dir, fileExtensions, false);
    }

    private void trackDirectoryExtensions(File dir, List<String> fileExtensions) {
        Collection<String> existingExtensions = this.directoryToExtensionsMap.get(dir);
        if (existingExtensions == null) {
            this.directoryToExtensionsMap.put(dir, new ArrayList<String>(fileExtensions));
        } else {
            existingExtensions.addAll(fileExtensions);
        }
    }

    private void checkForNewFiles() {
        for (File directory : this.directoryWatch.keySet()) {
            Long currentTimestamp = this.directoryWatch.get(directory);
            if (currentTimestamp >= directory.lastModified()) continue;
            Collection<String> extensions = this.directoryToExtensionsMap.get(directory);
            if (extensions == null) {
                extensions = this.extensions;
            }
            this.cacheFilesForDirectory(directory, extensions, true);
        }
    }

    private void cacheFilesForDirectory(File directory, Collection<String> fileExtensions, boolean fireEvent) {
        this.addExtensions(fileExtensions);
        this.directoryWatch.put(directory, directory.lastModified());
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (this.isValidDirectoryToMonitor(file)) {
                this.cacheFilesForDirectory(file, fileExtensions, fireEvent);
                continue;
            }
            if (!this.isValidFileToMonitor(file, fileExtensions)) continue;
            if (!this.lastModifiedMap.containsKey(file) && fireEvent) {
                this.fireOnNew(file);
            }
            this.lastModifiedMap.put(file, file.lastModified());
        }
    }

    private void addExtensions(Collection<String> toAdd) {
        for (String extension : toAdd) {
            if (this.extensions.contains(extension = this.removeStartingDotIfPresent(extension))) continue;
            this.extensions.add(extension);
        }
    }

    private String removeStartingDotIfPresent(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        return extension;
    }
}

