/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import java.util.Comparator;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.springframework.util.Assert;

public class DomainClassPropertyComparator
implements Comparator {
    private Map constrainedProperties;
    private GrailsDomainClass domainClass;

    public DomainClassPropertyComparator(GrailsDomainClass domainClass) {
        Assert.notNull((Object)domainClass, (String)"Argument 'domainClass' is required!");
        this.constrainedProperties = domainClass.getConstrainedProperties();
        this.domainClass = domainClass;
    }

    public int compare(Object o1, Object o2) {
        ConstrainedProperty cp2;
        if (o1.equals(this.domainClass.getIdentifier())) {
            return -1;
        }
        if (o2.equals(this.domainClass.getIdentifier())) {
            return 1;
        }
        GrailsDomainClassProperty prop1 = (GrailsDomainClassProperty)o1;
        GrailsDomainClassProperty prop2 = (GrailsDomainClassProperty)o2;
        ConstrainedProperty cp1 = (ConstrainedProperty)this.constrainedProperties.get(prop1.getName());
        if (cp1 == null & (cp2 = (ConstrainedProperty)this.constrainedProperties.get(prop2.getName())) == null) {
            return prop1.getName().compareTo(prop2.getName());
        }
        if (cp1 == null) {
            return 1;
        }
        if (cp2 == null) {
            return -1;
        }
        if (cp1.getOrder() > cp2.getOrder()) {
            return 1;
        }
        if (cp1.getOrder() < cp2.getOrder()) {
            return -1;
        }
        return 0;
    }
}

