/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.exceptions.CompilationFailedException;
import org.codehaus.groovy.grails.io.support.IOUtils;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class GrailsClassLoader
extends GroovyClassLoader {
    private GrailsResourceLoader grailsResourceLoader;
    private Map<String, GroovyClassLoader> innerClassLoaderMap = new ConcurrentHashMap<String, GroovyClassLoader>();
    private Map<String, MultipleCompilationErrorsException> compilationErrors = new ConcurrentHashMap<String, MultipleCompilationErrorsException>();

    public GrailsClassLoader() {
    }

    public GrailsClassLoader(ClassLoader parent, CompilerConfiguration config, GrailsResourceLoader resourceLoader) {
        super(parent, config);
        this.grailsResourceLoader = resourceLoader;
    }

    public boolean hasCompilationErrors() {
        return !this.compilationErrors.isEmpty();
    }

    public MultipleCompilationErrorsException getCompilationError() {
        if (this.hasCompilationErrors()) {
            return this.compilationErrors.values().iterator().next();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class<?> reloadClass(String name) {
        try {
            String path;
            Resource resourceURL = this.loadGroovySource(name);
            if (resourceURL == null) {
                return null;
            }
            GrailsAwareClassLoader innerLoader = new GrailsAwareClassLoader(this);
            this.clearCache();
            try {
                path = new File(resourceURL.getURI()).getPath();
            }
            catch (IOException e) {
                path = name;
            }
            InputStream inputStream = null;
            try {
                inputStream = resourceURL.getInputStream();
                Class reloadedClass = innerLoader.parseClass(IOGroovyMethods.getText((InputStream)inputStream, (String)"UTF-8"), path);
                this.compilationErrors.remove(name);
                this.innerClassLoaderMap.put(name, innerLoader);
                Class clazz = reloadedClass;
                return clazz;
            }
            catch (MultipleCompilationErrorsException e) {
                this.compilationErrors.put(name, e);
                throw e;
            }
            catch (IOException e) {
                throw new CompilationFailedException("Error opening stream to class " + name + " with URL " + resourceURL, e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)inputStream);
            }
        }
        catch (MalformedURLException e) {
            throw new CompilationFailedException("Error opening stream to class " + name + ":" + e.getMessage(), e);
        }
    }

    protected Resource loadGroovySource(String name) throws MalformedURLException {
        URL resourceURL = this.grailsResourceLoader.loadGroovySource(name);
        if (resourceURL == null) {
            return null;
        }
        return new UrlResource(resourceURL);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        GroovyClassLoader innerLoader = this.innerClassLoaderMap.get(name);
        if (innerLoader == null) {
            return super.loadClass(name, resolve);
        }
        return innerLoader.loadClass(name);
    }

    public void setGrailsResourceLoader(GrailsResourceLoader resourceLoader) {
        this.grailsResourceLoader = resourceLoader;
    }
}

