/*
 * Decompiled with CFR 0.152.
 */
package grails.validation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.lifecycle.ShutdownOperations;

public class DeferredBindingActions {
    private static ThreadLocal<List<Runnable>> deferredBindingActions = new ThreadLocal();
    private static Log LOG = LogFactory.getLog(DeferredBindingActions.class);

    public static void addBindingAction(Runnable runnable) {
        List<Runnable> bindingActions = DeferredBindingActions.getDeferredBindingActions();
        bindingActions.add(runnable);
    }

    private static List<Runnable> getDeferredBindingActions() {
        List<Runnable> runnables = deferredBindingActions.get();
        if (runnables == null) {
            runnables = new ArrayList<Runnable>();
            deferredBindingActions.set(runnables);
        }
        return runnables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runActions() {
        List<Runnable> runnables = deferredBindingActions.get();
        if (runnables != null) {
            try {
                for (Runnable runnable : DeferredBindingActions.getDeferredBindingActions()) {
                    if (runnable == null) continue;
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error running deferred data binding: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                DeferredBindingActions.clear();
            }
        }
    }

    public static void clear() {
        deferredBindingActions.remove();
    }

    static {
        ShutdownOperations.addOperation(new Runnable(){

            @Override
            public void run() {
                deferredBindingActions.remove();
            }
        });
    }
}

