/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.support.encoding.CharSequences;
import org.codehaus.groovy.grails.support.encoding.DefaultEncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncoderAware;
import org.codehaus.groovy.grails.support.encoding.EncodesToWriter;
import org.codehaus.groovy.grails.support.encoding.EncodesToWriterAdapter;
import org.codehaus.groovy.grails.support.encoding.EncodingState;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;
import org.codehaus.groovy.grails.support.encoding.WriterEncodedAppender;

public class StreamingEncoderWriter
extends FilterWriter
implements EncodedAppenderFactory,
EncoderAware {
    private EncodesToWriter encodesToWriter;
    private StreamingEncoder encoder;
    private EncodingStateRegistry encodingStateRegistry;

    public StreamingEncoderWriter(Writer out, StreamingEncoder encoder, EncodingStateRegistry encodingStateRegistry) {
        super(out);
        this.encoder = encoder;
        this.encodesToWriter = encoder instanceof EncodesToWriter ? (EncodesToWriter)((Object)encoder) : new EncodesToWriterAdapter(encoder, true);
        this.encodingStateRegistry = encodingStateRegistry;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.encodesToWriter.encodeToWriter(cbuf, off, len, this.out, null);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        EncodingState encodingState = this.lookupEncodingState(str, off, len);
        if (this.shouldEncodeWith(this.encoder, encodingState)) {
            this.encodesToWriter.encodeToWriter(str, off, len, this.out, encodingState);
        } else {
            this.out.write(str, off, len);
        }
    }

    protected boolean shouldEncodeWith(Encoder encoderToApply, EncodingState encodingState) {
        return encodingState == null || DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState);
    }

    protected EncodingState lookupEncodingState(String str, int off, int len) {
        if (this.encodingStateRegistry != null) {
            return this.encodingStateRegistry.getEncodingStateFor(str);
        }
        return null;
    }

    @Override
    public void write(int c) throws IOException {
        this.encodesToWriter.encodeToWriter(CharSequences.createSingleCharSequence(c), 0, 1, this.out, null);
    }

    @Override
    public EncodedAppender getEncodedAppender() {
        WriterEncodedAppender encodedAppender = new WriterEncodedAppender(this.out);
        encodedAppender.setIgnoreEncodingState(this.encodingStateRegistry == null);
        return encodedAppender;
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }
}

