/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.support.encoding.CharSequences;
import org.codehaus.groovy.grails.support.encoding.DefaultEncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodesToWriter;
import org.codehaus.groovy.grails.support.encoding.EncodingState;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;
import org.codehaus.groovy.grails.support.encoding.WriterEncodedAppender;

public class EncodesToWriterAdapter
implements EncodesToWriter {
    private final StreamingEncoder encoder;
    private boolean ignoreEncodingState;

    public EncodesToWriterAdapter(StreamingEncoder encoder) {
        this(encoder, false);
    }

    public EncodesToWriterAdapter(StreamingEncoder encoder, boolean ignoreEncodingState) {
        this.encoder = encoder;
        this.ignoreEncodingState = ignoreEncodingState;
    }

    @Override
    public void encodeToWriter(CharSequence str, int off, int len, Writer writer, EncodingState encodingState) throws IOException {
        if (this.shouldEncodeWith(this.encoder, encodingState)) {
            this.encoder.encodeToStream(this.encoder, str, off, len, new WriterEncodedAppender(writer), encodingState);
        } else {
            CharSequences.writeCharSequence(writer, str, off, len);
        }
    }

    @Override
    public void encodeToWriter(char[] buf, int off, int len, Writer writer, EncodingState encodingState) throws IOException {
        if (this.shouldEncodeWith(this.encoder, encodingState)) {
            this.encoder.encodeToStream(this.encoder, CharSequences.createCharSequence(buf, off, len), 0, len, new WriterEncodedAppender(writer), encodingState);
        } else {
            writer.write(buf, off, len);
        }
    }

    protected boolean shouldEncodeWith(Encoder encoderToApply, EncodingState encodingState) {
        return this.ignoreEncodingState || encodingState == null || DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState);
    }

    public StreamingEncoder getEncoder() {
        return this.encoder;
    }

    public boolean isIgnoreEncodingState() {
        return this.ignoreEncodingState;
    }

    public void setIgnoreEncodingState(boolean ignoreEncodingState) {
        this.ignoreEncodingState = ignoreEncodingState;
    }
}

