/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.artefact.Artefact;
import grails.build.logging.GrailsConsole;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AbstractArtefactTypeAstTransformation;
import org.codehaus.groovy.grails.compiler.injection.AllArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareInjectionOperation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ArtefactTypeAstTransformation
extends AbstractArtefactTypeAstTransformation {
    private static final ClassNode MY_TYPE = new ClassNode(Artefact.class);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode node = (AnnotationNode)astNodes[0];
        if (!MY_TYPE.equals((Object)node.getClassNode()) || !(parent instanceof ClassNode)) {
            return;
        }
        ClassNode cNode = (ClassNode)parent;
        String cName = cNode.getName();
        if (cNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cName + "'. " + MY_TYPE_NAME + " not allowed for interfaces.");
        }
        Expression value = node.getMember("value");
        if (value == null || !(value instanceof ConstantExpression)) {
            throw new RuntimeException("Class [" + cName + "] contains an invalid @Artefact annotation. No artefact found for value specified.");
        }
        ConstantExpression ce = (ConstantExpression)value;
        String artefactType = ce.getText();
        this.performInjectionOnArtefactType(sourceUnit, cNode, artefactType);
    }

    @Override
    public void performInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        ArtefactTypeAstTransformation.doPerformInjectionOnArtefactType(sourceUnit, cNode, artefactType);
    }

    public static void doPerformInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        try {
            List<ClassInjector> injectors = ArtefactTypeAstTransformation.findInjectors(artefactType, GrailsAwareInjectionOperation.getClassInjectors());
            for (ClassInjector injector : injectors) {
                injector.performInjectionOnAnnotatedClass(sourceUnit, cNode);
            }
        }
        catch (RuntimeException e) {
            try {
                GrailsConsole.getInstance().error("Error occurred calling AST injector: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public static List<ClassInjector> findInjectors(String artefactType, ClassInjector[] classInjectors) {
        ArrayList<ClassInjector> injectors = new ArrayList<ClassInjector>();
        for (ClassInjector classInjector : classInjectors) {
            GrailsArtefactClassInjector gace;
            if (classInjector instanceof AllArtefactClassInjector) {
                injectors.add(classInjector);
                continue;
            }
            if (!(classInjector instanceof GrailsArtefactClassInjector) || !ArtefactTypeAstTransformation.hasArtefactType(artefactType, gace = (GrailsArtefactClassInjector)classInjector)) continue;
            injectors.add(gace);
        }
        return injectors;
    }

    public static boolean hasArtefactType(String artefactType, GrailsArtefactClassInjector gace) {
        for (String _artefactType : gace.getArtefactTypes()) {
            if (_artefactType.equals("*")) {
                return true;
            }
            if (!_artefactType.equals(artefactType)) continue;
            return true;
        }
        return false;
    }
}

