/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.CollectionUtils;
import groovy.lang.GroovyObject;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.DefaultConstraintEvaluator;
import org.springframework.validation.Errors;

public class GrailsDomainConfigurationUtil {
    public static final String PROPERTY_NAME = "constraints";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String PROPERTIES_PROPERTY = "properties";
    private static final Set<String> BASIC_TYPES;
    private static final Set<String> CONFIGURATIONAL_PROPERTIES;

    public static Serializable getAssociationIdentifier(Object target, String propertyName, GrailsDomainClass referencedDomainClass) {
        String getterName = GrailsClassUtils.getGetterName(propertyName);
        try {
            Method m = target.getClass().getMethod(getterName, EMPTY_CLASS_ARRAY);
            Object value = m.invoke(target, new Object[0]);
            if (value != null && referencedDomainClass != null) {
                String identifierGetter = GrailsClassUtils.getGetterName(referencedDomainClass.getIdentifier().getName());
                m = value.getClass().getDeclaredMethod(identifierGetter, EMPTY_CLASS_ARRAY);
                return (Serializable)m.invoke(value, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return null;
    }

    public static void configureDomainClassRelationships(GrailsClass[] domainClasses, Map<?, ?> domainMap) {
        GrailsDomainClassProperty[] props;
        GrailsDomainClass domainClass;
        for (GrailsClass grailsClass : domainClasses) {
            domainClass = (GrailsDomainClass)grailsClass;
            if (!domainClass.isRoot()) {
                GrailsDomainClass gdc;
                Class superClass = grailsClass.getClazz().getSuperclass();
                while (!superClass.equals(Object.class) && !superClass.equals(GroovyObject.class) && (gdc = (GrailsDomainClass)domainMap.get(superClass.getName())) != null && gdc.getSubClasses() != null) {
                    gdc.getSubClasses().add((GrailsDomainClass)grailsClass);
                    superClass = superClass.getSuperclass();
                }
            }
            for (GrailsDomainClassProperty prop : props = domainClass.getPersistentProperties()) {
                if (prop == null || !prop.isAssociation()) continue;
                GrailsDomainClass referencedGrailsDomainClass = (GrailsDomainClass)domainMap.get(prop.getReferencedPropertyType().getName());
                prop.setReferencedDomainClass(referencedGrailsDomainClass);
            }
        }
        for (GrailsClass domainClass1 : domainClasses) {
            domainClass = (GrailsDomainClass)domainClass1;
            block6: for (GrailsDomainClassProperty prop : props = domainClass.getPersistentProperties()) {
                GrailsDomainClass referenced;
                if (prop == null || !prop.isAssociation() || (referenced = prop.getReferencedDomainClass()) == null) continue;
                boolean isOwnedBy = referenced.isOwningClass(domainClass.getClazz());
                prop.setOwningSide(isOwnedBy);
                String refPropertyName = null;
                try {
                    refPropertyName = prop.getReferencedPropertyName();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                if (StringUtils.isBlank((String)refPropertyName)) {
                    GrailsDomainClassProperty[] referencedProperties;
                    for (GrailsDomainClassProperty referencedProp : referencedProperties = referenced.getPersistentProperties()) {
                        if (prop.equals(referencedProp) && prop.isBidirectional() || !GrailsDomainConfigurationUtil.isCandidateForOtherSide(domainClass, prop, referencedProp)) continue;
                        prop.setOtherSide(referencedProp);
                        continue block6;
                    }
                    continue;
                }
                GrailsDomainClassProperty otherSide = referenced.getPropertyByName(refPropertyName);
                prop.setOtherSide(otherSide);
                otherSide.setOtherSide(prop);
            }
        }
    }

    private static boolean isCandidateForOtherSide(GrailsDomainClass domainClass, GrailsDomainClassProperty prop, GrailsDomainClassProperty referencedProp) {
        if (prop.equals(referencedProp)) {
            return false;
        }
        if (prop.isOneToMany() && referencedProp.isOneToMany()) {
            return false;
        }
        Class referencedPropertyType = referencedProp.getReferencedPropertyType();
        if (referencedPropertyType == null || !referencedPropertyType.isAssignableFrom(domainClass.getClazz())) {
            return false;
        }
        Map mappedBy = domainClass.getMappedBy();
        Object propertyMapping = mappedBy.get(prop.getName());
        boolean mappedToDifferentProperty = propertyMapping != null && !propertyMapping.equals(referencedProp.getName());
        mappedBy = referencedProp.getDomainClass().getMappedBy();
        propertyMapping = mappedBy.get(referencedProp.getName());
        boolean mappedFromDifferentProperty = propertyMapping != null && !propertyMapping.equals(prop.getName());
        return !mappedToDifferentProperty && !mappedFromDifferentProperty;
    }

    public static String getMappingFileName(String className) {
        return className.replaceAll("\\.", "/") + ".hbm.xml";
    }

    public static Map<?, ?> getAssociationMap(Class<?> domainClass) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(domainClass);
        Map associationMap = cpf.getPropertyValue("hasMany", Map.class);
        if (associationMap == null) {
            associationMap = Collections.EMPTY_MAP;
        }
        return associationMap;
    }

    public static Map<?, ?> getMappedByMap(Class<?> domainClass) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(domainClass);
        Map mappedByMap = cpf.getPropertyValue("mappedBy", Map.class);
        if (mappedByMap == null) {
            return Collections.EMPTY_MAP;
        }
        return mappedByMap;
    }

    public static boolean isBasicType(GrailsDomainClassProperty prop) {
        return prop == null ? false : GrailsDomainConfigurationUtil.isBasicType(prop.getType());
    }

    public static boolean isBasicType(Class<?> propType) {
        if (propType == null) {
            return false;
        }
        if (propType.isArray()) {
            return GrailsDomainConfigurationUtil.isBasicType(propType.getComponentType());
        }
        return BASIC_TYPES.contains(propType.getName());
    }

    public static boolean isNotConfigurational(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        Method readMethod = descriptor.getReadMethod();
        Method writeMethod = descriptor.getWriteMethod();
        if (readMethod != null && Modifier.isStatic(readMethod.getModifiers()) || writeMethod != null && Modifier.isStatic(writeMethod.getModifiers())) {
            return false;
        }
        return !Errors.class.isAssignableFrom(descriptor.getPropertyType()) && GrailsDomainConfigurationUtil.isNotConfigurational(name);
    }

    public static boolean isConfigurational(String name) {
        return CONFIGURATIONAL_PROPERTIES.contains(name);
    }

    public static boolean isNotConfigurational(String name) {
        return !GrailsDomainConfigurationUtil.isConfigurational(name);
    }

    @Deprecated
    public static Map<String, ConstrainedProperty> evaluateConstraints(Object instance, GrailsDomainClassProperty[] properties, Map<String, Object> defaultConstraints) {
        Class<?> theClass = instance.getClass();
        return new DefaultConstraintEvaluator(defaultConstraints).evaluate(theClass, properties);
    }

    @Deprecated
    public static Map<String, ConstrainedProperty> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] properties, Map<String, Object> defaultConstraints) {
        return new DefaultConstraintEvaluator(defaultConstraints).evaluate(theClass, properties);
    }

    @Deprecated
    public static Map<String, ConstrainedProperty> evaluateConstraints(Object instance, GrailsDomainClassProperty[] properties) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(instance, properties, null);
    }

    @Deprecated
    public static Map<String, ConstrainedProperty> evaluateConstraints(Object instance) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(instance, null, null);
    }

    @Deprecated
    public static Map<String, ConstrainedProperty> evaluateConstraints(Class<?> theClass) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(theClass, null, null);
    }

    @Deprecated
    public static Map<String, ConstrainedProperty> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] properties) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(theClass, properties, null);
    }

    public static LinkedList<?> getSuperClassChain(Class<?> theClass) {
        LinkedList classChain = new LinkedList();
        for (Class<?> clazz = theClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            classChain.addFirst(clazz);
        }
        return classChain;
    }

    static {
        Set basics = CollectionUtils.newSet((Object[])new String[]{Boolean.TYPE.getName(), Long.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Byte.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.class.getName(), Long.class.getName(), Short.class.getName(), Integer.class.getName(), Byte.class.getName(), Float.class.getName(), Double.class.getName(), Character.class.getName(), String.class.getName(), java.util.Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), Date.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Locale.class.getName(), Calendar.class.getName(), GregorianCalendar.class.getName(), Currency.class.getName(), TimeZone.class.getName(), Object.class.getName(), Class.class.getName(), byte[].class.getName(), Byte[].class.getName(), char[].class.getName(), Character[].class.getName(), Blob.class.getName(), Clob.class.getName(), Serializable.class.getName(), URI.class.getName(), URL.class.getName()});
        BASIC_TYPES = Collections.unmodifiableSet(basics);
        Set configurational = CollectionUtils.newSet((Object[])new String[]{"metaClass", "class", "transients", "attached", "dirty", "dirtyPropertyNames", "relatesToMany", "hasMany", "evanescent", PROPERTY_NAME, "mapWith", "mappedBy", "belongsTo", "errors", PROPERTIES_PROPERTY});
        CONFIGURATIONAL_PROPERTIES = Collections.unmodifiableSet(configurational);
    }
}

