/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.build.logging.GrailsConsole;
import grails.util.GrailsNameUtils;
import groovy.lang.MissingMethodException;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;

public class GrailsASTUtils {
    public static final String DOMAIN_DIR = "domain";
    public static final String GRAILS_APP_DIR = "grails-app";
    public static final String METHOD_MISSING_METHOD_NAME = "methodMissing";
    public static final String STATIC_METHOD_MISSING_METHOD_NAME = "$static_methodMissing";
    public static final Token EQUALS_OPERATOR = Token.newSymbol((String)"==", (int)0, (int)0);
    public static final Token LOGICAL_AND_OPERATOR = Token.newSymbol((String)"&&", (int)0, (int)0);
    public static final Token NOT_EQUALS_OPERATOR = Token.newSymbol((String)"!=", (int)0, (int)0);
    public static final ClassNode MISSING_METHOD_EXCEPTION = new ClassNode(MissingMethodException.class);
    public static final ConstantExpression NULL_EXPRESSION = new ConstantExpression(null);
    public static final Token ASSIGNMENT_OPERATOR = Token.newSymbol((int)1100, (int)0, (int)0);
    public static final ClassNode OBJECT_CLASS_NODE = new ClassNode(Object.class).getPlainNodeReference();
    public static final ClassNode VOID_CLASS_NODE = ClassHelper.VOID_TYPE;
    public static final ClassNode INTEGER_CLASS_NODE = new ClassNode(Integer.class).getPlainNodeReference();
    public static final VariableExpression THIS_EXPR = new VariableExpression("this");
    public static final Parameter[] ZERO_PARAMETERS = new Parameter[0];
    public static final ArgumentListExpression ZERO_ARGUMENTS = new ArgumentListExpression();

    public static void warning(SourceUnit sourceUnit, ASTNode node, String warningMessage) {
        String sample = sourceUnit.getSample(node.getLineNumber(), node.getColumnNumber(), new Janitor());
        GrailsConsole.getInstance().warning(warningMessage + "\n\n" + sample);
    }

    public static void error(SourceUnit sourceUnit, ASTNode astNode, String message) {
        GrailsASTUtils.error(sourceUnit, astNode, message, true);
    }

    public static void error(SourceUnit sourceUnit, ASTNode astNode, String message, boolean fatal) {
        SyntaxException syntaxException = new SyntaxException(message, astNode.getLineNumber(), astNode.getColumnNumber());
        SyntaxErrorMessage syntaxErrorMessage = new SyntaxErrorMessage(syntaxException, sourceUnit);
        sourceUnit.getErrorCollector().addError((Message)syntaxErrorMessage, fatal);
    }

    public static boolean hasProperty(ClassNode classNode, String propertyName) {
        if (classNode == null || StringUtils.isBlank((String)propertyName)) {
            return false;
        }
        MethodNode method = classNode.getMethod(GrailsNameUtils.getGetterName((String)propertyName), Parameter.EMPTY_ARRAY);
        if (method != null) {
            return true;
        }
        for (PropertyNode pn : classNode.getProperties()) {
            if (!pn.getName().equals(propertyName) || pn.isPrivate()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOrInheritsProperty(ClassNode classNode, String propertyName) {
        if (GrailsASTUtils.hasProperty(classNode, propertyName)) {
            return true;
        }
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals("java.lang.Object"); parent = parent.getSuperClass()) {
            if (!GrailsASTUtils.hasProperty(parent, propertyName)) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsZeroArgMethod(ClassNode classNode, String methodName) {
        MethodNode method = classNode.getDeclaredMethod(methodName, Parameter.EMPTY_ARRAY);
        return method != null && (method.isPublic() || method.isProtected()) && !method.isAbstract();
    }

    public static boolean implementsOrInheritsZeroArgMethod(ClassNode classNode, String methodName, List ignoreClasses) {
        if (GrailsASTUtils.implementsZeroArgMethod(classNode, methodName)) {
            return true;
        }
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals("java.lang.Object"); parent = parent.getSuperClass()) {
            if (ignoreClasses.contains(parent) || !GrailsASTUtils.implementsZeroArgMethod(parent, methodName)) continue;
            return true;
        }
        return false;
    }

    public static String getFullName(ClassNode classNode) {
        return classNode.getName();
    }

    public static ClassNode getFurthestParent(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals("java.lang.Object"); parent = parent.getSuperClass()) {
            classNode = parent;
        }
        return classNode;
    }

    public static ClassNode getFurthestUnresolvedParent(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); !(parent == null || GrailsASTUtils.getFullName(parent).equals("java.lang.Object") || parent.isResolved() || Modifier.isAbstract(parent.getModifiers())); parent = parent.getSuperClass()) {
            classNode = parent;
        }
        return classNode;
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, null, true);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, markerAnnotation, true);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, boolean thisAsFirstArgument) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, null, thisAsFirstArgument);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation, boolean thisAsFirstArgument) {
        return GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, markerAnnotation, thisAsFirstArgument, null);
    }

    public static MethodNode addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation, boolean thisAsFirstArgument, Map<String, ClassNode> genericsPlaceholders) {
        Parameter[] parameterTypes = thisAsFirstArgument ? GrailsASTUtils.getRemainingParameterTypes(declaredMethod.getParameters()) : declaredMethod.getParameters();
        String methodName = declaredMethod.getName();
        if (classNode.hasDeclaredMethod(methodName, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders))) {
            return null;
        }
        String propertyName = GrailsClassUtils.getPropertyForGetter(methodName);
        if (propertyName != null && parameterTypes.length == 0 && classNode.hasProperty(propertyName)) {
            return null;
        }
        propertyName = GrailsClassUtils.getPropertyForSetter(methodName);
        if (propertyName != null && parameterTypes.length == 1 && classNode.hasProperty(propertyName)) {
            return null;
        }
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = GrailsASTUtils.createArgumentListFromParameters(parameterTypes, thisAsFirstArgument, genericsPlaceholders);
        ClassNode returnType = GrailsASTUtils.replaceGenericsPlaceholders(declaredMethod.getReturnType(), genericsPlaceholders);
        MethodCallExpression methodCallExpression = new MethodCallExpression(delegate, methodName, (Expression)arguments);
        methodCallExpression.setMethodTarget(declaredMethod);
        ThrowStatement missingMethodException = GrailsASTUtils.createMissingMethodThrowable(classNode, declaredMethod);
        VariableExpression apiVar = GrailsASTUtils.addApiVariableDeclaration(delegate, declaredMethod, methodBody);
        IfStatement ifStatement = GrailsASTUtils.createIfElseStatementForApiMethodCall(methodCallExpression, apiVar, missingMethodException);
        methodBody.addStatement((Statement)ifStatement);
        MethodNode methodNode = new MethodNode(methodName, 1, returnType, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders), GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)methodBody);
        methodNode.addAnnotations(declaredMethod.getAnnotations());
        if (GrailsASTUtils.shouldAddMarkerAnnotation(markerAnnotation, methodNode)) {
            methodNode.addAnnotation(markerAnnotation);
        }
        classNode.addMethod(methodNode);
        return methodNode;
    }

    private static boolean shouldAddMarkerAnnotation(AnnotationNode markerAnnotation, MethodNode methodNode) {
        return markerAnnotation != null && methodNode.getAnnotations(markerAnnotation.getClassNode()).isEmpty();
    }

    private static IfStatement createIfElseStatementForApiMethodCall(MethodCallExpression methodCallExpression, VariableExpression apiVar, ThrowStatement missingMethodException) {
        BlockStatement ifBlock = new BlockStatement();
        ifBlock.addStatement((Statement)missingMethodException);
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement((Statement)new ExpressionStatement((Expression)methodCallExpression));
        return new IfStatement(new BooleanExpression((Expression)new BinaryExpression((Expression)apiVar, EQUALS_OPERATOR, (Expression)NULL_EXPRESSION)), (Statement)ifBlock, (Statement)elseBlock);
    }

    private static VariableExpression addApiVariableDeclaration(Expression delegate, MethodNode declaredMethod, BlockStatement methodBody) {
        VariableExpression apiVar = new VariableExpression("$api_" + declaredMethod.getName());
        DeclarationExpression de = new DeclarationExpression(apiVar, ASSIGNMENT_OPERATOR, delegate);
        methodBody.addStatement((Statement)new ExpressionStatement((Expression)de));
        return apiVar;
    }

    private static ThrowStatement createMissingMethodThrowable(ClassNode classNode, MethodNode declaredMethodNode) {
        ArgumentListExpression exceptionArgs = new ArgumentListExpression();
        exceptionArgs.addExpression((Expression)new ConstantExpression((Object)declaredMethodNode.getName()));
        exceptionArgs.addExpression((Expression)new ClassExpression(classNode));
        return new ThrowStatement((Expression)new ConstructorCallExpression(MISSING_METHOD_EXCEPTION, (Expression)exceptionArgs));
    }

    public static ArgumentListExpression createArgumentListFromParameters(Parameter[] parameterTypes, boolean thisAsFirstArgument, Map<String, ClassNode> genericsPlaceholders) {
        ArgumentListExpression arguments = new ArgumentListExpression();
        if (thisAsFirstArgument) {
            arguments.addExpression((Expression)AbstractGrailsArtefactTransformer.THIS_EXPRESSION);
        }
        for (Parameter parameterType : parameterTypes) {
            arguments.addExpression((Expression)new VariableExpression(parameterType.getName(), GrailsASTUtils.replaceGenericsPlaceholders(parameterType.getType(), genericsPlaceholders)));
        }
        return arguments;
    }

    public static Parameter[] getRemainingParameterTypes(Parameter[] parameters) {
        if (parameters.length == 0) {
            return GrailsArtefactClassInjector.ZERO_PARAMETERS;
        }
        Parameter[] newParameters = new Parameter[parameters.length - 1];
        System.arraycopy(parameters, 1, newParameters, 0, parameters.length - 1);
        return newParameters;
    }

    public static MethodNode addDelegateStaticMethod(ClassNode classNode, MethodNode delegateMethod) {
        ClassExpression classExpression = new ClassExpression(delegateMethod.getDeclaringClass());
        return GrailsASTUtils.addDelegateStaticMethod((Expression)classExpression, classNode, delegateMethod);
    }

    public static MethodNode addDelegateStaticMethod(Expression expression, ClassNode classNode, MethodNode delegateMethod) {
        return GrailsASTUtils.addDelegateStaticMethod(expression, classNode, delegateMethod, null, null);
    }

    public static MethodNode addDelegateStaticMethod(Expression expression, ClassNode classNode, MethodNode delegateMethod, AnnotationNode markerAnnotation, Map<String, ClassNode> genericsPlaceholders) {
        MethodNode methodNode;
        Parameter[] parameterTypes = delegateMethod.getParameters();
        String declaredMethodName = delegateMethod.getName();
        if (classNode.hasDeclaredMethod(declaredMethodName, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders))) {
            return null;
        }
        BlockStatement methodBody = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        for (Parameter parameterType : parameterTypes) {
            arguments.addExpression((Expression)new VariableExpression(parameterType.getName()));
        }
        MethodCallExpression methodCallExpression = new MethodCallExpression(expression, declaredMethodName, (Expression)arguments);
        methodCallExpression.setMethodTarget(delegateMethod);
        ThrowStatement missingMethodException = GrailsASTUtils.createMissingMethodThrowable(classNode, delegateMethod);
        VariableExpression apiVar = GrailsASTUtils.addApiVariableDeclaration(expression, delegateMethod, methodBody);
        IfStatement ifStatement = GrailsASTUtils.createIfElseStatementForApiMethodCall(methodCallExpression, apiVar, missingMethodException);
        methodBody.addStatement((Statement)ifStatement);
        ClassNode returnType = GrailsASTUtils.replaceGenericsPlaceholders(delegateMethod.getReturnType(), genericsPlaceholders);
        if (METHOD_MISSING_METHOD_NAME.equals(declaredMethodName)) {
            declaredMethodName = STATIC_METHOD_MISSING_METHOD_NAME;
        }
        if ((methodNode = classNode.getDeclaredMethod(declaredMethodName, parameterTypes)) == null) {
            methodNode = new MethodNode(declaredMethodName, 9, returnType, GrailsASTUtils.copyParameters(parameterTypes, genericsPlaceholders), GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)methodBody);
            methodNode.addAnnotations(delegateMethod.getAnnotations());
            if (GrailsASTUtils.shouldAddMarkerAnnotation(markerAnnotation, methodNode)) {
                methodNode.addAnnotation(markerAnnotation);
            }
            classNode.addMethod(methodNode);
        }
        return methodNode;
    }

    public static void addDelegateConstructor(ClassNode classNode, MethodNode constructorMethod, Map<String, ClassNode> genericsPlaceholders) {
        BlockStatement constructorBody = new BlockStatement();
        Parameter[] constructorParams = GrailsASTUtils.getRemainingParameterTypes(constructorMethod.getParameters());
        ArgumentListExpression arguments = GrailsASTUtils.createArgumentListFromParameters(constructorParams, true, genericsPlaceholders);
        MethodCallExpression constructCallExpression = new MethodCallExpression((Expression)new ClassExpression(constructorMethod.getDeclaringClass()), "initialize", (Expression)arguments);
        constructCallExpression.setMethodTarget(constructorMethod);
        ExpressionStatement constructorInitExpression = new ExpressionStatement((Expression)constructCallExpression);
        if (constructorParams.length > 0) {
            constructorBody.addStatement((Statement)new ExpressionStatement((Expression)new ConstructorCallExpression(ClassNode.THIS, (Expression)GrailsArtefactClassInjector.ZERO_ARGS)));
        }
        constructorBody.addStatement((Statement)constructorInitExpression);
        if (constructorParams.length == 0) {
            ConstructorNode constructorNode = GrailsASTUtils.getDefaultConstructor(classNode);
            if (constructorNode != null) {
                List annotations = constructorNode.getAnnotations(new ClassNode(GrailsDelegatingConstructor.class));
                if (annotations.size() == 0) {
                    Statement existingBodyCode = constructorNode.getCode();
                    if (existingBodyCode instanceof BlockStatement) {
                        ((BlockStatement)existingBodyCode).addStatement((Statement)constructorInitExpression);
                    } else {
                        constructorNode.setCode((Statement)constructorBody);
                    }
                }
            } else {
                constructorNode = new ConstructorNode(1, (Statement)constructorBody);
                classNode.addConstructor(constructorNode);
            }
            constructorNode.addAnnotation(new AnnotationNode(new ClassNode(GrailsDelegatingConstructor.class)));
        } else {
            ConstructorNode cn = GrailsASTUtils.findConstructor(classNode, constructorParams);
            if (cn == null) {
                cn = new ConstructorNode(1, GrailsASTUtils.copyParameters(constructorParams, genericsPlaceholders), null, (Statement)constructorBody);
                classNode.addConstructor(cn);
            } else {
                List annotations = cn.getAnnotations(new ClassNode(GrailsDelegatingConstructor.class));
                if (annotations.size() == 0) {
                    Statement code = cn.getCode();
                    constructorBody.addStatement(code);
                    cn.setCode((Statement)constructorBody);
                }
            }
            ConstructorNode defaultConstructor = GrailsASTUtils.getDefaultConstructor(classNode);
            if (defaultConstructor == null) {
                classNode.addConstructor(new ConstructorNode(1, (Statement)new BlockStatement()));
            }
            cn.addAnnotation(new AnnotationNode(new ClassNode(GrailsDelegatingConstructor.class)));
        }
    }

    public static ConstructorNode findConstructor(ClassNode classNode, Parameter[] constructorParams) {
        List declaredConstructors = classNode.getDeclaredConstructors();
        for (ConstructorNode declaredConstructor : declaredConstructors) {
            if (!GrailsASTUtils.parametersEqual(constructorParams, declaredConstructor.getParameters())) continue;
            return declaredConstructor;
        }
        return null;
    }

    public static boolean parametersEqual(Parameter[] a, Parameter[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getType().equals((Object)b[i].getType())) continue;
            return false;
        }
        return true;
    }

    public static ConstructorNode getDefaultConstructor(ClassNode classNode) {
        for (ConstructorNode cons : classNode.getDeclaredConstructors()) {
            if (cons.getParameters().length != 0) continue;
            return cons;
        }
        return null;
    }

    private static Parameter[] copyParameters(Parameter[] parameterTypes, Map<String, ClassNode> genericsPlaceholders) {
        Parameter[] newParameterTypes = new Parameter[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameterType = parameterTypes[i];
            Parameter newParameter = new Parameter(GrailsASTUtils.replaceGenericsPlaceholders(parameterType.getType(), genericsPlaceholders), parameterType.getName(), parameterType.getInitialExpression());
            newParameter.addAnnotations(parameterType.getAnnotations());
            newParameterTypes[i] = newParameter;
        }
        return newParameterTypes;
    }

    public static ClassNode nonGeneric(ClassNode type) {
        return GrailsASTUtils.replaceGenericsPlaceholders(type, null);
    }

    public static ClassNode replaceGenericsPlaceholders(ClassNode type, Map<String, ClassNode> genericsPlaceholders) {
        if (type.isArray()) {
            return GrailsASTUtils.replaceGenericsPlaceholders(type.getComponentType(), genericsPlaceholders).makeArray();
        }
        if (!type.isUsingGenerics() && !type.isRedirectNode()) {
            return type.getPlainNodeReference();
        }
        if (type.isGenericsPlaceHolder()) {
            ClassNode placeHolderType;
            ClassNode classNode = placeHolderType = genericsPlaceholders != null ? genericsPlaceholders.get(type.getUnresolvedName()) : null;
            if (placeHolderType != null) {
                return placeHolderType.getPlainNodeReference();
            }
            return ClassHelper.make(Object.class).getPlainNodeReference();
        }
        ClassNode nonGen = type.getPlainNodeReference();
        GenericsType[] parameterized = type.getGenericsTypes();
        if (parameterized != null && parameterized.length > 0) {
            GenericsType[] copiedGenericsTypes = new GenericsType[parameterized.length];
            for (int i = 0; i < parameterized.length; ++i) {
                GenericsType parameterizedType = parameterized[i];
                GenericsType copiedGenericsType = null;
                if (parameterizedType.isPlaceholder()) {
                    ClassNode placeHolderType;
                    ClassNode classNode = placeHolderType = genericsPlaceholders != null ? genericsPlaceholders.get(parameterizedType.getName()) : null;
                    copiedGenericsType = placeHolderType != null ? new GenericsType(placeHolderType.getPlainNodeReference()) : new GenericsType(ClassHelper.make(Object.class).getPlainNodeReference());
                } else {
                    copiedGenericsType = new GenericsType(GrailsASTUtils.replaceGenericsPlaceholders(parameterizedType.getType(), genericsPlaceholders));
                }
                copiedGenericsTypes[i] = copiedGenericsType;
            }
            nonGen.setGenericsTypes(copiedGenericsTypes);
        }
        return nonGen;
    }

    public static boolean isCandidateInstanceMethod(ClassNode classNode, MethodNode declaredMethod) {
        Parameter[] parameterTypes = declaredMethod.getParameters();
        return GrailsASTUtils.isCandidateMethod(declaredMethod) && parameterTypes != null && parameterTypes.length > 0 && GrailsASTUtils.isAssignableFrom(parameterTypes[0].getType(), classNode);
    }

    private static boolean isAssignableFrom(ClassNode superClass, ClassNode childClass) {
        for (ClassNode currentSuper = childClass; currentSuper != null; currentSuper = currentSuper.getSuperClass()) {
            if (!currentSuper.equals((Object)superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCandidateMethod(MethodNode declaredMethod) {
        return !declaredMethod.isSynthetic() && !declaredMethod.getName().contains("$") && Modifier.isPublic(declaredMethod.getModifiers()) && !Modifier.isAbstract(declaredMethod.getModifiers());
    }

    public static boolean isConstructorMethod(MethodNode declaredMethod) {
        return declaredMethod.isStatic() && declaredMethod.isPublic() && declaredMethod.getName().equals("initialize") && declaredMethod.getParameters().length >= 1 && declaredMethod.getParameters()[0].getType().equals((Object)AbstractGrailsArtefactTransformer.OBJECT_CLASS);
    }

    public static boolean isDomainClass(ClassNode classNode, SourceUnit sourceNode) {
        boolean isDomainClass = GrailsASTUtils.hasAnyAnnotations(classNode, grails.persistence.Entity.class, Entity.class);
        if (!isDomainClass) {
            String sourcePath = sourceNode.getName();
            File sourceFile = new File(sourcePath);
            File parent = sourceFile.getParentFile();
            while (parent != null && !isDomainClass) {
                File parentParent = parent.getParentFile();
                if (parent.getName().equals(DOMAIN_DIR) && parentParent != null && parentParent.getName().equals(GRAILS_APP_DIR)) {
                    isDomainClass = true;
                }
                parent = parentParent;
            }
        }
        return isDomainClass;
    }

    public static void addDelegateInstanceMethods(ClassNode classNode, ClassNode delegateNode, Expression delegateInstance) {
        GrailsASTUtils.addDelegateInstanceMethods(classNode, delegateNode, delegateInstance, null);
    }

    public static void addDelegateInstanceMethods(ClassNode classNode, ClassNode delegateNode, Expression delegateInstance, Map<String, ClassNode> genericsPlaceholders) {
        GrailsASTUtils.addDelegateInstanceMethods(classNode, classNode, delegateNode, delegateInstance, genericsPlaceholders);
    }

    public static void addDelegateInstanceMethods(ClassNode supportedSuperType, ClassNode classNode, ClassNode delegateNode, Expression delegateInstance) {
        GrailsASTUtils.addDelegateInstanceMethods(supportedSuperType, classNode, delegateNode, delegateInstance, null);
    }

    public static void addDelegateInstanceMethods(ClassNode supportedSuperType, ClassNode classNode, ClassNode delegateNode, Expression delegateInstance, Map<String, ClassNode> genericsPlaceholders) {
        while (!delegateNode.equals((Object)AbstractGrailsArtefactTransformer.OBJECT_CLASS)) {
            List declaredMethods = delegateNode.getMethods();
            for (MethodNode declaredMethod : declaredMethods) {
                if (GrailsASTUtils.isConstructorMethod(declaredMethod)) {
                    GrailsASTUtils.addDelegateConstructor(classNode, declaredMethod, genericsPlaceholders);
                    continue;
                }
                if (!GrailsASTUtils.isCandidateInstanceMethod(supportedSuperType, declaredMethod)) continue;
                GrailsASTUtils.addDelegateInstanceMethod(classNode, delegateInstance, declaredMethod, null, true, genericsPlaceholders);
            }
            delegateNode = delegateNode.getSuperClass();
        }
    }

    public static FieldNode addFieldIfNonExistent(ClassNode classNode, ClassNode fieldType, String fieldName) {
        if (classNode != null && classNode.getField(fieldName) == null) {
            return classNode.addField(fieldName, 2, fieldType, (Expression)new ConstructorCallExpression(fieldType, (Expression)new ArgumentListExpression()));
        }
        return null;
    }

    public static void addAnnotationIfNecessary(ClassNode classNode, Class<grails.persistence.Entity> entityClass) {
        List annotations = classNode.getAnnotations();
        ClassNode annotationClassNode = new ClassNode(grails.persistence.Entity.class);
        AnnotationNode annotationToAdd = new AnnotationNode(annotationClassNode);
        if (annotations.isEmpty()) {
            classNode.addAnnotation(annotationToAdd);
        } else {
            boolean foundAnn;
            boolean bl = foundAnn = GrailsASTUtils.findAnnotation(annotationClassNode, annotations) != null;
            if (!foundAnn) {
                classNode.addAnnotation(annotationToAdd);
            }
        }
    }

    public static AnnotationNode findAnnotation(ClassNode annotationClassNode, List<AnnotationNode> annotations) {
        for (AnnotationNode annotation : annotations) {
            if (!annotation.getClassNode().equals((Object)annotationClassNode)) continue;
            return annotation;
        }
        return null;
    }

    public static AnnotationNode findAnnotation(ClassNode classNode, Class<?> type) {
        List annotations = classNode.getAnnotations();
        return annotations == null ? null : GrailsASTUtils.findAnnotation(new ClassNode(type), annotations);
    }

    public static boolean hasAnnotation(ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return !classNode.getAnnotations(new ClassNode(annotationClass)).isEmpty();
    }

    public static boolean hasAnyAnnotations(final ClassNode classNode, Class<? extends Annotation> ... annotationsToLookFor) {
        return CollectionUtils.exists(Arrays.asList(annotationsToLookFor), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return GrailsASTUtils.hasAnnotation(classNode, (Class)object);
            }
        });
    }

    public static void addMethodIfNotPresent(ClassNode controllerClassNode, MethodNode methodNode) {
        MethodNode existing = controllerClassNode.getMethod(methodNode.getName(), methodNode.getParameters());
        if (existing == null) {
            controllerClassNode.addMethod(methodNode);
        }
    }

    public static ExpressionStatement createPrintlnStatement(String message) {
        return new ExpressionStatement((Expression)new MethodCallExpression((Expression)AbstractGrailsArtefactTransformer.THIS_EXPRESSION, "println", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)message))));
    }

    public static ExpressionStatement createPrintlnStatement(String message, String variable) {
        return new ExpressionStatement((Expression)new MethodCallExpression((Expression)AbstractGrailsArtefactTransformer.THIS_EXPRESSION, "println", (Expression)new ArgumentListExpression((Expression)new BinaryExpression((Expression)new ConstantExpression((Object)message), Token.newSymbol((int)200, (int)0, (int)0), (Expression)new VariableExpression(variable)))));
    }

    public static void wrapMethodBodyInTryCatchDebugStatements(MethodNode methodNode) {
        BlockStatement code = (BlockStatement)methodNode.getCode();
        BlockStatement newCode = new BlockStatement();
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)code, (Statement)new BlockStatement());
        newCode.addStatement((Statement)tryCatchStatement);
        methodNode.setCode((Statement)newCode);
        BlockStatement catchBlock = new BlockStatement();
        ArgumentListExpression logArguments = new ArgumentListExpression();
        logArguments.addExpression((Expression)new BinaryExpression((Expression)new ConstantExpression((Object)"Error initializing class: "), Token.newSymbol((int)200, (int)0, (int)0), (Expression)new VariableExpression("e")));
        logArguments.addExpression((Expression)new VariableExpression("e"));
        catchBlock.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("log"), "error", (Expression)logArguments)));
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(new ClassNode(Throwable.class), "e"), (Statement)catchBlock));
    }

    public static Map<String, Map<String, Expression>> getConstraintMetadata(ClosureExpression closureExpression) {
        ArrayList<MethodCallExpression> methodExpressions = new ArrayList<MethodCallExpression>();
        LinkedHashMap<String, Map<String, Expression>> results = new LinkedHashMap<String, Map<String, Expression>>();
        Statement closureCode = closureExpression.getCode();
        if (closureCode instanceof BlockStatement) {
            List closureStatements = ((BlockStatement)closureCode).getStatements();
            for (Statement closureStatement : closureStatements) {
                ReturnStatement returnStatement;
                Expression expression;
                if (closureStatement instanceof ExpressionStatement) {
                    Expression expression2 = ((ExpressionStatement)closureStatement).getExpression();
                    if (expression2 instanceof MethodCallExpression) {
                        methodExpressions.add((MethodCallExpression)expression2);
                    }
                } else if (closureStatement instanceof ReturnStatement && (expression = (returnStatement = (ReturnStatement)closureStatement).getExpression()) instanceof MethodCallExpression) {
                    methodExpressions.add((MethodCallExpression)expression);
                }
                for (MethodCallExpression methodCallExpression : methodExpressions) {
                    List methodCallArgumentExpressions;
                    Expression methodCallArguments;
                    Expression objectExpression = methodCallExpression.getObjectExpression();
                    if (!(objectExpression instanceof VariableExpression) || !"this".equals(((VariableExpression)objectExpression).getName()) || !((methodCallArguments = methodCallExpression.getArguments()) instanceof TupleExpression) || (methodCallArgumentExpressions = ((TupleExpression)methodCallArguments).getExpressions()) == null || methodCallArgumentExpressions.size() != 1 || !(methodCallArgumentExpressions.get(0) instanceof NamedArgumentListExpression)) continue;
                    LinkedHashMap<String, Expression> constraintNameToExpression = new LinkedHashMap<String, Expression>();
                    List mapEntryExpressions = ((NamedArgumentListExpression)methodCallArgumentExpressions.get(0)).getMapEntryExpressions();
                    for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
                        Object value;
                        Expression keyExpression = mapEntryExpression.getKeyExpression();
                        if (!(keyExpression instanceof ConstantExpression) || !((value = ((ConstantExpression)keyExpression).getValue()) instanceof String)) continue;
                        constraintNameToExpression.put((String)value, mapEntryExpression.getValueExpression());
                    }
                    results.put(methodCallExpression.getMethodAsString(), constraintNameToExpression);
                }
            }
        }
        return results;
    }

    public static Map<String, ClassNode> getAssocationMap(ClassNode classNode, String associationType) {
        Expression e;
        PropertyNode property = classNode.getProperty(associationType);
        HashMap<String, ClassNode> associationMap = new HashMap<String, ClassNode>();
        if (property != null && property.isStatic() && (e = property.getInitialExpression()) instanceof MapExpression) {
            MapExpression me = (MapExpression)e;
            for (MapEntryExpression mee : me.getMapEntryExpressions()) {
                String key = mee.getKeyExpression().getText();
                Expression valueExpression = mee.getValueExpression();
                if (!(valueExpression instanceof ClassExpression)) continue;
                associationMap.put(key, valueExpression.getType());
            }
        }
        return associationMap;
    }

    public static Map<String, ClassNode> getAllAssociationMap(ClassNode classNode) {
        HashMap<String, ClassNode> associationMap = new HashMap<String, ClassNode>();
        associationMap.putAll(GrailsASTUtils.getAssocationMap(classNode, "hasMany"));
        associationMap.putAll(GrailsASTUtils.getAssocationMap(classNode, "hasOne"));
        associationMap.putAll(GrailsASTUtils.getAssocationMap(classNode, "belongsTo"));
        return associationMap;
    }

    public static ClassNode findInterface(ClassNode classNode, ClassNode interfaceNode) {
        while (!classNode.equals((Object)OBJECT_CLASS_NODE)) {
            Set interfaces = classNode.getAllInterfaces();
            for (ClassNode anInterface : interfaces) {
                if (!anInterface.equals((Object)interfaceNode)) continue;
                return anInterface;
            }
            classNode = classNode.getSuperClass();
        }
        return null;
    }

    public static boolean hasZeroArgsConstructor(ClassNode implementationNode) {
        List constructors = implementationNode.getDeclaredConstructors();
        if (constructors.isEmpty()) {
            return true;
        }
        for (ConstructorNode constructor : constructors) {
            if (constructor.getParameters().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isInnerClassNode(ClassNode classNode) {
        return classNode instanceof InnerClassNode || classNode.getName().contains("$");
    }

    @Target(value={ElementType.CONSTRUCTOR})
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface GrailsDelegatingConstructor {
    }
}

