/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.support.encoding.AbstractEncodedAppender;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingState;

public class WriterEncodedAppender
extends AbstractEncodedAppender {
    private Writer target;

    public WriterEncodedAppender(Writer target) {
        this.target = target;
    }

    public void flush() throws IOException {
        this.target.flush();
    }

    protected void write(EncodingState encodingState, char[] b, int off, int len) throws IOException {
        this.target.write(b, off, len);
    }

    protected void write(EncodingState encodingState, String str, int off, int len) throws IOException {
        this.target.write(str, off, len);
    }

    protected void appendCharSequence(EncodingState encodingState, CharSequence csq, int start, int end) throws IOException {
        if (csq instanceof String) {
            this.target.write((String)csq, start, end - start);
        } else if (csq instanceof StringBuffer) {
            char[] buf = new char[end - start];
            ((StringBuffer)csq).getChars(start, end, buf, 0);
            this.target.write(buf);
        } else if (csq instanceof StringBuilder) {
            char[] buf = new char[end - start];
            ((StringBuilder)csq).getChars(start, end, buf, 0);
            this.target.write(buf);
        } else if (start == 0 && end == csq.length()) {
            String str = ((Object)csq).toString();
            this.target.write(str, start, end - start);
        } else {
            String str = ((Object)csq.subSequence(start, end)).toString();
            this.target.write(str, 0, str.length());
        }
    }

    public void append(Encoder encoder, char character) throws IOException {
        this.target.write(character);
    }

    public void close() throws IOException {
        this.target.close();
    }
}

