/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import java.io.IOException;
import org.codehaus.groovy.grails.support.encoding.CharArrayAccessible;
import org.codehaus.groovy.grails.support.encoding.DefaultEncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingState;
import org.codehaus.groovy.grails.support.encoding.EncodingStateImpl;
import org.codehaus.groovy.grails.support.encoding.StreamEncodeable;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;

public abstract class AbstractEncodedAppender
implements EncodedAppender {
    protected abstract void write(EncodingState var1, char[] var2, int var3, int var4) throws IOException;

    protected abstract void write(EncodingState var1, String var2, int var3, int var4) throws IOException;

    protected abstract void appendCharSequence(EncodingState var1, CharSequence var2, int var3, int var4) throws IOException;

    public abstract void append(Encoder var1, char var2) throws IOException;

    public void append(Encoder encoder, EncodingState encodingState, char[] b, int off, int len) throws IOException {
        if (b == null || len <= 0) {
            return;
        }
        if (this.shouldEncode(encoder, encodingState)) {
            EncodingState newEncoders = this.appendEncoders(encoder, encodingState);
            if (encoder instanceof StreamingEncoder) {
                ((StreamingEncoder)encoder).encodeToStream(encoder, new CharArrayCharSequence(b, off, len), 0, len, this, newEncoders);
            } else {
                this.encodeAndWrite(encoder, newEncoders, String.valueOf(b, off, len));
            }
        } else {
            this.write(encodingState, b, off, len);
        }
    }

    private EncodingState appendEncoders(Encoder encoder, EncodingState encodingState) {
        if (encodingState == null) {
            return new EncodingStateImpl(encoder);
        }
        return encodingState.appendEncoder(encoder);
    }

    public void append(Encoder encoder, EncodingState encodingState, CharSequence str, int off, int len) throws IOException {
        if (str == null || len <= 0) {
            return;
        }
        if (this.shouldEncode(encoder, encodingState)) {
            EncodingState newEncoders = this.appendEncoders(encoder, encodingState);
            if (encoder instanceof StreamingEncoder) {
                ((StreamingEncoder)encoder).encodeToStream(encoder, str, off, len, this, newEncoders);
            } else {
                CharSequence source = off == 0 && len == str.length() ? str : str.subSequence(off, off + len);
                this.encodeAndWrite(encoder, newEncoders, source);
            }
        } else {
            this.appendCharSequence(encodingState, str, off, off + len);
        }
    }

    public void appendEncoded(Encoder encoder, EncodingState encodingState, char[] b, int off, int len) throws IOException {
        this.write(this.appendEncoders(encoder, encodingState), b, off, len);
    }

    public void appendEncoded(Encoder encoder, EncodingState encodingState, CharSequence str, int off, int len) throws IOException {
        this.appendCharSequence(this.appendEncoders(encoder, encodingState), str, off, off + len);
    }

    protected boolean shouldEncode(Encoder encoderToApply, EncodingState encodingState) {
        return encoderToApply != null && (encodingState == null || DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState));
    }

    protected void encodeAndWrite(Encoder encoder, EncodingState newEncodingState, CharSequence input) throws IOException {
        Object encoded = encoder.encode(input);
        if (encoded != null) {
            String encodedStr = String.valueOf(encoded);
            this.write(newEncodingState, encodedStr, 0, encodedStr.length());
        }
    }

    public void append(Encoder encoder, StreamEncodeable streamEncodeable) throws IOException {
        streamEncodeable.encodeTo(this, encoder);
    }

    public void flush() throws IOException {
    }

    private static final class CharArrayCharSequence
    implements CharSequence,
    CharArrayAccessible {
        private final char[] chars;
        private final int count;
        private final int start;

        public CharArrayCharSequence(char[] chars, int start, int count) {
            if (start + count > chars.length) {
                throw new StringIndexOutOfBoundsException(start);
            }
            this.chars = chars;
            this.start = start;
            this.count = count;
        }

        public char charAt(int index) {
            if (index < 0 || index + this.start >= this.chars.length) {
                throw new StringIndexOutOfBoundsException(index);
            }
            return this.chars[index + this.start];
        }

        public int length() {
            return this.count;
        }

        public CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (end > this.count) {
                throw new StringIndexOutOfBoundsException(end);
            }
            if (start > end) {
                throw new StringIndexOutOfBoundsException(end - start);
            }
            if (start == 0 && end == this.count) {
                return this;
            }
            return new CharArrayCharSequence(this.chars, this.start + start, end - start);
        }

        public String toString() {
            return new String(this.chars, this.start, this.count);
        }

        public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
            if (srcBegin < 0) {
                throw new StringIndexOutOfBoundsException(srcBegin);
            }
            if (srcEnd < 0 || srcEnd > this.start + this.count) {
                throw new StringIndexOutOfBoundsException(srcEnd);
            }
            if (srcBegin > srcEnd) {
                throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
            }
            System.arraycopy(this.chars, this.start + srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }
}

