/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.artefact.Enhanced;
import grails.util.GrailsUtil;
import groovy.lang.Mixin;
import java.lang.reflect.Modifier;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGrailsArtefactTransformer
implements GrailsArtefactClassInjector,
Comparable {
    private static final String INSTANCE_PREFIX = "instance";
    private static final String STATIC_PREFIX = "static";
    private static final AnnotationNode AUTO_WIRED_ANNOTATION = new AnnotationNode(new ClassNode(Autowired.class));
    private static final ClassNode ENHANCED_CLASS_NODE = new ClassNode(Enhanced.class);
    protected static final ClassNode OBJECT_CLASS = new ClassNode(Object.class);
    protected static final VariableExpression THIS_EXPRESSION = new VariableExpression("this");
    public static final int PUBLIC_STATIC_MODIFIER = 9;
    public static final String CURRENT_PREFIX = "current";
    public static final String METHOD_MISSING_METHOD_NAME = "methodMissing";
    public static final String STATIC_METHOD_MISSING_METHOD_NAME = "$static_methodMissing";

    public String[] getArtefactTypes() {
        return new String[]{this.getArtefactType()};
    }

    protected String getArtefactType() {
        String simpleName = this.getClass().getSimpleName();
        if (simpleName.length() > 11) {
            return simpleName.substring(0, simpleName.length() - 11);
        }
        return simpleName;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        Class staticImplementation;
        if (classNode instanceof InnerClassNode) {
            return;
        }
        Class instanceImplementation = this.getInstanceImplementation();
        if (instanceImplementation != null) {
            ClassNode implementationNode = new ClassNode(instanceImplementation);
            String apiInstanceProperty = INSTANCE_PREFIX + instanceImplementation.getSimpleName();
            VariableExpression apiInstance = new VariableExpression(apiInstanceProperty);
            if (this.requiresStaticLookupMethod()) {
                String lookupMethodName = CURRENT_PREFIX + instanceImplementation.getSimpleName();
                this.createStaticLookupMethod(classNode, implementationNode, apiInstanceProperty, lookupMethodName);
                apiInstance = new MethodCallExpression((Expression)new ClassExpression(classNode), lookupMethodName, (Expression)ZERO_ARGS);
            } else if (this.requiresAutowiring()) {
                PropertyNode propertyNode = new PropertyNode(apiInstanceProperty, 1, implementationNode, classNode, (Expression)new ConstructorCallExpression(implementationNode, (Expression)ZERO_ARGS), null, null);
                propertyNode.addAnnotation(AUTO_WIRED_ANNOTATION);
                if (this.getMarkerAnnotation() != null) {
                    propertyNode.addAnnotation(this.getMarkerAnnotation());
                }
                classNode.addProperty(propertyNode);
            } else {
                ConstructorCallExpression constructorCallExpression = new ConstructorCallExpression(implementationNode, (Expression)ZERO_ARGS);
                FieldNode fieldNode = classNode.getField(apiInstanceProperty);
                if (fieldNode == null || Modifier.isPrivate(fieldNode.getModifiers()) && !fieldNode.getDeclaringClass().equals((Object)classNode)) {
                    fieldNode = new FieldNode(apiInstanceProperty, 10, implementationNode, classNode, (Expression)constructorCallExpression);
                    classNode.addField(fieldNode);
                }
            }
            while (!implementationNode.equals((Object)OBJECT_CLASS)) {
                List declaredMethods = implementationNode.getMethods();
                for (MethodNode declaredMethod : declaredMethods) {
                    if (GrailsASTUtils.isConstructorMethod(declaredMethod)) {
                        GrailsASTUtils.addDelegateConstructor(classNode, declaredMethod);
                        continue;
                    }
                    if (!this.isCandidateInstanceMethod(classNode, declaredMethod)) continue;
                    GrailsASTUtils.addDelegateInstanceMethod(classNode, (Expression)apiInstance, declaredMethod, this.getMarkerAnnotation());
                }
                implementationNode = implementationNode.getSuperClass();
            }
            this.performInjectionInternal(apiInstanceProperty, source, classNode);
        }
        if ((staticImplementation = this.getStaticImplementation()) != null) {
            ClassNode staticImplementationNode = new ClassNode(staticImplementation);
            List declaredMethods = staticImplementationNode.getMethods();
            String staticImplementationSimpleName = staticImplementation.getSimpleName();
            String apiInstanceProperty = STATIC_PREFIX + staticImplementationSimpleName;
            String lookupMethodName = CURRENT_PREFIX + staticImplementationSimpleName;
            if (this.requiresStaticLookupMethod()) {
                this.createStaticLookupMethod(classNode, staticImplementationNode, apiInstanceProperty, lookupMethodName);
            } else {
                ConstructorCallExpression constructorCallExpression = new ConstructorCallExpression(staticImplementationNode, (Expression)ZERO_ARGS);
                FieldNode fieldNode = new FieldNode(apiInstanceProperty, 10, staticImplementationNode, classNode, (Expression)constructorCallExpression);
                classNode.addField(fieldNode);
                BlockStatement methodBody = new BlockStatement();
                MethodNode lookupMethod = this.populateDefaultApiLookupMethod(staticImplementationNode, apiInstanceProperty, lookupMethodName, methodBody);
                classNode.addMethod(lookupMethod);
            }
            MethodCallExpression apiLookupMethod = new MethodCallExpression((Expression)new ClassExpression(classNode), lookupMethodName, (Expression)ZERO_ARGS);
            for (MethodNode declaredMethod : declaredMethods) {
                if (!this.isStaticCandidateMethod(classNode, declaredMethod)) continue;
                GrailsASTUtils.addDelegateStaticMethod((Expression)apiLookupMethod, classNode, declaredMethod, this.getMarkerAnnotation());
            }
        }
        if (classNode.getAnnotations(ENHANCED_CLASS_NODE).isEmpty()) {
            Expression value;
            AnnotationNode annotationNode = new AnnotationNode(ENHANCED_CLASS_NODE);
            annotationNode.setMember("version", (Expression)new ConstantExpression((Object)GrailsUtil.getGrailsVersion()));
            classNode.addAnnotation(annotationNode);
            AnnotationNode annotation = GrailsASTUtils.findAnnotation(classNode, Mixin.class);
            if (annotation != null && (value = annotation.getMember("value")) != null) {
                annotationNode.setMember("mixins", value);
            }
        }
    }

    protected boolean isCandidateInstanceMethod(ClassNode classNode, MethodNode declaredMethod) {
        return GrailsASTUtils.isCandidateInstanceMethod(classNode, declaredMethod);
    }

    protected boolean isStaticCandidateMethod(ClassNode classNode, MethodNode declaredMethod) {
        return GrailsASTUtils.isCandidateMethod(declaredMethod);
    }

    private void createStaticLookupMethod(ClassNode classNode, ClassNode implementationNode, String apiInstanceProperty, String lookupMethodName) {
        MethodNode lookupMethod = classNode.getMethod(lookupMethodName, ZERO_PARAMETERS);
        if (lookupMethod == null) {
            BlockStatement methodBody = new BlockStatement();
            lookupMethod = this.populateAutowiredApiLookupMethod(classNode, implementationNode, apiInstanceProperty, lookupMethodName, methodBody);
            classNode.addMethod(lookupMethod);
        }
    }

    protected boolean requiresStaticLookupMethod() {
        return false;
    }

    protected MethodNode populateAutowiredApiLookupMethod(ClassNode classNode, ClassNode implementationNode, String apiInstanceProperty, String methodName, BlockStatement methodBody) {
        ArgumentListExpression arguments = new ArgumentListExpression();
        arguments.addExpression((Expression)new ConstantExpression((Object)("Method on class [" + classNode + "] was used outside of a Grails application. If running in the context of a test using the mocking API or bootstrap Grails correctly.")));
        methodBody.addStatement((Statement)new ThrowStatement((Expression)new ConstructorCallExpression(new ClassNode(IllegalStateException.class), (Expression)arguments)));
        return new MethodNode(methodName, 9, implementationNode, ZERO_PARAMETERS, null, (Statement)methodBody);
    }

    protected MethodNode populateDefaultApiLookupMethod(ClassNode implementationNode, String apiInstanceProperty, String methodName, BlockStatement methodBody) {
        methodBody.addStatement((Statement)new ReturnStatement((Expression)new VariableExpression(apiInstanceProperty)));
        return new MethodNode(methodName, 2, implementationNode, ZERO_PARAMETERS, null, (Statement)methodBody);
    }

    protected boolean requiresAutowiring() {
        return true;
    }

    protected void performInjectionInternal(String apiInstanceProperty, SourceUnit source, ClassNode classNode) {
    }

    public abstract Class getInstanceImplementation();

    public abstract Class getStaticImplementation();

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    protected AnnotationNode getMarkerAnnotation() {
        return null;
    }
}

