/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import groovy.lang.Closure;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.grails.commons.AbstractInjectableGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsCodecClass;
import org.codehaus.groovy.grails.support.encoding.CodecFactory;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.CodecMetaClassSupport;
import org.codehaus.groovy.grails.support.encoding.Decoder;
import org.codehaus.groovy.grails.support.encoding.DefaultCodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.Encodeable;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingState;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistryLookup;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsCodecClass
extends AbstractInjectableGrailsClass
implements GrailsCodecClass,
Ordered {
    public static final String CODEC = "Codec";
    private static EncodingStateRegistryLookup encodingStateRegistryLookup = null;
    private Encoder encoder;
    private Decoder decoder;
    private static int instantionCounter = 0;
    private int order = 100 + instantionCounter++;

    public static void setEncodingStateRegistryLookup(EncodingStateRegistryLookup lookup) {
        encodingStateRegistryLookup = lookup;
    }

    public static EncodingStateRegistryLookup getEncodingStateRegistryLookup() {
        return encodingStateRegistryLookup;
    }

    public DefaultGrailsCodecClass(Class<?> clazz) {
        super(clazz, CODEC);
        this.initializeCodec();
    }

    private void initializeCodec() {
        Integer orderSetting = this.getPropertyOrStaticPropertyOrFieldValue("order", Integer.class);
        if (orderSetting != null) {
            this.order = orderSetting;
        }
        if (Encoder.class.isAssignableFrom(this.getClazz())) {
            this.encoder = (Encoder)this.getReferenceInstance();
            this.autowireCodecBean(this.encoder);
            if (this.encoder instanceof Ordered) {
                this.order = ((Ordered)this.encoder).getOrder();
            }
        }
        if (Decoder.class.isAssignableFrom(this.getClazz())) {
            this.decoder = (Decoder)this.getReferenceInstance();
            this.autowireCodecBean(this.decoder);
            if (this.decoder instanceof Ordered) {
                this.order = ((Ordered)this.decoder).getOrder();
            }
        }
        if (this.encoder == null && this.decoder == null) {
            CodecFactory codecFactory = null;
            if (CodecFactory.class.isAssignableFrom(this.getClazz())) {
                codecFactory = (CodecFactory)this.getReferenceInstance();
                this.autowireCodecBean(codecFactory);
            }
            if (codecFactory == null) {
                codecFactory = this.getPropertyOrStaticPropertyOrFieldValue("codecFactory", CodecFactory.class);
                this.autowireCodecBean(codecFactory);
            }
            if (codecFactory == null) {
                codecFactory = new ClosureCodecFactory();
            }
            this.encoder = codecFactory.getEncoder();
            this.decoder = codecFactory.getDecoder();
            if (codecFactory instanceof Ordered) {
                this.order = ((Ordered)codecFactory).getOrder();
            }
        }
        if (this.encoder != null) {
            this.encoder = this.encoder instanceof StreamingEncoder ? new StreamingStateAwareEncoderWrapper((StreamingEncoder)this.encoder) : new StateAwareEncoderWrapper(this.encoder);
        }
    }

    protected void autowireCodecBean(Object existingBean) {
        if (existingBean != null && this.grailsApplication != null && this.grailsApplication.getMainContext() != null) {
            this.grailsApplication.getMainContext().getAutowireCapableBeanFactory().autowireBeanProperties(existingBean, 1, false);
        }
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public void configureCodecMethods() {
        new CodecMetaClassSupport().configureCodecMethods(this);
    }

    public int getOrder() {
        return this.order;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodCallingClosure
    extends Closure<Object> {
        private static final long serialVersionUID = 1L;
        private Method method;

        public MethodCallingClosure(Object owner, Method method) {
            super(owner);
            this.maximumNumberOfParameters = 1;
            this.parameterTypes = new Class[]{Object.class};
            this.method = method;
        }

        protected Object callMethod(Object argument) {
            return ReflectionUtils.invokeMethod((Method)this.method, (Object)(!Modifier.isStatic(this.method.getModifiers()) ? this.getOwner() : null), (Object[])new Object[]{argument});
        }

        public Object call(Object ... args) {
            return this.doCall(args);
        }

        protected Object doCall(Object[] args) {
            Object target = null;
            if (args != null && args.length > 0) {
                target = args[0];
            }
            if (target == null) {
                return null;
            }
            return this.callMethod(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClosureEncoder
    implements Encoder {
        private CodecIdentifier codecIdentifier;
        private Closure<Object> closure;

        public ClosureEncoder(String codecName, Closure<Object> closure) {
            this.codecIdentifier = new DefaultCodecIdentifier(codecName);
            this.closure = closure;
        }

        @Override
        public CodecIdentifier getCodecIdentifier() {
            return this.codecIdentifier;
        }

        @Override
        public CharSequence encode(Object target) {
            if (target == null) {
                return null;
            }
            Object encoded = this.closure.call(target);
            if (encoded != null && !(encoded instanceof CharSequence)) {
                return String.valueOf(encoded);
            }
            return (CharSequence)encoded;
        }

        @Override
        public void markEncoded(CharSequence string) {
        }

        @Override
        public boolean isSafe() {
            return false;
        }

        @Override
        public boolean isApplyToSafelyEncoded() {
            return true;
        }
    }

    private static class StreamingStateAwareEncoderWrapper
    extends StateAwareEncoderWrapper
    implements StreamingEncoder {
        private StreamingEncoder delegate;

        public StreamingStateAwareEncoderWrapper(StreamingEncoder delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public void encodeToStream(Encoder thisInstance, CharSequence source, int offset, int len, EncodedAppender appender, EncodingState encodingState) throws IOException {
            this.delegate.encodeToStream(this, source, offset, len, appender, encodingState);
        }
    }

    private static class StateAwareEncoderWrapper
    implements Encoder {
        private Encoder delegate;

        public StateAwareEncoderWrapper(Encoder delegate) {
            this.delegate = delegate;
        }

        public CodecIdentifier getCodecIdentifier() {
            return this.delegate.getCodecIdentifier();
        }

        public Object encode(Object target) {
            if (target instanceof Encodeable) {
                return ((Encodeable)target).encode(this);
            }
            EncodingStateRegistry encodingState = this.lookupEncodingState();
            if (encodingState != null && target instanceof CharSequence && !encodingState.shouldEncodeWith(this, (CharSequence)target)) {
                return target;
            }
            Object encoded = this.delegate.encode(target);
            if (encodingState != null && encoded instanceof CharSequence) {
                encodingState.registerEncodedWith(this, (CharSequence)encoded);
            }
            return encoded;
        }

        protected EncodingStateRegistry lookupEncodingState() {
            return encodingStateRegistryLookup != null ? encodingStateRegistryLookup.lookup() : null;
        }

        public void markEncoded(CharSequence string) {
            EncodingStateRegistry encodingState = this.lookupEncodingState();
            if (encodingState != null) {
                encodingState.registerEncodedWith(this, string);
            }
        }

        public boolean isSafe() {
            return this.delegate.isSafe();
        }

        public boolean isApplyToSafelyEncoded() {
            return this.delegate.isApplyToSafelyEncoded();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClosureDecoder
    implements Decoder {
        private CodecIdentifier codecIdentifier;
        private Closure<Object> closure;

        public ClosureDecoder(String codecName, Closure<Object> closure) {
            this.codecIdentifier = new DefaultCodecIdentifier(codecName);
            this.closure = closure;
        }

        @Override
        public CodecIdentifier getCodecIdentifier() {
            return this.codecIdentifier;
        }

        @Override
        public Object decode(Object o) {
            return this.closure.call(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClosureCodecFactory
    implements CodecFactory {
        private Encoder encoder;
        private Decoder decoder;

        ClosureCodecFactory() {
            Closure<Object> decoderClosure;
            Closure<Object> encoderClosure = this.getMethodOrClosureMethod(DefaultGrailsCodecClass.this.getClazz(), "encode");
            if (encoderClosure != null) {
                this.encoder = new ClosureEncoder(DefaultGrailsCodecClass.this.getName(), encoderClosure);
            }
            if ((decoderClosure = this.getMethodOrClosureMethod(DefaultGrailsCodecClass.this.getClazz(), "decode")) != null) {
                this.decoder = new ClosureDecoder(DefaultGrailsCodecClass.this.getName(), decoderClosure);
            }
        }

        @Override
        public Encoder getEncoder() {
            return this.encoder;
        }

        @Override
        public Decoder getDecoder() {
            return this.decoder;
        }

        private Closure<Object> getMethodOrClosureMethod(Class<?> clazz, String methodName) {
            Closure closure = DefaultGrailsCodecClass.this.getPropertyOrStaticPropertyOrFieldValue(methodName, Closure.class);
            if (closure == null) {
                Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])null);
                if (method != null) {
                    Object owner = Modifier.isStatic(method.getModifiers()) ? clazz : DefaultGrailsCodecClass.this.getReferenceInstance();
                    return new MethodCallingClosure(owner, method);
                }
                return null;
            }
            return closure;
        }
    }
}

