/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Holder;
import groovy.util.ConfigObject;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Holders {
    private static final Log LOG = LogFactory.getLog(Holders.class);
    private static final String APPLICATION_BEAN_NAME = "grailsApplication";
    private static Holder<GrailsResourceLoader> resourceLoaders = new Holder("ResourceLoader");
    private static Holder<GrailsPluginManager> pluginManagers = new Holder("PluginManager");
    private static Holder<Boolean> pluginManagersInCreation = new Holder("PluginManagers in creation");
    private static Holder<ConfigObject> configs = new Holder("config");
    private static Holder<Map<?, ?>> flatConfigs = new Holder("flat config");
    private static Holder<ServletContext> servletContexts;
    private static GrailsApplication applicationSingleton;

    private Holders() {
    }

    public static void clear() {
        resourceLoaders.set(null);
        pluginManagers.set(null);
        pluginManagersInCreation.set(null);
        configs.set(null);
        if (servletContexts != null) {
            servletContexts.set(null);
        }
    }

    public static void setServletContext(ServletContext servletContext) {
        servletContexts.set((Object)servletContext);
    }

    public static ServletContext getServletContext() {
        return Holders.get(servletContexts, "servletContext");
    }

    public static ApplicationContext getApplicationContext() {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)Holders.getServletContext());
    }

    public static GrailsApplication getGrailsApplication() {
        try {
            return (GrailsApplication)Holders.getApplicationContext().getBean(APPLICATION_BEAN_NAME);
        }
        catch (IllegalStateException e) {
            return applicationSingleton;
        }
        catch (IllegalArgumentException e) {
            return applicationSingleton;
        }
    }

    public static void setGrailsApplication(GrailsApplication application) {
        applicationSingleton = application;
    }

    public static void setConfig(ConfigObject config) {
        configs.set((Object)config);
        flatConfigs.set((Object)(config == null ? null : config.flatten()));
    }

    public static ConfigObject getConfig() {
        return Holders.get(configs, "config");
    }

    public static Map<?, ?> getFlatConfig() {
        Map<?, ?> flatConfig = Holders.get(flatConfigs, "flatConfig");
        return flatConfig == null ? Collections.emptyMap() : flatConfig;
    }

    public static GrailsResourceLoader getResourceLoader() {
        return Holders.getResourceLoader(false);
    }

    public static GrailsResourceLoader getResourceLoader(boolean mappedOnly) {
        return Holders.get(resourceLoaders, "resourceLoader", mappedOnly);
    }

    public static void setResourceLoader(GrailsResourceLoader resourceLoader) {
        resourceLoaders.set((Object)resourceLoader);
    }

    public static void setPluginManagerInCreation(boolean inCreation) {
        pluginManagersInCreation.set((Object)inCreation);
    }

    public static void setPluginManager(GrailsPluginManager pluginManager) {
        if (pluginManager != null) {
            pluginManagersInCreation.set((Object)false);
        }
        pluginManagers.set((Object)pluginManager);
    }

    public static GrailsPluginManager getPluginManager() {
        return Holders.getPluginManager(false);
    }

    public static GrailsPluginManager getPluginManager(boolean mappedOnly) {
        while (true) {
            Boolean inCreation;
            if ((inCreation = Holders.get(pluginManagersInCreation, "PluginManager in creation", mappedOnly)) == null) {
                inCreation = false;
            }
            if (!inCreation.booleanValue()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return Holders.get(pluginManagers, "PluginManager", mappedOnly);
    }

    public static GrailsPluginManager currentPluginManager() {
        GrailsPluginManager current = Holders.getPluginManager();
        Assert.notNull((Object)current, (String)"No PluginManager set");
        return current;
    }

    public static void reset() {
        Holders.setPluginManager(null);
        Holders.setGrailsApplication(null);
        Holders.setServletContext(null);
        Holders.setResourceLoader(null);
        Holders.setPluginManager(null);
        Holders.setPluginManagerInCreation(false);
    }

    private static <T> T get(Holder<T> holder, String type) {
        return Holders.get(holder, type, false);
    }

    private static <T> T get(Holder<T> holder, String type, boolean mappedOnly) {
        return (T)holder.get(mappedOnly);
    }

    private static void createServletContextsHolder() {
        try {
            Class<?> clazz = Holders.class.getClassLoader().loadClass("org.codehaus.groovy.grails.web.context.WebRequestServletHolder");
            servletContexts = (Holder)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Error initializing servlet context holder", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Error initializing servlet context holder", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Error initializing servlet context holder", (Throwable)e);
        }
    }

    static {
        Holders.createServletContextsHolder();
    }
}

