/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.grails.cli.agent.GrailsPluginManagerReloadPlugin;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.compiler.DirectoryWatcher;
import org.codehaus.groovy.grails.compiler.GrailsProjectCompiler;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.support.WatchPattern;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsProjectWatcher
extends DirectoryWatcher {
    private static final Log LOG = LogFactory.getLog(GrailsProjectWatcher.class);
    private static final Map<String, ClassUpdate> classChangeEventQueue = new ConcurrentHashMap<String, ClassUpdate>();
    private static boolean active = false;
    private static boolean reloadInProgress = false;
    public static final String SPRING_LOADED_PLUGIN_CLASS = "org.springsource.loaded.Plugins";
    private List<String> compilerExtensions;
    private GrailsPluginManager pluginManager;
    private GrailsProjectCompiler compiler;
    private Map<File, GrailsPlugin> descriptorToPluginMap = new ConcurrentHashMap<File, GrailsPlugin>();
    private static MultipleCompilationErrorsException currentCompilationError = null;
    private static Throwable currentReloadError = null;
    private static List<String> reloadExcludes;
    private static List<String> reloadIncludes;

    public GrailsProjectWatcher(GrailsProjectCompiler compiler, GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.compilerExtensions = compiler.getCompilerExtensions();
        this.compiler = compiler;
        if (GrailsProjectWatcher.isReloadingAgentPresent()) {
            GrailsPluginManagerReloadPlugin.register();
        }
    }

    public static void setReloadExcludes(List<String> reloadExcludes) {
        GrailsProjectWatcher.reloadExcludes = reloadExcludes;
    }

    public static void setReloadIncludes(List<String> reloadIncludes) {
        GrailsProjectWatcher.reloadIncludes = reloadIncludes;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.initPluginWatchPatterns();
    }

    public static MultipleCompilationErrorsException getCurrentCompilationError() {
        return currentCompilationError;
    }

    public static Throwable getCurrentReloadError() {
        return currentReloadError;
    }

    public static void setCurrentReloadError(Throwable currentReloadError) {
        GrailsProjectWatcher.currentReloadError = currentReloadError;
    }

    public static boolean isReloadingAgentPresent() {
        return ClassUtils.isPresent((String)SPRING_LOADED_PLUGIN_CLASS, (ClassLoader)GrailsProjectWatcher.class.getClassLoader());
    }

    public static boolean isReloadInProgress() {
        return reloadInProgress;
    }

    public static boolean isActive() {
        return active;
    }

    public static void firePendingClassChangeEvents(Class<?> updatedClass) {
        if (updatedClass == null) {
            return;
        }
        ClassUpdate classUpdate = classChangeEventQueue.remove(updatedClass.getName());
        if (classUpdate != null) {
            classUpdate.run(updatedClass);
        }
    }

    @Override
    public void run() {
        org.codehaus.groovy.grails.io.support.Resource[] pluginSourceFiles;
        active = true;
        for (String directory : this.compiler.getSrcDirectories()) {
            this.addWatchDirectory(new File(directory), this.compilerExtensions);
        }
        for (org.codehaus.groovy.grails.io.support.Resource pluginSourceFile : pluginSourceFiles = this.compiler.getPluginSettings().getPluginSourceFiles()) {
            try {
                if (!pluginSourceFile.getFile().isDirectory()) continue;
                this.addWatchDirectory(pluginSourceFile.getFile(), this.compilerExtensions);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.addListener(new DirectoryWatcher.FileChangeListener(){

            public void onChange(File file) {
                if (GrailsProjectWatcher.this.fileIsReloadable(file)) {
                    LOG.info((Object)("File [" + file + "] changed. Applying changes to application."));
                    if (GrailsProjectWatcher.this.descriptorToPluginMap.containsKey(file)) {
                        GrailsProjectWatcher.this.reloadPlugin(file);
                    } else {
                        GrailsProjectWatcher.this.compileIfSource(file);
                        GrailsProjectWatcher.this.informPluginManager(file, false);
                    }
                }
            }

            public void onNew(File file) {
                if (GrailsProjectWatcher.this.fileIsReloadable(file)) {
                    LOG.info((Object)("File [" + file + "] added. Applying changes to application."));
                    String fileName = file.getName();
                    if (fileName.endsWith(".groovy") || fileName.endsWith(".java")) {
                        GrailsProjectWatcher.this.sleep(5000);
                    }
                    GrailsProjectWatcher.this.compileIfSource(file);
                    GrailsProjectWatcher.this.informPluginManager(file, true);
                }
            }
        });
        if (this.pluginManager != null) {
            this.initPluginWatchPatterns();
        }
        super.run();
    }

    private void initPluginWatchPatterns() {
        GrailsPlugin[] allPlugins;
        for (GrailsPlugin plugin : allPlugins = this.pluginManager.getAllPlugins()) {
            List<WatchPattern> watchPatterns;
            GrailsPluginInfo info = this.compiler.getPluginSettings().getPluginInfoForName(plugin.getFileSystemShortName());
            if (info != null && info.getDescriptor() != null) {
                try {
                    org.codehaus.groovy.grails.io.support.Resource descriptor = info.getDescriptor();
                    plugin.setDescriptor((Resource)new FileSystemResource(descriptor.getFile()));
                    File pluginFile = descriptor.getFile();
                    this.descriptorToPluginMap.put(pluginFile, plugin);
                    this.addWatchFile(pluginFile);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if ((watchPatterns = plugin.getWatchedResourcePatterns()) == null) continue;
            for (WatchPattern watchPattern : watchPatterns) {
                if (watchPattern.getFile() != null) {
                    this.addWatchFile(watchPattern.getFile());
                    continue;
                }
                if (watchPattern.getDirectory() == null) continue;
                this.addWatchDirectory(watchPattern.getDirectory(), watchPattern.getExtension());
            }
        }
    }

    protected boolean fileIsReloadable(File file) {
        boolean fileIsIncluded;
        String classname = GrailsResourceUtils.getClassName((String)file.getAbsolutePath());
        boolean fileIsExcluded = reloadExcludes != null ? reloadExcludes.contains(classname) : false;
        boolean bl = fileIsIncluded = reloadIncludes != null ? reloadIncludes.contains(classname) : true;
        if (fileIsExcluded) {
            return false;
        }
        if (fileIsIncluded) {
            return true;
        }
        return fileIsExcluded || fileIsIncluded || reloadIncludes.size() <= 0;
    }

    private void reloadPlugin(File file) {
        GrailsPlugin grailsPlugin = this.descriptorToPluginMap.get(file);
        grailsPlugin.refresh();
        if (this.pluginManager instanceof DefaultGrailsPluginManager) {
            ((DefaultGrailsPluginManager)this.pluginManager).reloadPlugin(grailsPlugin);
        }
    }

    private void informPluginManager(final File file, boolean isNew) {
        if (this.pluginManager == null || this.pluginManager.isShutdown()) {
            return;
        }
        if (!this.isSourceFile(file) || isNew) {
            try {
                this.pluginManager.informOfFileChange(file);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to reload file [" + file + "] with error: " + e.getMessage()), (Throwable)e);
            }
        } else {
            String className = GrailsResourceUtils.getClassName((String)file.getAbsolutePath());
            if (className != null) {
                classChangeEventQueue.put(className, new ClassUpdate(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(Class<?> cls) {
                        try {
                            reloadInProgress = true;
                            GrailsProjectWatcher.this.pluginManager.informOfClassChange(file, cls);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Failed to reload file [" + file + "] with error: " + e.getMessage()), (Throwable)e);
                        }
                        finally {
                            reloadInProgress = false;
                        }
                    }
                });
            }
        }
    }

    private void compileIfSource(File file) {
        try {
            if (this.isSourceFile(file)) {
                this.compiler.compileAll();
                currentCompilationError = null;
                ClassPropertyFetcher.clearClassPropertyFetcherCache();
            }
        }
        catch (MultipleCompilationErrorsException e) {
            LOG.error((Object)("Compilation Error: " + e.getMessage()));
            currentCompilationError = e;
        }
        catch (CompilationFailedException e) {
            LOG.error((Object)("Compilation Error: " + e.getMessage()));
        }
        catch (BuildException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MultipleCompilationErrorsException) {
                currentCompilationError = (MultipleCompilationErrorsException)cause;
            }
            LOG.error((Object)("Compilation Error: " + e.getCause().getMessage()));
        }
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isSourceFile(File file) {
        for (String compilerExtension : this.compilerExtensions) {
            if (!file.getName().endsWith(compilerExtension)) continue;
            return true;
        }
        return false;
    }

    private String getDottedClassName(File file) {
        String absolutePath = file.getName();
        for (String dir : this.compiler.getSrcDirectories()) {
            if (!absolutePath.startsWith(dir)) continue;
            String srcPath = absolutePath.replaceAll(String.format("^%s", dir), "");
            String dottedPath = srcPath.replaceAll(File.separator, ".");
            return dottedPath;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClassUpdate {
        public void run(Class<?> var1);
    }
}

