/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryWatcher
extends Thread {
    public static final String SVN_DIR_NAME = ".svn";
    protected Collection<String> extensions = new ConcurrentLinkedQueue<String>();
    private List<FileChangeListener> listeners = new ArrayList<FileChangeListener>();
    private Map<File, Long> lastModifiedMap = new ConcurrentHashMap<File, Long>();
    private Map<File, Collection<String>> directoryToExtensionsMap = new ConcurrentHashMap<File, Collection<String>>();
    private Map<File, Long> directoryWatch = new ConcurrentHashMap<File, Long>();
    private boolean active = true;
    private long sleepTime = 3000L;

    public DirectoryWatcher() {
        this.setDaemon(true);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void addListener(FileChangeListener listener) {
        this.listeners.add(listener);
    }

    public void addWatchFile(File fileToWatch) {
        this.lastModifiedMap.put(fileToWatch, fileToWatch.lastModified());
    }

    public void addWatchDirectory(File dir, List<String> fileExtensions) {
        this.trackDirectoryExtensions(dir, fileExtensions);
        this.cacheFilesForDirectory(dir, fileExtensions, false);
    }

    protected void trackDirectoryExtensions(File dir, List<String> fileExtensions) {
        Collection<String> existingExtensions = this.directoryToExtensionsMap.get(dir);
        if (existingExtensions == null) {
            this.directoryToExtensionsMap.put(dir, new ArrayList<String>(fileExtensions));
        } else {
            existingExtensions.addAll(fileExtensions);
        }
    }

    public void addWatchDirectory(File dir, String extension) {
        extension = this.removeStartingDotIfPresent(extension);
        ArrayList<String> fileExtensions = new ArrayList<String>();
        if (!StringUtils.hasText((String)extension)) {
            fileExtensions.add("*");
        } else {
            fileExtensions.add(extension);
        }
        this.trackDirectoryExtensions(dir, fileExtensions);
        this.cacheFilesForDirectory(dir, fileExtensions, false);
    }

    @Override
    public void run() {
        int count = 0;
        while (this.active) {
            Set<File> files = this.lastModifiedMap.keySet();
            for (File file : files) {
                Long cachedTime;
                long currentLastModified = file.lastModified();
                if (currentLastModified <= (cachedTime = this.lastModifiedMap.get(file))) continue;
                this.lastModifiedMap.put(file, currentLastModified);
                this.fireOnChange(file);
            }
            try {
                if (++count > 2) {
                    count = 0;
                    this.checkForNewFiles();
                }
                DirectoryWatcher.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void fireOnChange(File file) {
        for (FileChangeListener listener : this.listeners) {
            listener.onChange(file);
        }
    }

    private void checkForNewFiles() {
        for (File directory : this.directoryWatch.keySet()) {
            Long currentTimestamp = this.directoryWatch.get(directory);
            if (currentTimestamp >= directory.lastModified()) continue;
            Collection<String> extensions = this.directoryToExtensionsMap.get(directory);
            if (extensions == null) {
                extensions = this.extensions;
            }
            this.cacheFilesForDirectory(directory, extensions, true);
        }
    }

    private void cacheFilesForDirectory(File directory, Collection<String> fileExtensions, boolean fireEvent) {
        this.addExtensions(fileExtensions);
        this.directoryWatch.put(directory, directory.lastModified());
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() && !file.isHidden()) {
                if (SVN_DIR_NAME.equals(file.getName())) continue;
                this.cacheFilesForDirectory(file, fileExtensions, fireEvent);
                continue;
            }
            if (!this.isValidFileToMonitor(file, fileExtensions)) continue;
            if (!this.lastModifiedMap.containsKey(file) && fireEvent) {
                for (FileChangeListener listener : this.listeners) {
                    listener.onNew(file);
                }
            }
            this.lastModifiedMap.put(file, file.lastModified());
        }
    }

    private void addExtensions(Collection<String> toAdd) {
        for (String extension : toAdd) {
            if (this.extensions.contains(extension = this.removeStartingDotIfPresent(extension))) continue;
            this.extensions.add(extension);
        }
    }

    private String removeStartingDotIfPresent(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        return extension;
    }

    private boolean isValidFileToMonitor(File file, Collection<String> fileExtensions) {
        String name = file.getName();
        String path = file.getAbsolutePath();
        boolean isSvnFile = path.indexOf(File.separator + SVN_DIR_NAME + File.separator) > 0;
        return !isSvnFile && !file.isHidden() && !file.getName().startsWith(".") && (fileExtensions.contains("*") || fileExtensions.contains(StringUtils.getFilenameExtension((String)name)));
    }

    public static interface FileChangeListener {
        public void onChange(File var1);

        public void onNew(File var1);
    }
}

