/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import groovy.lang.AdaptingMetaClass;
import groovy.lang.Closure;
import groovy.lang.ClosureInvokingMethod;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.metaclass.ThreadManagedMetaBeanProperty;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsMetaClassUtils {
    private static final Log LOG = LogFactory.getLog(GrailsMetaClassUtils.class);
    private static final Object[] NO_ARGS = new Object[0];

    public static MetaClassRegistry getRegistry() {
        return GroovySystem.getMetaClassRegistry();
    }

    public static void copyExpandoMetaClass(Class<?> fromClass, Class<?> toClass, boolean removeSource) {
        block14: {
            ExpandoMetaClass emc;
            MetaClassRegistry registry = GrailsMetaClassUtils.getRegistry();
            MetaClass oldMetaClass = registry.getMetaClass(fromClass);
            AdaptingMetaClass adapter = null;
            if (oldMetaClass instanceof AdaptingMetaClass) {
                adapter = (AdaptingMetaClass)oldMetaClass;
                emc = (ExpandoMetaClass)adapter.getAdaptee();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Obtained adapted MetaClass [" + emc + "] from AdapterMetaClass instance [" + adapter + "]"));
                }
                if (removeSource) {
                    registry.removeMetaClass(fromClass);
                }
            } else {
                emc = (ExpandoMetaClass)oldMetaClass;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No adapter MetaClass found, using original [" + emc + "]"));
                }
            }
            ExpandoMetaClass replacement = new ExpandoMetaClass(toClass, true, true);
            for (Object obj : emc.getExpandoMethods()) {
                if (!(obj instanceof ClosureInvokingMethod)) continue;
                ClosureInvokingMethod cim = (ClosureInvokingMethod)obj;
                Closure callable = cim.getClosure();
                if (!cim.isStatic()) {
                    replacement.setProperty(cim.getName(), (Object)callable);
                    continue;
                }
                ((GroovyObject)replacement.getProperty("static")).setProperty(cim.getName(), (Object)callable);
            }
            for (Object o : emc.getExpandoProperties()) {
                if (!(o instanceof ThreadManagedMetaBeanProperty)) continue;
                ThreadManagedMetaBeanProperty mbp = (ThreadManagedMetaBeanProperty)o;
                replacement.setProperty(mbp.getName(), mbp.getInitialValue());
            }
            replacement.initialize();
            if (adapter == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding MetaClass for class [" + toClass + "] MetaClass [" + replacement + "]"));
                }
                registry.setMetaClass(toClass, (MetaClass)replacement);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding MetaClass for class [" + toClass + "] MetaClass [" + replacement + "] with adapter [" + adapter + "]"));
                }
                try {
                    Constructor<?> c = adapter.getClass().getConstructor(MetaClass.class);
                    MetaClass newAdapter = (MetaClass)BeanUtils.instantiateClass(c, (Object[])new Object[]{replacement});
                    registry.setMetaClass(toClass, newAdapter);
                }
                catch (NoSuchMethodException e) {
                    if (!LOG.isDebugEnabled()) break block14;
                    LOG.debug((Object)("Exception thrown constructing new MetaClass adapter when reloading: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public static ExpandoMetaClass getExpandoMetaClass(Class<?> aClass) {
        MetaClassRegistry registry = GrailsMetaClassUtils.getRegistry();
        MetaClass mc = registry.getMetaClass(aClass);
        if (mc instanceof ExpandoMetaClass) {
            ExpandoMetaClass emc = (ExpandoMetaClass)mc;
            registry.setMetaClass(aClass, (MetaClass)emc);
            return emc;
        }
        registry.removeMetaClass(aClass);
        mc = registry.getMetaClass(aClass);
        if (mc instanceof ExpandoMetaClass) {
            return (ExpandoMetaClass)mc;
        }
        ExpandoMetaClass emc = new ExpandoMetaClass(aClass, true, true);
        emc.initialize();
        registry.setMetaClass(aClass, (MetaClass)emc);
        return emc;
    }

    public static MetaClass getMetaClass(Object instance) {
        if (instance instanceof GroovyObject) {
            GroovyObject groovyObject = (GroovyObject)instance;
            MetaClass metaClass = groovyObject.getMetaClass();
            if (!(metaClass instanceof ExpandoMetaClass)) {
                metaClass = GrailsMetaClassUtils.getExpandoMetaClass(instance.getClass());
                groovyObject.setMetaClass(metaClass);
            }
            return metaClass;
        }
        return GrailsMetaClassUtils.getExpandoMetaClass(instance.getClass());
    }

    public static Object getPropertyIfExists(Object instance, String property) {
        return GrailsMetaClassUtils.getPropertyIfExists(instance, property, Object.class);
    }

    public static <T> T getPropertyIfExists(Object instance, String property, Class<T> requiredType) {
        Object value;
        MetaClass metaClass = GrailsMetaClassUtils.getMetaClass(instance);
        MetaProperty metaProperty = metaClass.getMetaProperty(property);
        if (metaProperty != null && (value = metaProperty.getProperty(instance)) != null && requiredType.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public static Object invokeMethodIfExists(Object instance, String methodName) {
        return GrailsMetaClassUtils.invokeMethodIfExists(instance, methodName, NO_ARGS);
    }

    public static Object invokeMethodIfExists(Object instance, String methodName, Object[] args) {
        MetaClass metaClass = GrailsMetaClassUtils.getMetaClass(instance);
        List methodList = metaClass.respondsTo(instance, methodName, args);
        if (methodList != null && !methodList.isEmpty()) {
            return metaClass.invokeMethod(instance, methodName, args);
        }
        return null;
    }
}

