/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Metadata;
import grails.util.PluginBuildSettings;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class DevelopmentResourceLoader
extends DefaultResourceLoader {
    private static final Log LOG = LogFactory.getLog(DevelopmentResourceLoader.class);
    private String baseLocation = ".";
    private GrailsApplication application;
    private static final String PLUGINS_PREFIX = "plugins/";
    private static final String SLASH = "/";
    private static final Pattern HAS_SCHEME_PATTERN = Pattern.compile("[^:/?#]+:.*");
    private static final String GRAILS_APP_DIR_PATTERN = "/grails-app/.*";

    public DevelopmentResourceLoader(GrailsApplication application) {
        this.application = application;
    }

    public DevelopmentResourceLoader() {
    }

    public DevelopmentResourceLoader(GrailsApplication application, String baseLocation) {
        this(application);
        this.baseLocation = baseLocation;
    }

    public Resource getResource(String location) {
        if (Metadata.getCurrent().isWarDeployed()) {
            return super.getResource(location);
        }
        location = this.getRealLocationInProject(location);
        return super.getResource(location);
    }

    protected String getRealLocationInProject(String location) {
        if (new File(location).exists()) {
            return "file:" + location;
        }
        if (!location.startsWith(SLASH)) {
            location = SLASH + location;
        }
        if (HAS_SCHEME_PATTERN.matcher(location).matches()) {
            return location;
        }
        if (BuildSettingsHolder.getSettings().isInlinePluginLocation(new File(location.replaceAll(GRAILS_APP_DIR_PATTERN, "")))) {
            return "file:" + location;
        }
        if (!location.startsWith("/WEB-INF")) {
            return "web-app" + location;
        }
        String noWebInf = location.substring("/WEB-INF".length() + 1);
        String defaultPath = "file:" + this.baseLocation + SLASH + noWebInf;
        if (!noWebInf.startsWith(PLUGINS_PREFIX)) {
            return defaultPath;
        }
        if (this.application != null) {
            BuildSettings settings = BuildSettingsHolder.getSettings();
            PluginBuildSettings pluginBuildSettings = GrailsPluginUtils.getPluginBuildSettings();
            String pluginPath = StringUtils.substringAfter((String)noWebInf, (String)SLASH);
            String pluginName = StringUtils.substringBefore((String)pluginPath, (String)SLASH);
            String remainingPath = StringUtils.substringAfter((String)pluginPath, (String)SLASH);
            Resource r = pluginBuildSettings.getPluginDirForName(pluginName);
            if (r != null) {
                try {
                    return "file:" + r.getFile().getAbsolutePath() + SLASH + remainingPath;
                }
                catch (IOException e) {
                    LOG.debug((Object)("Unable to locate plugin resource -- returning default path " + defaultPath + "."), (Throwable)e);
                    return defaultPath;
                }
            }
            if (settings != null) {
                return "file:" + settings.getProjectPluginsDir().getAbsolutePath() + SLASH + pluginName + SLASH + remainingPath;
            }
        }
        return defaultPath;
    }
}

