/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.Environment;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.grails.commons.ApplicationHolder;
import org.codehaus.groovy.grails.commons.DefaultGrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsApplicationFactoryBean
implements FactoryBean<GrailsApplication>,
InitializingBean {
    private static Log LOG = LogFactory.getLog(GrailsApplicationFactoryBean.class);
    private GrailsApplication grailsApplication = null;
    private GrailsResourceLoader resourceLoader;
    private Resource descriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.descriptor != null && this.descriptor.exists()) {
            LOG.info((Object)"Loading Grails application with information from descriptor.");
            Object classLoader = null;
            if (Environment.getCurrent().isReloadEnabled()) {
                LOG.info((Object)"Reloading is enabled, using GrailsClassLoader.");
                ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
                CompilerConfiguration config = CompilerConfiguration.DEFAULT;
                config.setSourceEncoding("UTF-8");
                classLoader = new GrailsClassLoader(parentLoader, config, this.resourceLoader);
            } else {
                LOG.info((Object)"No reloading, using standard classloader.");
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            ArrayList classes = new ArrayList();
            InputStream inputStream = null;
            try {
                inputStream = this.descriptor.getInputStream();
                GPathResult root = new XmlSlurper().parse(inputStream);
                GPathResult resources = (GPathResult)root.getProperty("resources");
                GPathResult grailsClasses = (GPathResult)resources.getProperty("resource");
                for (int i = 0; i < grailsClasses.size(); ++i) {
                    GPathResult node = (GPathResult)grailsClasses.getAt(i);
                    String className = node.text();
                    try {
                        Class<?> clazz = classLoader instanceof GrailsClassLoader ? ((ClassLoader)classLoader).loadClass(className) : Class.forName(className, true, (ClassLoader)classLoader);
                        classes.add(clazz);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn((Object)("Class with name [" + className + "] was not found, and hence not loaded. Possible empty class or script definition?"));
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            Class[] loadedClasses = classes.toArray(new Class[classes.size()]);
            this.grailsApplication = new DefaultGrailsApplication(loadedClasses, (ClassLoader)classLoader);
        } else {
            Assert.notNull((Object)this.resourceLoader, (String)"Property [resourceLoader] must be set!");
            this.grailsApplication = new DefaultGrailsApplication(this.resourceLoader);
        }
        ApplicationHolder.setApplication(this.grailsApplication);
    }

    public GrailsApplication getObject() {
        return this.grailsApplication;
    }

    public Class<GrailsApplication> getObjectType() {
        return GrailsApplication.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setGrailsResourceLoader(GrailsResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setGrailsDescriptor(Resource r) {
        this.descriptor = r;
    }
}

