/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.spring;

import grails.spring.BeanBuilder;
import grails.util.CollectionUtils;
import grails.util.Environment;
import grails.util.Holders;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.DefaultRuntimeSpringConfiguration;
import org.codehaus.groovy.grails.commons.spring.GrailsApplicationContext;
import org.codehaus.groovy.grails.commons.spring.GrailsContextEvent;
import org.codehaus.groovy.grails.commons.spring.ReloadAwareAutowireCapableBeanFactory;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.commons.spring.WebRuntimeSpringConfiguration;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsRuntimeConfigurator
implements ApplicationContextAware {
    public static final String BEAN_ID = "grailsConfigurator";
    public static final String GRAILS_URL_MAPPINGS = "grailsUrlMappings";
    public static final String SPRING_RESOURCES_XML = "/WEB-INF/spring/resources.xml";
    public static final String SPRING_RESOURCES_GROOVY = "/WEB-INF/spring/resources.groovy";
    public static final String SPRING_RESOURCES_CLASS = "resources";
    public static final String OPEN_SESSION_IN_VIEW_INTERCEPTOR_BEAN = "openSessionInViewInterceptor";
    public static final String TRANSACTION_MANAGER_BEAN = "transactionManager";
    public static final String HIBERNATE_PROPERTIES_BEAN = "hibernateProperties";
    public static final String DIALECT_DETECTOR_BEAN = "dialectDetector";
    public static final String SESSION_FACTORY_BEAN = "sessionFactory";
    public static final String DATA_SOURCE_BEAN = "dataSource";
    public static final String MESSAGE_SOURCE_BEAN = "messageSource";
    public static final String MULTIPART_RESOLVER_BEAN = "multipartResolver";
    public static final String EXCEPTION_HANDLER_BEAN = "exceptionHandler";
    public static final String CUSTOM_EDITORS_BEAN = "customEditors";
    public static final String CLASS_EDITOR_BEAN = "classEditor";
    public static final String CLASS_LOADER_BEAN = "classLoader";
    private static final Log LOG = LogFactory.getLog(GrailsRuntimeConfigurator.class);
    public static final String GRAILS_INITIALIZING = "org.grails.internal.INITIALIZING";
    private GrailsApplication application;
    private ApplicationContext parent;
    private GrailsPluginManager pluginManager;
    private WebRuntimeSpringConfiguration webSpringConfig;
    private static final String DEVELOPMENT_SPRING_RESOURCES_XML = "file:./grails-app/conf/spring/resources.xml";
    private static volatile BeanBuilder springGroovyResourcesBeanBuilder = null;

    public GrailsRuntimeConfigurator(GrailsApplication application) {
        this(application, null);
    }

    public GrailsRuntimeConfigurator(GrailsApplication application, ApplicationContext parent) {
        this.application = application;
        this.parent = parent;
        try {
            this.pluginManager = parent == null ? null : (GrailsPluginManager)parent.getBean(GrailsPluginManager.class);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        if (this.pluginManager == null) {
            this.pluginManager = Holders.getPluginManager();
        }
        if (this.pluginManager == null) {
            this.pluginManager = new DefaultGrailsPluginManager("**/plugins/*/**GrailsPlugin.groovy", application);
        }
        Holders.setPluginManager(this.pluginManager);
    }

    public WebApplicationContext configure() {
        return this.configure(null);
    }

    public WebApplicationContext configure(ServletContext context) {
        return this.configure(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApplicationContext configure(ServletContext context, boolean loadExternalBeans) {
        WebApplicationContext ctx;
        Assert.notNull((Object)this.application);
        try {
            this.webSpringConfig = this.createWebRuntimeSpringConfiguration(this.application, this.parent, this.application.getClassLoader());
            this.webSpringConfig.setBeanFactory((ListableBeanFactory)new ReloadAwareAutowireCapableBeanFactory());
            if (context != null) {
                this.webSpringConfig.setServletContext(context);
                this.pluginManager.setServletContext(context);
            }
            if (!this.pluginManager.isInitialised()) {
                this.pluginManager.loadPlugins();
            }
            if (!this.application.isInitialised()) {
                this.pluginManager.doArtefactConfiguration();
                this.application.initialise();
            }
            this.pluginManager.registerProvidedArtefacts(this.application);
            this.registerParentBeanFactoryPostProcessors(this.webSpringConfig);
            this.pluginManager.doRuntimeConfiguration((RuntimeSpringConfiguration)this.webSpringConfig);
            LOG.debug((Object)"[RuntimeConfiguration] Processing additional external configurations");
            if (loadExternalBeans) {
                this.doPostResourceConfiguration(this.application, (RuntimeSpringConfiguration)this.webSpringConfig);
            }
            GrailsRuntimeConfigurator.reset();
            this.application.setMainContext(this.webSpringConfig.getUnrefreshedApplicationContext());
            Environment.setInitializing((boolean)true);
            ctx = (WebApplicationContext)this.webSpringConfig.getApplicationContext();
            Environment.setInitializing((boolean)false);
            this.pluginManager.setApplicationContext((ApplicationContext)ctx);
            this.pluginManager.doDynamicMethods();
            ctx.publishEvent((ApplicationEvent)new GrailsContextEvent(ctx, 0));
            this.performPostProcessing(ctx);
            this.application.refreshConstraints();
        }
        finally {
            ClassPropertyFetcher.clearClassPropertyFetcherCache();
        }
        return ctx;
    }

    protected WebRuntimeSpringConfiguration createWebRuntimeSpringConfiguration(GrailsApplication app, ApplicationContext parentCtx, ClassLoader classLoader) {
        return new WebRuntimeSpringConfiguration(parentCtx, classLoader);
    }

    private void registerParentBeanFactoryPostProcessors(WebRuntimeSpringConfiguration springConfig) {
        if (this.parent == null) {
            return;
        }
        Map parentPostProcessors = this.parent.getBeansOfType(BeanFactoryPostProcessor.class);
        for (Object o : parentPostProcessors.values()) {
            BeanFactoryPostProcessor postProcessor = (BeanFactoryPostProcessor)o;
            ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor(postProcessor);
        }
    }

    public void reconfigure(GrailsApplicationContext current, ServletContext servletContext, boolean loadExternalBeans) {
        DefaultRuntimeSpringConfiguration springConfig = this.parent != null ? new DefaultRuntimeSpringConfiguration(this.parent) : new DefaultRuntimeSpringConfiguration();
        Assert.state((boolean)this.pluginManager.isInitialised(), (String)"Cannot re-configure Grails application when it hasn't even been configured yet!");
        this.pluginManager.doRuntimeConfiguration((RuntimeSpringConfiguration)springConfig);
        List beanNames = springConfig.getBeanNames();
        Iterator i$ = beanNames.iterator();
        while (i$.hasNext()) {
            String beanName;
            String name = beanName = (String)i$.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Re-creating bean definition [" + name + "]"));
            }
            current.registerBeanDefinition(name, (BeanDefinition)springConfig.createBeanDefinition(name));
            current.getBean(name);
        }
        this.pluginManager.doDynamicMethods();
        this.pluginManager.doPostProcessing((ApplicationContext)current);
        if (loadExternalBeans) {
            this.doPostResourceConfiguration(this.application, (RuntimeSpringConfiguration)springConfig);
        }
        GrailsRuntimeConfigurator.reset();
    }

    private void performPostProcessing(WebApplicationContext ctx) {
        this.pluginManager.doPostProcessing((ApplicationContext)ctx);
    }

    public WebApplicationContext configureDomainOnly() {
        WebRuntimeSpringConfiguration springConfig = new WebRuntimeSpringConfiguration(this.parent, this.application.getClassLoader());
        springConfig.setServletContext((ServletContext)new MockServletContext());
        if (!this.pluginManager.isInitialised()) {
            this.pluginManager.loadPlugins();
        }
        if (this.pluginManager.hasGrailsPlugin("hibernate")) {
            this.pluginManager.doRuntimeConfiguration("hibernate", (RuntimeSpringConfiguration)springConfig);
        }
        WebApplicationContext ctx = (WebApplicationContext)springConfig.getApplicationContext();
        this.performPostProcessing(ctx);
        this.application.refreshConstraints();
        return ctx;
    }

    private void doPostResourceConfiguration(GrailsApplication app, RuntimeSpringConfiguration springConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String resourceName = null;
        try {
            Resource springResources;
            if (app.isWarDeployed()) {
                resourceName = SPRING_RESOURCES_XML;
                springResources = this.parent.getResource(resourceName);
            } else {
                resourceName = DEVELOPMENT_SPRING_RESOURCES_XML;
                PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
                springResources = patternResolver.getResource(resourceName);
            }
            if (springResources != null && springResources.exists()) {
                LOG.debug((Object)("[RuntimeConfiguration] Configuring additional beans from " + springResources.getURL()));
                XmlBeanFactory xmlBf = new XmlBeanFactory(springResources);
                xmlBf.setBeanClassLoader(classLoader);
                String[] beanNames = xmlBf.getBeanDefinitionNames();
                LOG.debug((Object)("[RuntimeConfiguration] Found [" + beanNames.length + "] beans to configure"));
                for (String beanName : beanNames) {
                    String[] aliases;
                    BeanDefinition bd = xmlBf.getBeanDefinition(beanName);
                    String beanClassName = bd.getBeanClassName();
                    Class beanClass = beanClassName == null ? null : ClassUtils.forName((String)beanClassName, (ClassLoader)classLoader);
                    springConfig.addBeanDefinition(beanName, bd);
                    for (String alias : aliases = xmlBf.getAliases(beanName)) {
                        springConfig.addAlias(alias, beanName);
                    }
                    if (beanClass == null || !BeanFactoryPostProcessor.class.isAssignableFrom(beanClass)) continue;
                    ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor((BeanFactoryPostProcessor)xmlBf.getBean(beanName));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[RuntimeConfiguration] " + resourceName + " not found. Skipping configuration."));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("[RuntimeConfiguration] Unable to perform post initialization config: " + resourceName), (Throwable)ex);
        }
        GrailsRuntimeConfigurator.loadSpringGroovyResources(springConfig, app);
    }

    private static void doLoadSpringGroovyResources(RuntimeSpringConfiguration config, GrailsApplication application, GenericApplicationContext context) {
        GrailsRuntimeConfigurator.loadExternalSpringConfig(config, application);
        if (context != null) {
            springGroovyResourcesBeanBuilder.registerBeans((BeanDefinitionRegistry)context);
        }
    }

    public static void loadExternalSpringConfig(RuntimeSpringConfiguration config, GrailsApplication application) {
        if (springGroovyResourcesBeanBuilder == null) {
            try {
                Class groovySpringResourcesClass = null;
                try {
                    groovySpringResourcesClass = ClassUtils.forName((String)SPRING_RESOURCES_CLASS, (ClassLoader)application.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (groovySpringResourcesClass != null) {
                    GrailsRuntimeConfigurator.reloadSpringResourcesConfig(config, application, groovySpringResourcesClass);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"[RuntimeConfiguration] Unable to load beans from resources.groovy", (Throwable)ex);
            }
        } else if (!springGroovyResourcesBeanBuilder.getSpringConfig().equals(config)) {
            springGroovyResourcesBeanBuilder.registerBeans(config);
        }
    }

    public static BeanBuilder reloadSpringResourcesConfig(RuntimeSpringConfiguration config, GrailsApplication application, Class<?> groovySpringResourcesClass) throws InstantiationException, IllegalAccessException {
        springGroovyResourcesBeanBuilder = new BeanBuilder(null, config, Thread.currentThread().getContextClassLoader());
        springGroovyResourcesBeanBuilder.setBinding(new Binding(CollectionUtils.newMap((Object[])new Object[]{"application", application, "grailsApplication", application})));
        Script script = (Script)groovySpringResourcesClass.newInstance();
        script.run();
        Object beans = script.getProperty("beans");
        springGroovyResourcesBeanBuilder.beans((Closure)beans);
        return springGroovyResourcesBeanBuilder;
    }

    public static void loadSpringGroovyResources(RuntimeSpringConfiguration config, GrailsApplication application) {
        GrailsRuntimeConfigurator.loadExternalSpringConfig(config, application);
    }

    public static void loadSpringGroovyResourcesIntoContext(RuntimeSpringConfiguration config, GrailsApplication application, GenericApplicationContext context) {
        GrailsRuntimeConfigurator.loadExternalSpringConfig(config, application);
        GrailsRuntimeConfigurator.doLoadSpringGroovyResources(config, application, context);
    }

    public void setLoadExternalPersistenceConfig(boolean b) {
    }

    public void setPluginManager(GrailsPluginManager manager) {
        this.pluginManager = manager;
    }

    public GrailsPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.parent = applicationContext;
    }

    public static void reset() {
        springGroovyResourcesBeanBuilder = null;
    }

    WebRuntimeSpringConfiguration getWebRuntimeSpringConfiguration() {
        return this.webSpringConfig;
    }
}

