/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import grails.util.Environment;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsControllerClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;

public class ControllerArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsApplicationAware {
    private static final String URL_MAPPING_CACHE_MAX_SIZE = "grails.urlmapping.cache.maxsize";
    private static final GrailsClass NO_CONTROLLER = new AbstractGrailsClass((Class)Object.class, "Controller"){};
    public static final String TYPE = "Controller";
    public static final String PLUGIN_NAME = "controllers";
    private ConcurrentLinkedHashMap<String, GrailsClass> uriToControllerClassCache;
    private ArtefactInfo artefactInfo;
    private GrailsApplication grailsApplication;

    public ControllerArtefactHandler() {
        super(TYPE, GrailsControllerClass.class, DefaultGrailsControllerClass.class, TYPE, false);
    }

    public void initialize(ArtefactInfo artefacts) {
        Object cacheSize = this.grailsApplication.getFlatConfig().get(URL_MAPPING_CACHE_MAX_SIZE);
        if (cacheSize == null) {
            cacheSize = 10000;
        }
        this.uriToControllerClassCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(500).maximumWeightedCapacity(new Integer(cacheSize.toString()).intValue()).build();
        this.artefactInfo = artefacts;
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public GrailsClass getArtefactForFeature(Object feature) {
        if (this.artefactInfo == null) {
            return null;
        }
        String uri = feature.toString();
        GrailsClass controllerClass = (GrailsClass)this.uriToControllerClassCache.get((Object)uri);
        if (controllerClass == null) {
            GrailsClass[] controllerClasses = this.artefactInfo.getGrailsClasses();
            for (int i = controllerClasses.length - 1; i >= 0; --i) {
                GrailsClass c = controllerClasses[i];
                if (!((GrailsControllerClass)c).mapsToURI(uri)) continue;
                controllerClass = c;
                break;
            }
            if (controllerClass == null) {
                controllerClass = NO_CONTROLLER;
            }
            if (Environment.getCurrent() != Environment.DEVELOPMENT) {
                this.uriToControllerClassCache.put((Object)uri, (Object)controllerClass);
            }
        }
        if (controllerClass == NO_CONTROLLER) {
            controllerClass = null;
        }
        return controllerClass;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

