/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.spring.BeanBuilder;
import grails.util.BuildScope;
import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Environment;
import grails.util.GrailsUtil;
import grails.util.Metadata;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsResourceUtils;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoaderHolder;
import org.codehaus.groovy.grails.documentation.DocumentationContext;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.plugins.AbstractGrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.codehaus.groovy.grails.support.ParentApplicationContextAware;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.TypeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsPlugin
extends AbstractGrailsPlugin
implements ParentApplicationContextAware {
    private static final String PLUGIN_CHANGE_EVENT_CTX = "ctx";
    private static final String PLUGIN_CHANGE_EVENT_APPLICATION = "application";
    private static final String PLUGIN_CHANGE_EVENT_PLUGIN = "plugin";
    private static final String PLUGIN_CHANGE_EVENT_SOURCE = "source";
    private static final String PLUGIN_CHANGE_EVENT_MANAGER = "manager";
    private static final String PLUGIN_OBSERVE = "observe";
    private static final Log LOG = LogFactory.getLog(DefaultGrailsPlugin.class);
    private static final String INCLUDES = "includes";
    private static final String EXCLUDES = "excludes";
    private AbstractGrailsPlugin.GrailsPluginClass pluginGrailsClass;
    private GroovyObject plugin;
    protected BeanWrapper pluginBean;
    private Closure onChangeListener;
    private Resource[] watchedResources = new Resource[0];
    private long[] modifiedTimes = new long[0];
    private PathMatchingResourcePatternResolver resolver;
    private String[] resourcesReferences;
    private int[] resourceCount;
    private String[] loadAfterNames = new String[0];
    private String[] loadBeforeNames = new String[0];
    private String[] influencedPluginNames = new String[0];
    private String status = "enabled";
    private String[] observedPlugins;
    private long pluginLastModified = Long.MAX_VALUE;
    private URL pluginUrl;
    private Closure onConfigChangeListener;
    private Closure onShutdownListener;
    private Class<?>[] providedArtefacts = new Class[0];
    private Map pluginScopes;
    private Map pluginEnvs;
    private List<String> pluginExcludes = new ArrayList<String>();
    private Collection<? extends TypeFilter> typeFilters = new ArrayList<TypeFilter>();
    private Resource pluginDescriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultGrailsPlugin(Class<?> pluginClass, Resource resource, GrailsApplication application) {
        super(pluginClass, application);
        this.dependencies = Collections.emptyMap();
        this.pluginDescriptor = resource;
        this.resolver = new PathMatchingResourcePatternResolver();
        if (resource != null) {
            try {
                InputStream is;
                this.pluginUrl = resource.getURL();
                URLConnection urlConnection = null;
                try {
                    urlConnection = this.pluginUrl.openConnection();
                    this.pluginLastModified = urlConnection.getLastModified();
                    is = urlConnection != null ? urlConnection.getInputStream() : null;
                }
                catch (Throwable throwable) {
                    InputStream is2 = urlConnection != null ? urlConnection.getInputStream() : null;
                    IOUtils.closeQuietly((InputStream)is2);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (IOException e) {
                LOG.warn((Object)("I/O error reading last modified date of plug-in [" + pluginClass + "], you won't be able to reload changes: " + e.getMessage()), (Throwable)e);
            }
        }
        this.initialisePlugin(pluginClass);
    }

    private void initialisePlugin(Class<?> clazz) {
        this.pluginGrailsClass = new AbstractGrailsPlugin.GrailsPluginClass(clazz);
        this.plugin = (GroovyObject)this.pluginGrailsClass.newInstance();
        this.pluginBean = new BeanWrapperImpl((Object)this.plugin);
        this.evaluatePluginVersion();
        this.evaluatePluginDependencies();
        this.evaluatePluginLoadAfters();
        this.evaluateProvidedArtefacts();
        this.evaluatePluginEvictionPolicy();
        this.evaluatePluginInfluencePolicy();
        this.evaluateOnChangeListener();
        this.evaluateObservedPlugins();
        this.evaluatePluginStatus();
        this.evaluatePluginScopes();
        this.evaluatePluginExcludes();
        this.evaluateTypeFilters();
    }

    private void evaluateTypeFilters() {
        Object result = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "typeFilters");
        if (result instanceof List) {
            this.typeFilters = (List)result;
        }
    }

    private void evaluatePluginExcludes() {
        Object result = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "pluginExcludes");
        if (result instanceof List) {
            this.pluginExcludes = (List)result;
        }
    }

    private void evaluatePluginScopes() {
        this.pluginScopes = this.evaluateIncludeExcludeProperty("scopes", new Closure(this){
            private static final long serialVersionUID = 1L;

            public Object call(Object arguments) {
                String scopeName = ((String)arguments).toUpperCase();
                try {
                    return BuildScope.valueOf((String)scopeName);
                }
                catch (IllegalArgumentException e) {
                    throw new GrailsConfigurationException("Plugin " + (Object)((Object)this) + " specifies invalid scope [" + scopeName + "]");
                }
            }
        });
        this.pluginEnvs = this.evaluateIncludeExcludeProperty("environments", new Closure(this){
            private static final long serialVersionUID = 1L;

            public Object call(Object arguments) {
                String envName = (String)arguments;
                Environment env = Environment.getEnvironment((String)envName);
                if (env != null) {
                    return env.getName();
                }
                return arguments;
            }
        });
    }

    private Map evaluateIncludeExcludeProperty(String name, Closure converter) {
        HashMap resultMap = new HashMap();
        Object propertyValue = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, name);
        if (propertyValue instanceof Map) {
            Map containedMap = (Map)propertyValue;
            Object includes = containedMap.get(INCLUDES);
            this.evaluateAndAddIncludeExcludeObject(resultMap, includes, true, converter);
            Object excludes = containedMap.get(EXCLUDES);
            this.evaluateAndAddIncludeExcludeObject(resultMap, excludes, false, converter);
        } else {
            this.evaluateAndAddIncludeExcludeObject(resultMap, propertyValue, true, converter);
        }
        return resultMap;
    }

    private void evaluateAndAddIncludeExcludeObject(Map targetMap, Object includeExcludeObject, boolean include, Closure converter) {
        if (includeExcludeObject instanceof String) {
            String includeExcludeString = (String)includeExcludeObject;
            this.evaluateAndAddToIncludeExcludeSet(targetMap, includeExcludeString, include, converter);
        } else if (includeExcludeObject instanceof List) {
            List includeExcludeList = (List)includeExcludeObject;
            this.evaluateAndAddListOfValues(targetMap, includeExcludeList, include, converter);
        }
    }

    private void evaluateAndAddListOfValues(Map targetMap, List includeExcludeList, boolean include, Closure converter) {
        for (Object scope : includeExcludeList) {
            if (!(scope instanceof String)) continue;
            String scopeName = (String)scope;
            this.evaluateAndAddToIncludeExcludeSet(targetMap, scopeName, include, converter);
        }
    }

    private void evaluateAndAddToIncludeExcludeSet(Map targetMap, String includeExcludeString, boolean include, Closure converter) {
        Set set = this.lazilyCreateIncludeOrExcludeSet(targetMap, include);
        set.add(converter.call((Object)includeExcludeString));
    }

    private Set lazilyCreateIncludeOrExcludeSet(Map targetMap, boolean include) {
        String key = include ? INCLUDES : EXCLUDES;
        HashSet set = (HashSet)targetMap.get(key);
        if (set == null) {
            set = new HashSet();
            targetMap.put(key, set);
        }
        return set;
    }

    private void evaluateProvidedArtefacts() {
        Object result = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "providedArtefacts");
        if (result instanceof Collection) {
            Collection artefactList = (Collection)result;
            this.providedArtefacts = artefactList.toArray(new Class[artefactList.size()]);
        }
    }

    public DefaultGrailsPlugin(Class<?> pluginClass, GrailsApplication application) {
        this(pluginClass, null, application);
    }

    private void evaluateObservedPlugins() {
        Object observeProperty;
        if (this.pluginBean.isReadableProperty(PLUGIN_OBSERVE) && (observeProperty = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, PLUGIN_OBSERVE)) instanceof Collection) {
            Collection observeList = (Collection)observeProperty;
            this.observedPlugins = new String[observeList.size()];
            int j = 0;
            for (Object anObserveList : observeList) {
                String pluginName = anObserveList.toString();
                this.observedPlugins[j++] = pluginName;
            }
        }
        if (this.observedPlugins == null) {
            this.observedPlugins = new String[0];
        }
    }

    private void evaluatePluginStatus() {
        Object statusObj;
        if (this.pluginBean.isReadableProperty("status") && (statusObj = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "status")) != null) {
            this.status = statusObj.toString().toLowerCase();
        }
    }

    private void evaluateOnChangeListener() {
        block26: {
            if (this.pluginBean.isReadableProperty("onShutdown")) {
                this.onShutdownListener = (Closure)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "onShutdown");
            }
            if (this.pluginBean.isReadableProperty("onConfigChange")) {
                this.onConfigChangeListener = (Closure)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "onConfigChange");
            }
            if (this.pluginBean.isReadableProperty("onChange")) {
                this.onChangeListener = (Closure)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "onChange");
            }
            boolean warDeployed = Metadata.getCurrent().isWarDeployed();
            boolean reloadEnabled = Environment.getCurrent().isReloadEnabled();
            if (!reloadEnabled && warDeployed || this.onChangeListener == null) {
                return;
            }
            Object referencedResources = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "watchedResources");
            try {
                int i;
                ArrayList<String> resourceList = null;
                if (referencedResources instanceof String) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Configuring plugin " + this + " to watch resources with pattern: " + referencedResources));
                    }
                    resourceList = new ArrayList<String>();
                    resourceList.add(referencedResources.toString());
                } else if (referencedResources instanceof List) {
                    resourceList = (ArrayList<String>)referencedResources;
                }
                if (resourceList == null) break block26;
                ArrayList<String> resourceListTmp = new ArrayList<String>();
                Resource[] pluginDirs = GrailsPluginUtils.getPluginDirectories();
                Environment env = Environment.getCurrent();
                String baseLocation = env.getReloadLocation();
                for (Object e : resourceList) {
                    String stringRef = e.toString();
                    if (!warDeployed) {
                        for (Resource pluginDir : pluginDirs) {
                            if (pluginDir == null) continue;
                            String pluginResources = this.getResourcePatternForBaseLocation(pluginDir.getFile().getCanonicalPath(), stringRef);
                            resourceListTmp.add(pluginResources);
                        }
                        this.addBaseLocationPattern(resourceListTmp, baseLocation, stringRef);
                        continue;
                    }
                    this.addBaseLocationPattern(resourceListTmp, baseLocation, stringRef);
                }
                this.resourcesReferences = new String[resourceListTmp.size()];
                this.resourceCount = new int[resourceListTmp.size()];
                for (i = 0; i < this.resourcesReferences.length; ++i) {
                    String string;
                    this.resourcesReferences[i] = string = (String)resourceListTmp.get(i);
                }
                for (i = 0; i < this.resourcesReferences.length; ++i) {
                    String string = this.resourcesReferences[i];
                    Object[] tmp = new Resource[]{};
                    try {
                        try {
                            tmp = (Resource[])ArrayUtils.addAll((Object[])tmp, (Object[])this.resolver.getResources(string));
                        }
                        catch (IOException e) {}
                    }
                    catch (Exception ex) {
                        LOG.debug((Object)("Resource pattern [" + string + "] is not valid - maybe base directory does not exist?"));
                    }
                    this.resourceCount[i] = tmp.length;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Watching resource set [" + (i + 1) + "]: " + ArrayUtils.toString((Object)tmp)));
                    }
                    if (tmp.length == 0) {
                        tmp = this.resolver.getResources("classpath*:" + string);
                    }
                    if (tmp.length <= 0) continue;
                    this.watchedResources = (Resource[])ArrayUtils.addAll((Object[])this.watchedResources, (Object[])tmp);
                }
            }
            catch (IllegalArgumentException e) {
                if (GrailsUtil.isDevelopmentEnv()) {
                    LOG.debug((Object)("Cannot load plug-in resource watch list from [" + ArrayUtils.toString((Object)this.resourcesReferences) + "]. This means that the plugin " + this + ", will not be able to auto-reload changes effectively. Try runnng grails upgrade.: " + e.getMessage()));
                }
            }
            catch (IOException e) {
                if (!GrailsUtil.isDevelopmentEnv()) break block26;
                LOG.debug((Object)("Cannot load plug-in resource watch list from [" + ArrayUtils.toString((Object)this.resourcesReferences) + "]. This means that the plugin " + this + ", will not be able to auto-reload changes effectively. Try runnng grails upgrade.: " + e.getMessage()));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plugin " + this + " found [" + this.watchedResources.length + "] to watch"));
        }
        try {
            this.initializeModifiedTimes();
        }
        catch (IOException e) {
            LOG.warn((Object)("I/O exception initializing modified times for watched resources: " + e.getMessage()), (Throwable)e);
        }
    }

    private void addBaseLocationPattern(List<String> resourceList, String baseLocation, String pattern) {
        if (baseLocation != null) {
            String reloadLocationResourcePattern = this.getResourcePatternForBaseLocation(baseLocation, pattern);
            resourceList.add(reloadLocationResourcePattern);
        } else {
            resourceList.add(pattern);
        }
    }

    private String getResourcePatternForBaseLocation(String baseLocation, String resourcePath) {
        String location = baseLocation;
        if (!location.endsWith(File.separator)) {
            location = location + File.separator;
        }
        if (resourcePath.startsWith(".")) {
            resourcePath = resourcePath.substring(1);
        } else if (resourcePath.startsWith("file:./")) {
            resourcePath = resourcePath.substring(7);
        }
        resourcePath = "file:" + location + resourcePath;
        return resourcePath;
    }

    private void evaluatePluginInfluencePolicy() {
        List influencedList;
        if (this.pluginBean.isReadableProperty("influences") && (influencedList = (List)this.pluginBean.getPropertyValue("influences")) != null) {
            this.influencedPluginNames = influencedList.toArray(new String[influencedList.size()]);
        }
    }

    private void evaluatePluginVersion() {
        if (!this.pluginBean.isReadableProperty("version")) {
            throw new PluginException("Plugin [" + this.getName() + "] must specify a version!");
        }
        Object vobj = this.plugin.getProperty("version");
        if (vobj == null) {
            throw new PluginException("Plugin " + this + " must specify a version. eg: def version = 0.1");
        }
        this.version = vobj.toString();
    }

    private void evaluatePluginEvictionPolicy() {
        List pluginsToEvict;
        if (this.pluginBean.isReadableProperty("evict") && (pluginsToEvict = (List)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "evict")) != null) {
            this.evictionList = new String[pluginsToEvict.size()];
            int index = 0;
            for (Object o : pluginsToEvict) {
                this.evictionList[index++] = o != null ? o.toString() : "";
            }
        }
    }

    private void evaluatePluginLoadAfters() {
        List loadBeforeNamesList;
        List loadAfterNamesList;
        if (this.pluginBean.isReadableProperty("loadAfter") && (loadAfterNamesList = (List)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "loadAfter")) != null) {
            this.loadAfterNames = loadAfterNamesList.toArray(new String[loadAfterNamesList.size()]);
        }
        if (this.pluginBean.isReadableProperty("loadBefore") && (loadBeforeNamesList = (List)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "loadBefore")) != null) {
            this.loadBeforeNames = loadBeforeNamesList.toArray(new String[loadBeforeNamesList.size()]);
        }
    }

    private void evaluatePluginDependencies() {
        if (this.pluginBean.isReadableProperty("dependsOn")) {
            this.dependencies = (Map)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "dependsOn");
            this.dependencyNames = this.dependencies.keySet().toArray(new String[this.dependencies.size()]);
        }
    }

    @Override
    public String[] getLoadAfterNames() {
        return this.loadAfterNames;
    }

    @Override
    public String[] getLoadBeforeNames() {
        return this.loadBeforeNames;
    }

    public PathMatchingResourcePatternResolver getResolver() {
        return this.resolver;
    }

    public ApplicationContext getParentCtx() {
        return this.application.getParentContext();
    }

    public BeanBuilder beans(Closure closure) {
        BeanBuilder bb = new BeanBuilder(this.getParentCtx(), (ClassLoader)new GroovyClassLoader(this.application.getClassLoader()));
        bb.invokeMethod("beans", (Object)new Object[]{closure});
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeModifiedTimes() throws IOException {
        this.modifiedTimes = new long[this.watchedResources.length];
        for (int i = 0; i < this.watchedResources.length; ++i) {
            Resource r = this.watchedResources[i];
            URLConnection c = null;
            try {
                c = r.getURL().openConnection();
                c.setDoInput(false);
                c.setDoOutput(false);
                this.modifiedTimes[i] = c.getLastModified();
                continue;
            }
            finally {
                if (c != null) {
                    try {
                        InputStream is = c.getInputStream();
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWithApplicationContext(ApplicationContext ctx) {
        try {
            if (this.pluginBean.isReadableProperty("doWithApplicationContext")) {
                Closure c = (Closure)this.plugin.getProperty("doWithApplicationContext");
                if (this.enableDocumentationGeneration()) {
                    DocumentationContext.getInstance().setActive(true);
                }
                c.setDelegate((Object)this);
                c.call(new Object[]{ctx});
            }
        }
        finally {
            if (this.enableDocumentationGeneration()) {
                DocumentationContext.getInstance().reset();
            }
        }
    }

    private boolean enableDocumentationGeneration() {
        return !Metadata.getCurrent().isWarDeployed() && this.isBasePlugin();
    }

    @Override
    public void doWithRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        if (this.pluginBean.isReadableProperty("doWithSpring")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Plugin " + this + " is participating in Spring configuration..."));
            }
            Closure c = (Closure)this.plugin.getProperty("doWithSpring");
            BeanBuilder bb = new BeanBuilder(this.getParentCtx(), springConfig, this.application.getClassLoader());
            Binding b = new Binding();
            b.setVariable(PLUGIN_CHANGE_EVENT_APPLICATION, (Object)this.application);
            b.setVariable(PLUGIN_CHANGE_EVENT_MANAGER, (Object)this.getManager());
            b.setVariable(PLUGIN_CHANGE_EVENT_PLUGIN, (Object)this);
            b.setVariable("parentCtx", (Object)this.getParentCtx());
            b.setVariable("resolver", (Object)this.getResolver());
            bb.setBinding(b);
            c.setDelegate((Object)bb);
            bb.invokeMethod("beans", (Object)new Object[]{c});
        }
    }

    @Override
    public String getName() {
        return this.pluginGrailsClass.getLogicalPropertyName();
    }

    @Override
    public void addExclude(BuildScope buildScope) {
        this.addExcludeRuleInternal(this.pluginScopes, buildScope);
    }

    private void addExcludeRuleInternal(Map map, Object o) {
        Collection includes;
        ArrayList<Object> excludes = (ArrayList<Object>)map.get(EXCLUDES);
        if (excludes == null) {
            excludes = new ArrayList<Object>();
            map.put(EXCLUDES, excludes);
        }
        if ((includes = (Collection)map.get(INCLUDES)) != null) {
            includes.remove(o);
        }
        excludes.add(o);
    }

    @Override
    public void addExclude(Environment env) {
        this.addExcludeRuleInternal(this.pluginEnvs, env);
    }

    @Override
    public boolean supportsScope(BuildScope buildScope) {
        return this.supportsValueInIncludeExcludeMap(this.pluginScopes, buildScope);
    }

    @Override
    public boolean supportsEnvironment(Environment environment) {
        return this.supportsValueInIncludeExcludeMap(this.pluginEnvs, environment.getName());
    }

    @Override
    public boolean supportsCurrentScopeAndEnvironment() {
        BuildScope bs = BuildScope.getCurrent();
        Environment e = Environment.getCurrent();
        return this.supportsEnvironment(e) && this.supportsScope(bs);
    }

    private boolean supportsValueInIncludeExcludeMap(Map includeExcludeMap, Object value) {
        if (includeExcludeMap.isEmpty()) {
            return true;
        }
        Set includes = (Set)includeExcludeMap.get(INCLUDES);
        if (includes != null) {
            return includes.contains(value);
        }
        Set excludes = (Set)includeExcludeMap.get(EXCLUDES);
        return excludes == null || !excludes.contains(value);
    }

    @Override
    public void doc(String text) {
        if (this.enableDocumentationGeneration()) {
            DocumentationContext.getInstance().document(text);
        }
    }

    @Override
    public String[] getDependencyNames() {
        return this.dependencyNames;
    }

    public Resource[] getWatchedResources() {
        return this.watchedResources;
    }

    @Override
    public String getDependentVersion(String name) {
        Object dependentVersion = this.dependencies.get(name);
        if (dependentVersion == null) {
            throw new PluginException("Plugin [" + this.getName() + "] referenced dependency [" + name + "] with no version!");
        }
        return dependentVersion.toString();
    }

    public String toString() {
        return "[" + this.getName() + ":" + this.getVersion() + "]";
    }

    @Override
    public void doWithWebDescriptor(GPathResult webXml) {
        if (this.pluginBean.isReadableProperty("doWithWebDescriptor")) {
            Closure c = (Closure)this.plugin.getProperty("doWithWebDescriptor");
            c.setResolveStrategy(1);
            c.setDelegate((Object)this);
            c.call((Object)webXml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkForChanges() {
        if (this.pluginUrl != null) {
            long currentModified = -1L;
            URLConnection conn = null;
            try {
                conn = this.pluginUrl.openConnection();
                currentModified = conn.getLastModified();
                if (currentModified > this.pluginLastModified) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Grails plug-in " + this + " changed, reloading changes.."));
                    }
                    GroovyClassLoader gcl = new GroovyClassLoader(this.application.getClassLoader());
                    this.initialisePlugin(gcl.parseClass(DefaultGroovyMethods.getText((InputStream)conn.getInputStream())));
                    this.pluginLastModified = currentModified;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Error reading plugin [" + this.pluginClass + "] last modified date, cannot reload following change: " + e.getMessage()));
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Error closing URL connection to plugin resource [" + this.pluginUrl + "]: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        if (this.onChangeListener != null) {
            this.checkForNewResources(this);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Plugin " + this + " checking [" + this.watchedResources.length + "] resources for changes.."));
            }
            for (int i = 0; i < this.watchedResources.length; ++i) {
                Resource r = this.watchedResources[i];
                long modifiedFlag = this.checkModified(r, this.modifiedTimes[i]);
                if (modifiedFlag <= -1L) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Grails plug-in resource [" + r + "] changed, reloading changes.."));
                }
                this.modifiedTimes[i] = modifiedFlag;
                this.fireModifiedEvent(r, this);
                this.refreshInfluencedPlugins();
            }
        }
        return false;
    }

    private void refreshInfluencedPlugins() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plugin " + this + " starting refresh of influenced plugins " + ArrayUtils.toString((Object)this.influencedPluginNames)));
        }
        if (this.manager != null) {
            for (String name : this.influencedPluginNames) {
                GrailsPlugin grailsPlugin = this.manager.getGrailsPlugin(name);
                if (grailsPlugin == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this + " plugin is refreshing influenced plugin " + grailsPlugin + " following change to resource"));
                }
                grailsPlugin.refresh();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plugin " + this + " cannot refresh influenced plugins, manager is not found"));
        }
    }

    private long checkModified(Resource r, long previousModifiedTime) {
        if (!r.exists()) {
            return -1L;
        }
        try {
            long lastModified;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking modified for resource " + r));
            }
            if (previousModifiedTime < (lastModified = r.lastModified())) {
                return lastModified;
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Unable to read last modified date of plugin resource" + e.getMessage()), (Throwable)e);
        }
        return -1L;
    }

    private void checkForNewResources(GrailsPlugin grailsPlugin) {
        if (this.resourcesReferences == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plugin " + grailsPlugin + " checking [" + ArrayUtils.toString((Object)this.resourcesReferences) + "] resource references new resources that have been added.."));
        }
        for (int i = 0; i < this.resourcesReferences.length; ++i) {
            String resourcesReference = this.resourcesReferences[i];
            try {
                Resource[] tmp = this.resolver.getResources(resourcesReference);
                if (this.resourceCount[i] >= tmp.length) continue;
                Resource newResource = null;
                this.resourceCount[i] = tmp.length;
                for (Resource resource : tmp) {
                    if (ArrayUtils.contains((Object[])this.watchedResources, (Object)resource)) continue;
                    newResource = resource;
                    break;
                }
                if (newResource == null) continue;
                this.watchedResources = (Resource[])ArrayUtils.add((Object[])this.watchedResources, newResource);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Found new Grails plug-in resource [" + newResource + "], adding to application.."));
                }
                if (newResource.getFilename().endsWith(".groovy")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[GrailsPlugin] plugin resource [" + newResource + "] added, registering resource with class loader..."));
                    }
                    ClassLoader classLoader = this.application.getClassLoader();
                    GrailsResourceLoader resourceLoader = GrailsResourceLoaderHolder.getResourceLoader();
                    Object[] classLoaderResources = resourceLoader.getResources();
                    classLoaderResources = (Resource[])ArrayUtils.add((Object[])classLoaderResources, (Object)newResource);
                    resourceLoader.setResources((Resource[])classLoaderResources);
                    if (classLoader instanceof GrailsClassLoader) {
                        ((GrailsClassLoader)((Object)classLoader)).setGrailsResourceLoader(resourceLoader);
                    }
                }
                this.initializeModifiedTimes();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsPlugin] plugin resource [" + newResource + "] added, firing event if possible.."));
                }
                this.fireModifiedEvent(newResource, grailsPlugin);
                continue;
            }
            catch (Exception e) {
                LOG.debug((Object)("Plugin " + this + "  was unable to check for new plugin resources: " + e.getMessage()));
            }
        }
    }

    protected void fireModifiedEvent(Resource resource, GrailsPlugin grailsPlugin) {
        Object source;
        Class loadedClass = null;
        String className = GrailsResourceUtils.getClassName(resource);
        if (className != null) {
            Class oldClass = this.application.getClassForName(className);
            loadedClass = this.attemptClassReload(className);
            source = loadedClass != null ? loadedClass : oldClass;
        } else {
            source = resource;
        }
        if (loadedClass != null && Modifier.isAbstract(loadedClass.getModifiers())) {
            this.restartContainer();
        } else if (source != null) {
            Map event = this.notifyOfEvent(0, source);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Firing onChange event listener with event object [" + event + "]"));
            }
            this.getManager().informObservers(this.getName(), event);
        }
    }

    public void restartContainer() {
        try {
            File classesDir;
            BuildSettings settings = BuildSettingsHolder.getSettings();
            File file = classesDir = settings != null ? settings.getClassesDir() : null;
            if (classesDir == null) {
                Resource r = this.applicationContext.getResource("/WEB-INF/classes");
                classesDir = r.getFile();
            }
            classesDir.setLastModified(System.currentTimeMillis());
        }
        catch (IOException e) {
            LOG.error((Object)("Error retrieving /WEB-INF/classes directory: " + e.getMessage()), (Throwable)e);
        }
    }

    private Class<?> attemptClassReload(String className) {
        ClassLoader loader = this.application.getClassLoader();
        if (loader instanceof GrailsClassLoader) {
            GrailsClassLoader grailsLoader = (GrailsClassLoader)((Object)loader);
            return grailsLoader.reloadClass(className);
        }
        LOG.warn((Object)("Expected GrailsClassLoader - got " + loader.getClass()));
        return null;
    }

    public void setWatchedResources(Resource[] watchedResources) throws IOException {
        this.watchedResources = watchedResources;
        this.initializeModifiedTimes();
    }

    public Log getLog() {
        return LOG;
    }

    public GrailsPlugin getPlugin() {
        return this;
    }

    @Override
    public void setParentApplicationContext(ApplicationContext parent) {
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean fireEvent) {
        for (Resource r : this.watchedResources) {
            try {
                r.getFile().setLastModified(System.currentTimeMillis());
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!fireEvent) continue;
            this.fireModifiedEvent(r, this);
        }
    }

    @Override
    public GroovyObject getInstance() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWithDynamicMethods(ApplicationContext ctx) {
        try {
            if (this.pluginBean.isReadableProperty("doWithDynamicMethods")) {
                Closure c = (Closure)this.plugin.getProperty("doWithDynamicMethods");
                if (this.enableDocumentationGeneration()) {
                    DocumentationContext.getInstance().setActive(true);
                }
                c.setDelegate((Object)this);
                c.call(new Object[]{ctx});
            }
        }
        finally {
            if (this.enableDocumentationGeneration()) {
                DocumentationContext.getInstance().reset();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return "enabled".equals(this.status);
    }

    @Override
    public String[] getObservedPluginNames() {
        return this.observedPlugins;
    }

    @Override
    public void notifyOfEvent(Map event) {
        if (this.onChangeListener != null) {
            this.invokeOnChangeListener(event);
        }
    }

    @Override
    public Map notifyOfEvent(int eventKind, final Object source) {
        HashMap<String, Object> event = new HashMap<String, Object>(){
            {
                this.put(DefaultGrailsPlugin.PLUGIN_CHANGE_EVENT_SOURCE, source);
                this.put(DefaultGrailsPlugin.PLUGIN_CHANGE_EVENT_PLUGIN, DefaultGrailsPlugin.this.plugin);
                this.put(DefaultGrailsPlugin.PLUGIN_CHANGE_EVENT_APPLICATION, DefaultGrailsPlugin.this.application);
                this.put(DefaultGrailsPlugin.PLUGIN_CHANGE_EVENT_MANAGER, DefaultGrailsPlugin.this.getManager());
                this.put(DefaultGrailsPlugin.PLUGIN_CHANGE_EVENT_CTX, DefaultGrailsPlugin.this.applicationContext);
            }
        };
        switch (eventKind) {
            case 0: {
                this.notifyOfEvent(event);
                break;
            }
            case 2: {
                this.invokeOnShutdownEventListener(event);
                break;
            }
            case 1: {
                this.invokeOnConfigChangeListener(event);
                break;
            }
            default: {
                this.notifyOfEvent(event);
            }
        }
        return event;
    }

    private void invokeOnShutdownEventListener(Map event) {
        this.callEvent(this.onShutdownListener, event);
    }

    private void invokeOnConfigChangeListener(Map event) {
        this.callEvent(this.onConfigChangeListener, event);
    }

    private void callEvent(Closure closureHook, Map event) {
        if (closureHook != null) {
            closureHook.setDelegate((Object)this);
            closureHook.call(new Object[]{event});
        }
    }

    private void invokeOnChangeListener(Map event) {
        this.onChangeListener.setDelegate((Object)this);
        this.onChangeListener.call(new Object[]{event});
        if (this.applicationContext instanceof GenericApplicationContext) {
            GenericApplicationContext ctx = (GenericApplicationContext)this.applicationContext;
            ConfigurableListableBeanFactory beanFactory = ctx.getBeanFactory();
            for (BeanFactoryPostProcessor postProcessor : ctx.getBeanFactoryPostProcessors()) {
                postProcessor.postProcessBeanFactory(beanFactory);
            }
        }
    }

    @Override
    public void doArtefactConfiguration() {
        if (!this.pluginBean.isReadableProperty("artefacts")) {
            return;
        }
        List l = (List)this.plugin.getProperty("artefacts");
        for (Object artefact : l) {
            if (artefact instanceof Class) {
                Class artefactClass = (Class)artefact;
                if (ArtefactHandler.class.isAssignableFrom(artefactClass)) {
                    try {
                        this.application.registerArtefactHandler((ArtefactHandler)artefactClass.newInstance());
                    }
                    catch (InstantiationException e) {
                        LOG.error((Object)("Cannot instantiate an Artefact Handler:" + e.getMessage()), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LOG.error((Object)("The constructor of the Artefact Handler is not accessible:" + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                LOG.error((Object)("This class is not an ArtefactHandler:" + artefactClass.getName()));
                continue;
            }
            if (artefact instanceof ArtefactHandler) {
                this.application.registerArtefactHandler((ArtefactHandler)artefact);
                continue;
            }
            LOG.error((Object)("This object is not an ArtefactHandler:" + artefact + "[" + artefact.getClass().getName() + "]"));
        }
    }

    @Override
    public Class<?>[] getProvidedArtefacts() {
        return this.providedArtefacts;
    }

    @Override
    public List<String> getPluginExcludes() {
        return this.pluginExcludes;
    }

    @Override
    public Collection<? extends TypeFilter> getTypeFilters() {
        return this.typeFilters;
    }

    @Override
    public String getFullName() {
        return this.getName() + '-' + this.getVersion();
    }

    @Override
    public Resource getDescriptor() {
        return this.pluginDescriptor;
    }

    @Override
    public Resource getPluginDir() {
        try {
            return this.pluginDescriptor.createRelative(".");
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Map getProperties() {
        return DefaultGroovyMethods.getProperties((Object)this.plugin);
    }
}

