/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.util.GrailsNameUtils;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;

public class GrailsASTUtils {
    public static boolean hasProperty(ClassNode classNode, String propertyName) {
        if (classNode == null || StringUtils.isBlank((String)propertyName)) {
            return false;
        }
        MethodNode method = classNode.getMethod(GrailsNameUtils.getGetterName((String)propertyName), new Parameter[0]);
        if (method != null) {
            return true;
        }
        List properties = classNode.getProperties();
        for (Object property : properties) {
            PropertyNode pn = (PropertyNode)property;
            if (!pn.getName().equals(propertyName) || pn.isPrivate()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOrInheritsProperty(ClassNode classNode, String propertyName) {
        if (GrailsASTUtils.hasProperty(classNode, propertyName)) {
            return true;
        }
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals("java.lang.Object"); parent = parent.getSuperClass()) {
            if (!GrailsASTUtils.hasProperty(parent, propertyName)) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsZeroArgMethod(ClassNode classNode, String methodName) {
        MethodNode method = classNode.getDeclaredMethod(methodName, new Parameter[0]);
        return method != null && (method.isPublic() || method.isProtected()) && !method.isAbstract();
    }

    public static boolean implementsOrInheritsZeroArgMethod(ClassNode classNode, String methodName, List ignoreClasses) {
        if (GrailsASTUtils.implementsZeroArgMethod(classNode, methodName)) {
            return true;
        }
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals("java.lang.Object"); parent = parent.getSuperClass()) {
            if (ignoreClasses.contains(parent) || !GrailsASTUtils.implementsZeroArgMethod(parent, methodName)) continue;
            return true;
        }
        return false;
    }

    public static String getFullName(ClassNode classNode) {
        return classNode.getName();
    }

    public static ClassNode getFurthestParent(ClassNode classNode) {
        for (ClassNode parent = classNode.getSuperClass(); parent != null && !GrailsASTUtils.getFullName(parent).equals("java.lang.Object"); parent = parent.getSuperClass()) {
            classNode = parent;
        }
        return classNode;
    }
}

