/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.persistence.Entity;
import grails.util.ClosureToMapPopulator;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.util.ConfigObject;
import groovy.util.Eval;
import java.util.Map;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsConfigurationAware;

public class DomainClassArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsConfigurationAware {
    public static final String TYPE = "Domain";
    private Map defaultConstraints = null;

    public DomainClassArtefactHandler() {
        super(TYPE, GrailsDomainClass.class, DefaultGrailsDomainClass.class, null);
    }

    public GrailsClass newArtefactClass(Class artefactClass) {
        if (this.defaultConstraints != null) {
            return new DefaultGrailsDomainClass(artefactClass, this.defaultConstraints);
        }
        return new DefaultGrailsDomainClass(artefactClass);
    }

    public Map getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public void initialize(ArtefactInfo artefacts) {
        this.log.debug((Object)"Configuring domain class relationships");
        GrailsDomainConfigurationUtil.configureDomainClassRelationships(artefacts.getGrailsClasses(), artefacts.getGrailsClassesByName());
    }

    public boolean isArtefactClass(Class clazz) {
        return DomainClassArtefactHandler.isDomainClass(clazz);
    }

    public static boolean isDomainClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (Closure.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (GrailsClassUtils.isJdk5Enum(clazz)) {
            return false;
        }
        if (clazz.getAnnotation(Entity.class) != null) {
            return true;
        }
        boolean result = false;
        for (Class testClass = clazz; testClass != null && !testClass.equals(GroovyObject.class) && !testClass.equals(Object.class); testClass = testClass.getSuperclass()) {
            try {
                testClass.getDeclaredField("id");
                testClass.getDeclaredField("version");
                result = true;
                break;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return result;
    }

    public void setConfiguration(ConfigObject co) {
        Object constraints = Eval.x((Object)co, (String)"x?.grails?.gorm?.default?.constraints");
        if (constraints instanceof Closure) {
            if (this.defaultConstraints != null) {
                this.defaultConstraints.clear();
                new ClosureToMapPopulator(this.defaultConstraints).populate((Closure)constraints);
            } else {
                ClosureToMapPopulator populator = new ClosureToMapPopulator();
                this.defaultConstraints = populator.populate((Closure)constraints);
            }
        }
    }
}

