/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.Metadata;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class DevelopmentResourceLoader
extends DefaultResourceLoader {
    private String baseLocation = ".";
    private static final String PLUGINS_PREFIX = "plugins/";
    private static final String SLASH = "/";

    public DevelopmentResourceLoader(GrailsApplication application) {
    }

    public DevelopmentResourceLoader() {
    }

    public DevelopmentResourceLoader(GrailsApplication application, String baseLocation) {
        this(application);
        this.baseLocation = baseLocation;
    }

    public Resource getResource(String location) {
        if (Metadata.getCurrent().isWarDeployed()) {
            return super.getResource(location);
        }
        location = this.getRealLocationInProject(location);
        return super.getResource(location);
    }

    protected String getRealLocationInProject(String location) {
        if (!location.startsWith(SLASH)) {
            location = SLASH + location;
        }
        if (location.startsWith("/WEB-INF")) {
            String noWebInf = location.substring("/WEB-INF".length() + 1);
            String defaultPath = "file:" + this.baseLocation + SLASH + noWebInf;
            if (noWebInf.startsWith(PLUGINS_PREFIX)) {
                BuildSettings settings = BuildSettingsHolder.getSettings();
                String pluginPath = StringUtils.substringAfter((String)noWebInf, (String)SLASH);
                String pluginName = StringUtils.substringBefore((String)pluginPath, (String)SLASH);
                String remainingPath = StringUtils.substringAfter((String)pluginPath, (String)SLASH);
                Resource r = GrailsPluginUtils.getPluginDirForName(pluginName);
                if (r != null) {
                    try {
                        return "file:" + r.getFile().getAbsolutePath() + SLASH + remainingPath;
                    }
                    catch (IOException e) {
                        return defaultPath;
                    }
                }
                if (settings != null) {
                    return "file:" + settings.getProjectPluginsDir().getAbsolutePath() + SLASH + pluginName + SLASH + remainingPath;
                }
                return defaultPath;
            }
            return defaultPath;
        }
        return "web-app" + location;
    }
}

