/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPropertyFetcher {
    private final Class clazz;
    final Map<String, PropertyFetcher> staticFetchers = new HashMap<String, PropertyFetcher>();
    final Map<String, PropertyFetcher> instanceFetchers = new HashMap<String, PropertyFetcher>();
    private final ReferenceInstanceCallback callback;
    private PropertyDescriptor[] propertyDescriptors;
    private static Map<Class, ClassPropertyFetcher> cachedClassPropertyFetchers = new ConcurrentHashMap<Class, ClassPropertyFetcher>();

    public static void clearClassPropertyFetcherCache() {
        cachedClassPropertyFetchers.clear();
    }

    public static ClassPropertyFetcher forClass(Class c) {
        return ClassPropertyFetcher.forClass(c, null);
    }

    public static ClassPropertyFetcher forClass(final Class c, ReferenceInstanceCallback callback) {
        ClassPropertyFetcher cpf = cachedClassPropertyFetchers.get(c);
        if (cpf == null) {
            if (callback == null) {
                callback = new ReferenceInstanceCallback(){
                    private Object o;

                    public Object getReferenceInstance() {
                        if (this.o == null) {
                            this.o = BeanUtils.instantiate((Class)c);
                        }
                        return this.o;
                    }
                };
            }
            cpf = new ClassPropertyFetcher(c, callback);
            cachedClassPropertyFetchers.put(c, cpf);
        }
        return cpf;
    }

    ClassPropertyFetcher(Class clazz, ReferenceInstanceCallback callback) {
        this.clazz = clazz;
        this.callback = callback;
        this.init();
    }

    public Object getReference() {
        if (this.callback != null) {
            return this.callback.getReferenceInstance();
        }
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public boolean isReadableProperty(String name) {
        return this.staticFetchers.containsKey(name) || this.instanceFetchers.containsKey(name);
    }

    private void init() {
        ReflectionUtils.FieldCallback fieldCallback = new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.isSynthetic()) {
                    return;
                }
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    return;
                }
                String name = field.getName();
                if (name.indexOf(36) == -1) {
                    boolean staticField = Modifier.isStatic(modifiers);
                    if (staticField) {
                        ClassPropertyFetcher.this.staticFetchers.put(name, new FieldReaderFetcher(field, staticField));
                    } else {
                        ClassPropertyFetcher.this.instanceFetchers.put(name, new FieldReaderFetcher(field, staticField));
                    }
                }
            }
        };
        ReflectionUtils.MethodCallback methodCallback = new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String name;
                if (method.isSynthetic()) {
                    return;
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    return;
                }
                if (Modifier.isStatic(method.getModifiers()) && method.getReturnType() != Void.class && method.getParameterTypes().length == 0 && (name = method.getName()).indexOf(36) == -1) {
                    if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
                        name = name.substring(3);
                    } else if (name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2)) && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                        name = name.substring(2);
                    }
                    GetterPropertyFetcher fetcher = new GetterPropertyFetcher(method, true);
                    ClassPropertyFetcher.this.staticFetchers.put(name, fetcher);
                    ClassPropertyFetcher.this.staticFetchers.put(StringUtils.uncapitalize((String)name), fetcher);
                }
            }
        };
        List<Class> allClasses = this.resolveAllClasses(this.clazz);
        for (Class c : allClasses) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                try {
                    fieldCallback.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                }
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                try {
                    methodCallback.doWith(method);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
                }
            }
        }
        for (PropertyDescriptor desc : this.propertyDescriptors = BeanUtils.getPropertyDescriptors((Class)this.clazz)) {
            Method readMethod = desc.getReadMethod();
            if (readMethod == null) continue;
            boolean staticReadMethod = Modifier.isStatic(readMethod.getModifiers());
            if (staticReadMethod) {
                this.staticFetchers.put(desc.getName(), new GetterPropertyFetcher(readMethod, staticReadMethod));
                continue;
            }
            this.instanceFetchers.put(desc.getName(), new GetterPropertyFetcher(readMethod, staticReadMethod));
        }
    }

    private List<Class> resolveAllClasses(Class c) {
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class currentClass = c; currentClass != null; currentClass = currentClass.getSuperclass()) {
            list.add(currentClass);
        }
        Collections.reverse(list);
        return list;
    }

    public Object getPropertyValue(String name) {
        return this.getPropertyValue(name, false);
    }

    public Object getPropertyValue(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        return this.getPropertyValueWithFetcher(name, fetcher);
    }

    private Object getPropertyValueWithFetcher(String name, PropertyFetcher fetcher) {
        if (fetcher != null) {
            try {
                return fetcher.get(this.callback);
            }
            catch (Exception e) {
                AbstractGrailsClass.LOG.warn((Object)("Error fetching property's " + name + " value from class " + this.clazz.getName()), (Throwable)e);
            }
        }
        return null;
    }

    public <T> T getStaticPropertyValue(String name, Class<T> c) {
        PropertyFetcher fetcher = this.staticFetchers.get(name);
        if (fetcher != null) {
            Object v = this.getPropertyValueWithFetcher(name, fetcher);
            return this.returnOnlyIfInstanceOf(v, c);
        }
        return null;
    }

    public <T> T getPropertyValue(String name, Class<T> c) {
        return this.returnOnlyIfInstanceOf(this.getPropertyValue(name, false), c);
    }

    private <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || GrailsClassUtils.isGroovyAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    private PropertyFetcher resolveFetcher(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = null;
        if (!onlyInstanceProperties) {
            fetcher = this.staticFetchers.get(name);
        }
        if (fetcher == null) {
            fetcher = this.instanceFetchers.get(name);
        }
        return fetcher;
    }

    public Class getPropertyType(String name) {
        return this.getPropertyType(name, false);
    }

    public Class getPropertyType(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        if (fetcher != null) {
            return fetcher.getPropertyType(name);
        }
        return null;
    }

    static class FieldReaderFetcher
    implements PropertyFetcher {
        private final Field field;
        private final boolean staticField;

        public FieldReaderFetcher(Field field, boolean staticField) {
            this.field = field;
            this.staticField = staticField;
            ReflectionUtils.makeAccessible((Field)field);
        }

        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticField) {
                return this.field.get(null);
            }
            if (callback != null) {
                return this.field.get(callback.getReferenceInstance());
            }
            return null;
        }

        public Class getPropertyType(String name) {
            return this.field.getType();
        }
    }

    static class GetterPropertyFetcher
    implements PropertyFetcher {
        private final Method readMethod;
        private final boolean staticMethod;

        GetterPropertyFetcher(Method readMethod, boolean staticMethod) {
            this.readMethod = readMethod;
            this.staticMethod = staticMethod;
            ReflectionUtils.makeAccessible((Method)readMethod);
        }

        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticMethod) {
                return this.readMethod.invoke(null, (Object[])null);
            }
            if (callback != null) {
                return this.readMethod.invoke(callback.getReferenceInstance(), (Object[])null);
            }
            return null;
        }

        public Class getPropertyType(String name) {
            return this.readMethod.getReturnType();
        }
    }

    static interface PropertyFetcher {
        public Object get(ReferenceInstanceCallback var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public Class getPropertyType(String var1);
    }

    public static interface ReferenceInstanceCallback {
        public Object getReferenceInstance();
    }
}

