/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import grails.util.GrailsUtil;
import groovy.lang.MissingMethodException;
import groovy.util.BuilderSupport;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedPropertyBuilder
extends BuilderSupport {
    private Object target;
    private BeanWrapper bean;
    private Map<String, ConstrainedProperty> constrainedProperties = new HashMap<String, ConstrainedProperty>();
    private Map<String, String> sharedConstraints = new HashMap<String, String>();
    private int order = 1;
    private static final String SHARED_CONSTRAINT = "shared";

    public ConstrainedPropertyBuilder(Object target) {
        this.target = target;
        this.bean = new BeanWrapperImpl(target);
    }

    public String getSharedConstraint(String propertyName) {
        return this.sharedConstraints.get(propertyName);
    }

    protected Object createNode(Object name, Map attributes) {
        try {
            ConstrainedProperty cp;
            String property = (String)name;
            if (this.constrainedProperties.containsKey(property)) {
                cp = this.constrainedProperties.get(property);
            } else {
                PropertyDescriptor pd = this.bean.getPropertyDescriptor(property);
                cp = new ConstrainedProperty(this.target.getClass(), property, pd.getPropertyType());
                cp.setOrder(this.order++);
                this.constrainedProperties.put(property, cp);
            }
            for (Object o : attributes.keySet()) {
                String constraintName = (String)o;
                Object value = attributes.get(constraintName);
                if (SHARED_CONSTRAINT.equals(constraintName)) {
                    if (value == null) continue;
                    this.sharedConstraints.put(property, value.toString());
                    continue;
                }
                if (cp.supportsContraint(constraintName)) {
                    cp.applyConstraint(constraintName, value);
                    continue;
                }
                if (ConstrainedProperty.hasRegisteredConstraint(constraintName)) {
                    GrailsUtil.warn("Property [" + cp.getPropertyName() + "] of domain class " + this.target.getClass().getName() + " has type [" + cp.getPropertyType().getName() + "] and doesn't support constraint [" + constraintName + "]. This constraint will not be checked during validation.");
                    continue;
                }
                cp.addMetaConstraint(constraintName, value);
            }
            return cp;
        }
        catch (InvalidPropertyException ipe) {
            throw new MissingMethodException((String)name, this.target.getClass(), new Object[]{attributes});
        }
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        throw new MissingMethodException((String)name, this.target.getClass(), new Object[]{attributes, value});
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object createNode(Object name) {
        return this.createNode(name, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.EMPTY_MAP, value);
    }

    public Map<String, ConstrainedProperty> getConstrainedProperties() {
        return this.constrainedProperties;
    }
}

