/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.support;

import org.codehaus.groovy.grails.orm.support.TransactionManagerAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionManagerPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;
    private PlatformTransactionManager transactionManager;
    private boolean initialized = false;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("TransactionManagerPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public synchronized boolean postProcessAfterInstantiation(Object bean, String name) throws BeansException {
        if (!this.initialized) {
            String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, PlatformTransactionManager.class, (boolean)false, (boolean)false);
            if (beanNames.length > 0) {
                this.transactionManager = (PlatformTransactionManager)this.beanFactory.getBean(beanNames[0]);
            }
            this.initialized = true;
        }
        if (bean instanceof TransactionManagerAware) {
            TransactionManagerAware tma = (TransactionManagerAware)bean;
            tma.setTransactionManager(this.transactionManager);
        }
        return true;
    }
}

