/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.exceptions.NewInstanceCreationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public abstract class AbstractGrailsClass
implements GrailsClass {
    static final Log LOG = LogFactory.getLog(AbstractGrailsClass.class);
    private final Class clazz;
    private final BeanWrapper reference;
    private final String fullName;
    private final String name;
    private final String packageName;
    private final String naturalName;
    private final String shortName;
    private final String propertyName;
    private final String logicalPropertyName;
    private final ClassPropertyFetcher classPropertyFetcher;

    public AbstractGrailsClass(Class clazz, String trailingName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz parameter should not be null");
        }
        this.clazz = clazz;
        this.reference = new BeanWrapperImpl(this.newInstance());
        this.fullName = clazz.getName();
        this.packageName = ClassUtils.getPackageName((Class)clazz);
        this.naturalName = GrailsNameUtils.getNaturalName((String)clazz.getName());
        this.shortName = ClassUtils.getShortClassName((Class)clazz);
        this.name = GrailsNameUtils.getLogicalName((Class)clazz, (String)trailingName);
        this.propertyName = GrailsNameUtils.getPropertyNameRepresentation((String)this.shortName);
        this.logicalPropertyName = StringUtils.isBlank((String)this.name) ? this.propertyName : GrailsNameUtils.getPropertyNameRepresentation((String)this.name);
        this.classPropertyFetcher = new ClassPropertyFetcher(clazz, new ClassPropertyFetcher.ReferenceInstanceCallback(){

            public Object getReferenceInstance() {
                return AbstractGrailsClass.this.getReferenceInstance();
            }
        });
    }

    public String getShortName() {
        return this.shortName;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Object newInstance() {
        try {
            Constructor defaultConstructor = this.getClazz().getDeclaredConstructor(new Class[0]);
            if (!defaultConstructor.isAccessible()) {
                defaultConstructor.setAccessible(true);
            }
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable targetException = null;
            targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new NewInstanceCreationException("Could not create a new instance of class [" + this.getClazz().getName() + "]!", targetException);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNaturalName() {
        return this.naturalName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getLogicalPropertyName() {
        return this.logicalPropertyName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Object getReferenceInstance() {
        Object obj = this.getReference().getWrappedInstance();
        if (obj instanceof GroovyObject) {
            ((GroovyObject)obj).setMetaClass(this.getMetaClass());
        }
        return obj;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return BeanUtils.getPropertyDescriptors((Class)this.clazz);
    }

    public Class getPropertyType(String name) {
        return this.classPropertyFetcher.getPropertyType(name);
    }

    public boolean isReadableProperty(String name) {
        return this.classPropertyFetcher.isReadableProperty(name);
    }

    public boolean hasMetaMethod(String name) {
        return this.hasMetaMethod(name, null);
    }

    public boolean hasMetaMethod(String name, Object[] args) {
        return this.getMetaClass().getMetaMethod(name, args) != null;
    }

    public boolean hasMetaProperty(String name) {
        return this.getMetaClass().getMetaProperty(name) != null;
    }

    public BeanWrapper getReference() {
        return this.reference;
    }

    protected Object getPropertyOrStaticPropertyOrFieldValue(String name, Class type) {
        Object value = this.classPropertyFetcher.getPropertyValue(name);
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public Object getPropertyValue(String name, Class type) {
        MetaProperty metaProperty;
        Object inst;
        Object value = this.classPropertyFetcher.getPropertyValue(name);
        if (value == null && (inst = this.getReferenceInstance()) instanceof GroovyObject && (metaProperty = this.getMetaClass().getMetaProperty(name)) != null) {
            value = metaProperty.getProperty(inst);
        }
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public Object getPropertyValueObject(String name) {
        return this.getPropertyValue(name, Object.class);
    }

    private Object returnOnlyIfInstanceOf(Object value, Class type) {
        if (value != null && (type == Object.class || GrailsClassUtils.isGroovyAssignableFrom(type, value.getClass()))) {
            return value;
        }
        return null;
    }

    public Object getPropertyValue(String name) {
        return this.getPropertyOrStaticPropertyOrFieldValue(name, Object.class);
    }

    public boolean hasProperty(String name) {
        return this.getReference().isReadableProperty(name);
    }

    public MetaClass getMetaClass() {
        return GroovySystem.getMetaClassRegistry().getMetaClass(this.clazz);
    }

    public String toString() {
        return "Artefact > " + this.getName();
    }
}

