/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.support;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class GroovyAwareNamedTransactionAttributeSource
extends NameMatchTransactionAttributeSource {
    private static final Set NONTRANSACTIONAL_GROOVY_METHODS = new HashSet(){
        {
            this.add("invokeMethod");
            this.add("getMetaClass");
            this.add("getProperty");
            this.add("setProperty");
        }
    };

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        if (method.isSynthetic()) {
            return null;
        }
        return super.getTransactionAttribute(method, targetClass);
    }

    protected boolean isMatch(String methodName, String mappedName) {
        if (NONTRANSACTIONAL_GROOVY_METHODS.contains(methodName)) {
            return false;
        }
        return super.isMatch(methodName, mappedName);
    }

    public void setTransactionalAttributes(Properties properties) {
        super.setProperties(properties);
    }
}

