/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import groovy.lang.Closure;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.GrailsClass;

public class ArtefactHandlerAdapter
implements ArtefactHandler {
    private String type;
    private Class grailsClassType;
    private Class grailsClassImpl;
    private boolean allowAbstract;
    protected Log log = LogFactory.getLog(ArtefactHandlerAdapter.class);
    private String artefactSuffix;

    public ArtefactHandlerAdapter(String type, Class grailsClassType, Class grailsClassImpl, String artefactSuffix) {
        this.artefactSuffix = artefactSuffix;
        this.type = type;
        this.grailsClassType = grailsClassType;
        this.grailsClassImpl = grailsClassImpl;
    }

    public ArtefactHandlerAdapter(String type, Class grailsClassType, Class grailsClassImpl, String artefactSuffix, boolean allowAbstract) {
        this.artefactSuffix = artefactSuffix;
        this.type = type;
        this.grailsClassType = grailsClassType;
        this.grailsClassImpl = grailsClassImpl;
        this.allowAbstract = allowAbstract;
    }

    public String getPluginName() {
        return this.type.toLowerCase();
    }

    public String getType() {
        return this.type;
    }

    public final boolean isArtefact(Class aClass) {
        if (this.isArtefactClass(aClass)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[" + aClass.getName() + "] is a " + this.type + " class."));
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[" + aClass.getName() + "] is not a " + this.type + " class."));
        }
        return false;
    }

    public boolean isArtefactClass(Class clazz) {
        boolean ok;
        if (clazz == null) {
            return false;
        }
        boolean bl = ok = clazz.getName().endsWith(this.artefactSuffix) && !Closure.class.isAssignableFrom(clazz);
        if (ok && !this.allowAbstract) {
            ok &= !Modifier.isAbstract(clazz.getModifiers());
        }
        return ok;
    }

    public GrailsClass newArtefactClass(Class artefactClass) {
        try {
            Constructor c = this.grailsClassImpl.getDeclaredConstructor(Class.class);
            return (GrailsClass)c.newInstance(artefactClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to locate constructor with Class parameter for " + this.grailsClassImpl, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to locate constructor with Class parameter for " + this.grailsClassImpl, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to locate constructor with Class parameter for " + this.grailsClassImpl, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to locate constructor with Class parameter for " + this.grailsClassImpl, e);
        }
    }

    public void initialize(ArtefactInfo artefacts) {
    }

    public GrailsClass getArtefactForFeature(Object feature) {
        return null;
    }

    public boolean isArtefactGrailsClass(GrailsClass artefactGrailsClass) {
        return this.grailsClassType.isAssignableFrom(artefactGrailsClass.getClass());
    }
}

