/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.test;

import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class GrailsConsoleResultFormatter
implements JUnitResultFormatter {
    private PrintStream out;
    private int failureCount;

    public void startTestSuite(JUnitTest test) {
        this.out.print("Running test " + test.getName() + "...");
        this.failureCount = 0;
    }

    public void endTestSuite(JUnitTest test) {
        if (this.failureCount == 0) {
            this.out.println("PASSED");
        }
    }

    public void setOutput(OutputStream outputStream) {
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
    }

    public void setSystemOutput(String out) {
    }

    public void setSystemError(String err) {
    }

    public void addError(Test test, Throwable throwable) {
        ++this.failureCount;
        if (test instanceof TestCase) {
            this.printFailedTest((TestCase)test);
        }
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        ++this.failureCount;
        if (test instanceof TestCase) {
            this.printFailedTest((TestCase)test);
        }
    }

    public void endTest(Test test) {
    }

    public void startTest(Test test) {
    }

    private void printFailedTest(TestCase test) {
        if (this.failureCount == 1) {
            this.out.println();
        }
        this.out.println("                    " + test.getName() + "...FAILED");
    }
}

