/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import groovy.lang.GroovyObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.validation.CascadingValidator;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;

public class GrailsDomainClassValidator
implements Validator,
CascadingValidator,
GrailsApplicationAware {
    private static final List EMBEDDED_EXCLUDES = new ArrayList(){
        {
            this.add("id");
            this.add("version");
        }
    };
    private Class targetClass;
    private GrailsDomainClass domainClass;
    private MessageSource messageSource;
    private GrailsApplication grailsApplication;
    private static final String ERRORS_PROPERTY = "errors";

    public boolean supports(Class clazz) {
        return this.targetClass.equals(clazz);
    }

    public void setDomainClass(GrailsDomainClass domainClass) {
        this.domainClass = domainClass;
        this.domainClass.setValidator(this);
        this.targetClass = this.domainClass.getClazz();
    }

    public GrailsDomainClass getDomainClass() {
        return this.domainClass;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void validate(Object obj, Errors errors, boolean cascade) {
        if (!this.domainClass.getClazz().isInstance(obj)) {
            throw new IllegalArgumentException("Argument [" + obj + "] is not an instance of [" + this.domainClass.getClazz() + "] which this validator is configured for");
        }
        BeanWrapperImpl bean = new BeanWrapperImpl(obj);
        Map constrainedProperties = this.domainClass.getConstrainedProperties();
        HashSet constrainedPropertyNames = new HashSet(constrainedProperties.keySet());
        GrailsDomainClassProperty[] persistentProperties = this.domainClass.getPersistentProperties();
        for (int i = 0; i < persistentProperties.length; ++i) {
            GrailsDomainClassProperty persistentProperty = persistentProperties[i];
            String propertyName = persistentProperty.getName();
            if (constrainedProperties.containsKey(propertyName)) {
                this.validatePropertyWithConstraint(propertyName, obj, errors, (BeanWrapper)bean, constrainedProperties);
            }
            if ((persistentProperty.isAssociation() || persistentProperty.isEmbedded()) && cascade) {
                this.cascadeToAssociativeProperty(errors, (BeanWrapper)bean, persistentProperty);
            }
            constrainedPropertyNames.remove(propertyName);
        }
        for (String name : constrainedPropertyNames) {
            this.validatePropertyWithConstraint(name, obj, errors, (BeanWrapper)bean, constrainedProperties);
        }
        if (obj instanceof GroovyObject) {
            ((GroovyObject)obj).setProperty(ERRORS_PROPERTY, (Object)errors);
        } else {
            InvokerHelper.setProperty((Object)obj, (String)ERRORS_PROPERTY, (Object)errors);
        }
        this.postValidate(obj, errors);
    }

    protected void postValidate(Object obj, Errors errors) {
    }

    public void validate(Object obj, Errors errors) {
        this.validate(obj, errors, false);
    }

    protected void cascadeToAssociativeProperty(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty) {
        String propertyName = persistentProperty.getName();
        if (errors.hasFieldErrors(propertyName)) {
            return;
        }
        if (persistentProperty.isManyToOne() || persistentProperty.isOneToOne() || persistentProperty.isEmbedded()) {
            Object associatedObject = bean.getPropertyValue(propertyName);
            this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName);
        } else if (persistentProperty.isOneToMany()) {
            this.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
        }
    }

    protected void cascadeValidationToMany(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty, String propertyName) {
        block3: {
            Object collection;
            block2: {
                collection = bean.getPropertyValue(propertyName);
                if (!(collection instanceof Collection)) break block2;
                for (Object associatedObject : (Collection)collection) {
                    this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName);
                }
                break block3;
            }
            if (!(collection instanceof Map)) break block3;
            Map map = (Map)collection;
            for (Object associatedObject : map.values()) {
                this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName);
            }
        }
    }

    private void validatePropertyWithConstraint(String propertyName, Object obj, Errors errors, BeanWrapper bean, Map constrainedProperties) {
        int i = propertyName.lastIndexOf(".");
        String constrainedPropertyName = i > -1 ? propertyName.substring(i + 1, propertyName.length()) : propertyName;
        FieldError fieldError = errors.getFieldError(constrainedPropertyName);
        if (fieldError == null) {
            ConstrainedProperty c = (ConstrainedProperty)constrainedProperties.get(constrainedPropertyName);
            c.setMessageSource(this.messageSource);
            c.validate(obj, bean.getPropertyValue(constrainedPropertyName), errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeValidationToOne(Errors errors, BeanWrapper bean, Object associatedObject, GrailsDomainClassProperty persistentProperty, String propertyName) {
        GrailsDomainClass associatedDomainClass;
        if (associatedObject != null && (associatedDomainClass = this.getAssociatedDomainClass(associatedObject, persistentProperty)) != null && this.isOwningInstance(bean, associatedDomainClass)) {
            GrailsDomainClassProperty otherSide = null;
            if (persistentProperty.isBidirectional()) {
                otherSide = persistentProperty.getOtherSide();
            }
            Map associatedConstraintedProperties = associatedDomainClass.getConstrainedProperties();
            GrailsDomainClassProperty[] associatedPersistentProperties = associatedDomainClass.getPersistentProperties();
            String nestedPath = errors.getNestedPath();
            try {
                errors.setNestedPath(nestedPath + propertyName);
                for (int i = 0; i < associatedPersistentProperties.length; ++i) {
                    GrailsDomainClassProperty associatedPersistentProperty = associatedPersistentProperties[i];
                    if (associatedPersistentProperty.equals(otherSide) || persistentProperty.isEmbedded() && EMBEDDED_EXCLUDES.contains(associatedPersistentProperty.getName())) continue;
                    String associatedPropertyName = associatedPersistentProperty.getName();
                    if (associatedConstraintedProperties.containsKey(associatedPropertyName)) {
                        this.validatePropertyWithConstraint(errors.getNestedPath() + associatedPropertyName, associatedObject, errors, (BeanWrapper)new BeanWrapperImpl(associatedObject), associatedConstraintedProperties);
                    }
                    if (!associatedPersistentProperty.isAssociation()) continue;
                    this.cascadeToAssociativeProperty(errors, (BeanWrapper)new BeanWrapperImpl(associatedObject), associatedPersistentProperty);
                }
            }
            finally {
                errors.setNestedPath(nestedPath);
            }
        }
    }

    private GrailsDomainClass getAssociatedDomainClass(Object associatedObject, GrailsDomainClassProperty persistentProperty) {
        if (persistentProperty.isEmbedded()) {
            return persistentProperty.getComponent();
        }
        if (this.grailsApplication != null) {
            String associatedObjectType = associatedObject.getClass().getName();
            if (associatedObject instanceof HibernateProxy) {
                associatedObjectType = ((HibernateProxy)associatedObject).getHibernateLazyInitializer().getEntityName();
            }
            return (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", associatedObjectType);
        }
        return persistentProperty.getReferencedDomainClass();
    }

    private boolean isOwningInstance(BeanWrapper bean, GrailsDomainClass associatedDomainClass) {
        for (Class currentClass = bean.getWrappedClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            if (!associatedDomainClass.isOwningClass(currentClass)) continue;
            return true;
        }
        return false;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

