/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.metaclass;

import groovy.lang.MissingPropertyException;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicProperty;
import org.codehaus.groovy.grails.commons.metaclass.FunctionCallback;

public class WeakGenericDynamicProperty
extends AbstractDynamicProperty {
    private Class type;
    private boolean readyOnly;
    private Map<String, SoftReference<Object>> propertyToInstanceMap = new ConcurrentHashMap<String, SoftReference<Object>>();
    private Object initialValue;
    private FunctionCallback initialValueGenerator;

    public WeakGenericDynamicProperty(String propertyName, Class type, Object initialValue, boolean readOnly) {
        super(propertyName);
        if (type == null) {
            throw new IllegalArgumentException("Constructor argument 'type' cannot be null");
        }
        this.readyOnly = readOnly;
        this.type = type;
        this.initialValue = initialValue;
    }

    public WeakGenericDynamicProperty(String propertyName, Class type, boolean readOnly) {
        super(propertyName);
        if (type == null) {
            throw new IllegalArgumentException("Constructor argument 'type' cannot be null");
        }
        this.readyOnly = readOnly;
        this.type = type;
    }

    public WeakGenericDynamicProperty(String propertyName, Class type, FunctionCallback initialValueGenerator, boolean readOnly) {
        this(propertyName, type, readOnly);
        this.initialValueGenerator = initialValueGenerator;
    }

    public Object get(Object object) {
        Object val;
        String propertyKey = System.identityHashCode(object) + this.getPropertyName();
        SoftReference<Object> ref = this.propertyToInstanceMap.get(propertyKey);
        Object object2 = val = ref != null ? ref.get() : null;
        if (val != null) {
            return val;
        }
        if (this.initialValueGenerator != null) {
            Object value = this.initialValueGenerator.execute(object);
            this.propertyToInstanceMap.put(propertyKey, new SoftReference<Object>(value));
            return value;
        }
        if (this.initialValue != null) {
            this.propertyToInstanceMap.put(propertyKey, new SoftReference<Object>(this.initialValue));
            return this.initialValue;
        }
        return null;
    }

    public void set(Object object, Object newValue) {
        if (!this.readyOnly) {
            if (this.type.isInstance(newValue)) {
                this.propertyToInstanceMap.put(String.valueOf(System.identityHashCode(object)) + this.getPropertyName(), new SoftReference<Object>(newValue));
            } else if (newValue != null) {
                throw new MissingPropertyException("Property '" + this.getPropertyName() + "' for object '" + object.getClass() + "' cannot be set with value '" + newValue + "'. Incorrect type.", object.getClass());
            }
        } else {
            throw new MissingPropertyException("Property '" + this.getPropertyName() + "' for object '" + object.getClass() + "' is read-only!", object.getClass());
        }
    }
}

