/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPropertyFetcher {
    private final Class clazz;
    final Map<String, PropertyFetcher> staticFetchers = new HashMap<String, PropertyFetcher>();
    final Map<String, PropertyFetcher> instanceFetchers = new HashMap<String, PropertyFetcher>();
    private final ReferenceInstanceCallback callback;

    ClassPropertyFetcher(Class clazz, ReferenceInstanceCallback callback) {
        this.clazz = clazz;
        this.callback = callback;
        this.init();
    }

    public boolean isReadableProperty(String name) {
        return this.staticFetchers.containsKey(name) || this.instanceFetchers.containsKey(name);
    }

    private void init() {
        PropertyDescriptor[] descriptors;
        ReflectionUtils.FieldCallback fieldCallback = new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.getName().indexOf(36) == -1) {
                    boolean staticField = Modifier.isStatic(field.getModifiers());
                    if (staticField) {
                        ClassPropertyFetcher.this.staticFetchers.put(field.getName(), new FieldReaderFetcher(field, staticField));
                    } else {
                        ClassPropertyFetcher.this.instanceFetchers.put(field.getName(), new FieldReaderFetcher(field, staticField));
                    }
                }
            }
        };
        ReflectionUtils.MethodCallback methodCallback = new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                String name;
                if (Modifier.isStatic(method.getModifiers()) && method.getReturnType() != Void.class && method.getParameterTypes().length == 0 && (name = method.getName()).indexOf(36) == -1) {
                    if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
                        name = name.substring(3);
                    } else if (name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2)) && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                        name = name.substring(2);
                    }
                    GetterPropertyFetcher fetcher = new GetterPropertyFetcher(method, true);
                    ClassPropertyFetcher.this.staticFetchers.put(name, fetcher);
                    ClassPropertyFetcher.this.staticFetchers.put(StringUtils.uncapitalize((String)name), fetcher);
                }
            }
        };
        List<Class> allClasses = this.resolveAllClasses(this.clazz);
        for (Class c : allClasses) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                try {
                    fieldCallback.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                }
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                try {
                    methodCallback.doWith(method);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
                }
            }
        }
        for (PropertyDescriptor desc : descriptors = BeanUtils.getPropertyDescriptors((Class)this.clazz)) {
            Method readMethod = desc.getReadMethod();
            if (readMethod == null) continue;
            boolean staticReadMethod = Modifier.isStatic(readMethod.getModifiers());
            if (staticReadMethod) {
                this.staticFetchers.put(desc.getName(), new GetterPropertyFetcher(readMethod, staticReadMethod));
                continue;
            }
            this.instanceFetchers.put(desc.getName(), new GetterPropertyFetcher(readMethod, staticReadMethod));
        }
    }

    private List<Class> resolveAllClasses(Class c) {
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class currentClass = c; currentClass != null; currentClass = currentClass.getSuperclass()) {
            list.add(currentClass);
        }
        Collections.reverse(list);
        return list;
    }

    public Object getPropertyValue(String name) {
        return this.getPropertyValue(name, false);
    }

    public Object getPropertyValue(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        if (fetcher != null) {
            try {
                return fetcher.get(this.callback);
            }
            catch (Exception e) {
                AbstractGrailsClass.LOG.warn((Object)("Error fetching property's " + name + " value from class " + this.clazz.getName()), (Throwable)e);
            }
        }
        return null;
    }

    private PropertyFetcher resolveFetcher(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = null;
        if (!onlyInstanceProperties) {
            fetcher = this.staticFetchers.get(name);
        }
        if (fetcher == null) {
            fetcher = this.instanceFetchers.get(name);
        }
        return fetcher;
    }

    public Class getPropertyType(String name) {
        return this.getPropertyType(name, false);
    }

    public Class getPropertyType(String name, boolean onlyInstanceProperties) {
        PropertyFetcher fetcher = this.resolveFetcher(name, onlyInstanceProperties);
        if (fetcher != null) {
            return fetcher.getPropertyType(name);
        }
        return null;
    }

    static class FieldReaderFetcher
    implements PropertyFetcher {
        private final Field field;
        private final boolean staticField;

        public FieldReaderFetcher(Field field, boolean staticField) {
            this.field = field;
            this.staticField = staticField;
            ReflectionUtils.makeAccessible((Field)field);
        }

        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticField) {
                return this.field.get(null);
            }
            return this.field.get(callback.getReferenceInstance());
        }

        public Class getPropertyType(String name) {
            return this.field.getType();
        }
    }

    static class GetterPropertyFetcher
    implements PropertyFetcher {
        private final Method readMethod;
        private final boolean staticMethod;

        GetterPropertyFetcher(Method readMethod, boolean staticMethod) {
            this.readMethod = readMethod;
            this.staticMethod = staticMethod;
            ReflectionUtils.makeAccessible((Method)readMethod);
        }

        public Object get(ReferenceInstanceCallback callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.staticMethod) {
                return this.readMethod.invoke(null, (Object[])null);
            }
            return this.readMethod.invoke(callback.getReferenceInstance(), (Object[])null);
        }

        public Class getPropertyType(String name) {
            return this.readMethod.getReturnType();
        }
    }

    static interface PropertyFetcher {
        public Object get(ReferenceInstanceCallback var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public Class getPropertyType(String var1);
    }

    public static interface ReferenceInstanceCallback {
        public Object getReferenceInstance();
    }
}

