/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.exceptions.GrailsDomainException;
import org.codehaus.groovy.grails.plugins.DomainClassGrailsPlugin;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.springframework.validation.Validator;

public class DefaultGrailsDomainClassProperty
implements GrailsDomainClassProperty {
    private static final Log LOG = LogFactory.getLog(DefaultGrailsDomainClassProperty.class);
    private GrailsDomainClass domainClass;
    private boolean persistant;
    private boolean identity;
    private boolean oneToMany;
    private String name;
    private Class type;
    private boolean manyToMany;
    private boolean manyToOne;
    private boolean oneToOne;
    private boolean hasOne = false;
    private boolean bidirectional;
    private Class referencedPropertyType;
    private GrailsDomainClass referencedDomainClass;
    private GrailsDomainClassProperty otherSide;
    private String naturalName;
    private boolean inherited;
    private int fetchMode = 0;
    private boolean owningSide;
    private String referencePropertyName;
    private boolean embedded;
    private GrailsDomainClass component;
    private boolean basicCollectionType;

    public DefaultGrailsDomainClassProperty(GrailsDomainClass domainClass, PropertyDescriptor descriptor) {
        this.domainClass = domainClass;
        this.persistant = true;
        this.name = descriptor.getName();
        this.naturalName = GrailsNameUtils.getNaturalName((String)descriptor.getName());
        this.type = descriptor.getPropertyType();
        this.identity = descriptor.getName().equals("id");
        if (domainClass != null) {
            if (!domainClass.isRoot()) {
                this.inherited = GrailsClassUtils.isPropertyInherited(domainClass.getClazz(), this.name);
            }
            List transientProps = this.getTransients(domainClass);
            this.checkIfTransient(transientProps);
            this.establishFetchMode();
        }
    }

    private void establishFetchMode() {
        Map fetchMap = (Map)this.domainClass.getPropertyValue("fetchMode", Map.class);
        if (fetchMap != null && fetchMap.containsKey(this.name) && "eager".equals(fetchMap.get(this.name))) {
            this.fetchMode = 1;
        }
    }

    private void checkIfTransient(List transientProps) {
        if (transientProps != null) {
            for (Object currentObj : transientProps) {
                String propertyName;
                if (!(currentObj instanceof String) || !(propertyName = (String)currentObj).equals(this.name)) continue;
                this.persistant = false;
                break;
            }
        }
    }

    private List getTransients(GrailsDomainClass domainClass) {
        ArrayList transientProps = (ArrayList)domainClass.getPropertyValue("transients", List.class);
        List evanescent = (List)domainClass.getPropertyValue("evanescent", List.class);
        if (evanescent != null) {
            if (transientProps == null) {
                transientProps = new ArrayList();
            }
            transientProps.addAll(evanescent);
        }
        return transientProps;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isPersistent() {
        return this.persistant;
    }

    public boolean isOptional() {
        ConstrainedProperty constrainedProperty = (ConstrainedProperty)this.domainClass.getConstrainedProperties().get(this.name);
        return constrainedProperty != null && constrainedProperty.isNullable();
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public boolean isOneToMany() {
        return this.oneToMany;
    }

    public boolean isManyToOne() {
        return this.manyToOne;
    }

    public String getFieldName() {
        return this.getName().toUpperCase();
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public GrailsDomainClass getDomainClass() {
        return this.domainClass;
    }

    public boolean isManyToMany() {
        return this.manyToMany;
    }

    protected void setManyToMany(boolean manyToMany) {
        this.manyToMany = manyToMany;
    }

    protected void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    protected void setManyToOne(boolean manyToOne) {
        this.manyToOne = manyToOne;
    }

    protected void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    protected void setHasOne(boolean isHasOne) {
        this.hasOne = isHasOne;
    }

    public boolean isHasOne() {
        return this.hasOne;
    }

    protected void setPersistant(boolean persistant) {
        this.persistant = persistant;
    }

    protected void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    public String getTypePropertyName() {
        String shortTypeName = ClassUtils.getShortClassName((Class)this.type);
        return shortTypeName.substring(0, 1).toLowerCase(Locale.ENGLISH) + shortTypeName.substring(1);
    }

    public Class getReferencedPropertyType() {
        if (this.isDomainAssociation()) {
            return this.referencedPropertyType;
        }
        return this.getType();
    }

    private boolean isDomainAssociation() {
        return (Collection.class.isAssignableFrom(this.type) || Map.class.isAssignableFrom(this.type)) && this.referencedPropertyType != null;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    protected void setReferencedPropertyType(Class referencedPropertyType) {
        this.referencedPropertyType = referencedPropertyType;
    }

    public GrailsDomainClass getReferencedDomainClass() {
        return this.referencedDomainClass;
    }

    public void setReferencedDomainClass(GrailsDomainClass referencedDomainClass) {
        if (referencedDomainClass != null) {
            this.referencedDomainClass = referencedDomainClass;
            this.referencedPropertyType = referencedDomainClass.getClazz();
        }
    }

    public boolean isAssociation() {
        return this.isOneToMany() || this.isOneToOne() || this.isManyToOne() || this.isManyToMany() || this.isEmbedded();
    }

    public boolean isEnum() {
        return GrailsClassUtils.isJdk5Enum(this.getType());
    }

    public String getNaturalName() {
        return this.naturalName;
    }

    public String toString() {
        String assType = null;
        if (this.isManyToMany()) {
            assType = "many-to-many";
        } else if (this.isOneToMany()) {
            assType = "one-to-many";
        } else if (this.isOneToOne()) {
            assType = "one-to-one";
        } else if (this.isManyToOne()) {
            assType = "many-to-one";
        } else if (this.isEmbedded()) {
            assType = "embedded";
        }
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("type", (Object)this.type).append("persistent", this.isPersistent()).append("optional", this.isOptional()).append("association", this.isAssociation()).append("bidirectional", this.isBidirectional()).append("association-type", (Object)assType).toString();
    }

    public GrailsDomainClassProperty getOtherSide() {
        return this.otherSide;
    }

    public void setOtherSide(GrailsDomainClassProperty property) {
        if (!this.equals(property)) {
            this.setBidirectional(true);
            if (this.isOneToOne() && property.isOneToMany()) {
                this.setOneToOne(false);
                this.setManyToOne(true);
            }
        }
        this.otherSide = property;
    }

    private String getPropertyPathString(GrailsDomainClassProperty property) {
        return property.getDomainClass().getFullName() + "." + property.getName();
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public int getFetchMode() {
        return this.fetchMode;
    }

    public boolean isOwningSide() {
        return this.isHasOne() || this.owningSide;
    }

    public void setOwningSide(boolean b) {
        this.owningSide = b;
    }

    public boolean isCircular() {
        return this.otherSide != null ? this.otherSide.getDomainClass().getClazz().isAssignableFrom(this.domainClass.getClazz()) : this.getReferencedPropertyType().isAssignableFrom(this.domainClass.getClazz());
    }

    public void setReferencePropertyName(String name) {
        this.referencePropertyName = name;
    }

    public String getReferencedPropertyName() {
        return this.referencePropertyName;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public GrailsDomainClass getComponent() {
        return this.component;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.embedded = isEmbedded;
        if (isEmbedded) {
            this.component = new ComponentDomainClass(this.getType());
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof GrailsDomainClassProperty) {
            if (!super.equals(o)) {
                GrailsDomainClassProperty otherProp = (GrailsDomainClassProperty)o;
                boolean namesMatch = otherProp.getName().equals(this.getName());
                boolean typesMatch = otherProp.getReferencedPropertyType().equals(this.getReferencedPropertyType());
                Class myActualClass = this.getDomainClass().getClazz();
                Class otherActualClass = otherProp.getDomainClass().getClazz();
                boolean classMatch = otherActualClass.isAssignableFrom(myActualClass) || myActualClass.isAssignableFrom(otherActualClass);
                return namesMatch && typesMatch && classMatch;
            }
            return true;
        }
        return false;
    }

    public void setBasicCollectionType(boolean b) {
        this.basicCollectionType = b;
    }

    public boolean isBasicCollectionType() {
        return this.basicCollectionType;
    }

    private class ComponentDomainClass
    extends AbstractGrailsClass
    implements GrailsDomainClass {
        private GrailsDomainClassProperty[] properties;
        private Map constraints;
        private List transients;

        public ComponentDomainClass(Class type) {
            PropertyDescriptor[] descriptors;
            super(type, "");
            this.constraints = Collections.EMPTY_MAP;
            this.transients = Collections.EMPTY_LIST;
            try {
                descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new GrailsDomainException("Failed to use class [" + type + "] as a component. Cannot introspect! " + e.getMessage());
            }
            List tmp = (List)this.getPropertyOrStaticPropertyOrFieldValue("transients", List.class);
            if (tmp != null) {
                this.transients = tmp;
            }
            this.properties = this.createDomainClassProperties(this, descriptors);
            try {
                this.constraints = GrailsDomainConfigurationUtil.evaluateConstraints(this.getReference().getWrappedInstance(), this.properties);
                DomainClassGrailsPlugin.registerConstraintsProperty(this.getMetaClass(), this);
            }
            catch (IntrospectionException e) {
                LOG.error((Object)("Error reading embedded component [" + this.getClazz() + "] constraints: " + e.getMessage()), (Throwable)e);
            }
        }

        private GrailsDomainClassProperty[] createDomainClassProperties(ComponentDomainClass type, PropertyDescriptor[] descriptors) {
            ArrayList<DefaultGrailsDomainClassProperty> properties = new ArrayList<DefaultGrailsDomainClassProperty>();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                if (!this.isPersistentProperty(descriptor)) continue;
                properties.add(new DefaultGrailsDomainClassProperty(type, descriptor));
            }
            return properties.toArray(new GrailsDomainClassProperty[properties.size()]);
        }

        private boolean isPersistentProperty(PropertyDescriptor descriptor) {
            String propertyName = descriptor.getName();
            return GrailsDomainConfigurationUtil.isNotConfigurational(descriptor) && !this.transients.contains(propertyName);
        }

        public boolean isOwningClass(Class domainClass) {
            return domainClass != null && domainClass.equals(DefaultGrailsDomainClassProperty.this.getDomainClass().getClazz());
        }

        public GrailsDomainClassProperty[] getProperties() {
            return this.properties;
        }

        public GrailsDomainClassProperty[] getPersistantProperties() {
            return this.properties;
        }

        public GrailsDomainClassProperty[] getPersistentProperties() {
            return this.properties;
        }

        public GrailsDomainClassProperty getIdentifier() {
            return null;
        }

        public GrailsDomainClassProperty getVersion() {
            return null;
        }

        public Map getAssociationMap() {
            return Collections.EMPTY_MAP;
        }

        public GrailsDomainClassProperty getPropertyByName(String name) {
            for (int i = 0; i < this.properties.length; ++i) {
                GrailsDomainClassProperty property = this.properties[i];
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }

        public String getFieldName(String propertyName) {
            return null;
        }

        public boolean isOneToMany(String propertyName) {
            return false;
        }

        public boolean isManyToOne(String propertyName) {
            return false;
        }

        public boolean isBidirectional(String propertyName) {
            return false;
        }

        public Class getRelatedClassType(String propertyName) {
            return this.getPropertyByName(propertyName).getReferencedPropertyType();
        }

        public Map getConstrainedProperties() {
            return this.constraints;
        }

        public Validator getValidator() {
            return null;
        }

        public void setValidator(Validator validator) {
        }

        public String getMappingStrategy() {
            return "GORM";
        }

        public boolean isRoot() {
            return true;
        }

        public Set getSubClasses() {
            return Collections.EMPTY_SET;
        }

        public void refreshConstraints() {
            try {
                GrailsDomainClassProperty[] props = this.getPersistentProperties();
                this.constraints = GrailsDomainConfigurationUtil.evaluateConstraints(this.getReference().getWrappedInstance(), props);
            }
            catch (IntrospectionException e) {
                LOG.error((Object)("Error reading class [" + this.getClazz() + "] constraints: " + e.getMessage()), (Throwable)e);
            }
        }

        public boolean hasSubClasses() {
            return false;
        }

        public Map getMappedBy() {
            return Collections.EMPTY_MAP;
        }

        public boolean hasPersistentProperty(String propertyName) {
            for (int i = 0; i < this.properties.length; ++i) {
                GrailsDomainClassProperty persistantProperty = this.properties[i];
                if (!persistantProperty.getName().equals(propertyName)) continue;
                return true;
            }
            return false;
        }

        public void setMappingStrategy(String strategy) {
        }
    }
}

