/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.DefaultGrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.exceptions.GrailsDomainException;
import org.codehaus.groovy.grails.exceptions.InvalidPropertyException;
import org.springframework.beans.BeanUtils;
import org.springframework.validation.Validator;

public class DefaultGrailsDomainClass
extends AbstractGrailsClass
implements GrailsDomainClass {
    private static final Log LOG = LogFactory.getLog(DefaultGrailsDomainClass.class);
    private GrailsDomainClassProperty identifier;
    private GrailsDomainClassProperty version;
    private GrailsDomainClassProperty[] properties;
    private GrailsDomainClassProperty[] persistentProperties;
    private Map propertyMap;
    private Map relationshipMap;
    private Map constraints = new HashMap();
    private Map mappedBy;
    private Validator validator;
    private String mappingStrategy = "GORM";
    private List owners = new ArrayList();
    private boolean root = true;
    private Set subClasses = new HashSet();
    private Collection embedded;

    public DefaultGrailsDomainClass(Class clazz) {
        super(clazz, "");
        PropertyDescriptor[] propertyDescriptors = this.getReference().getPropertyDescriptors();
        if (!(clazz.getSuperclass().equals(GroovyObject.class) || clazz.getSuperclass().equals(Object.class) || Modifier.isAbstract(clazz.getSuperclass().getModifiers()))) {
            this.root = false;
        }
        this.propertyMap = new LinkedHashMap();
        this.relationshipMap = this.getAssociationMap();
        this.embedded = this.getEmbeddedList();
        if (this.getPropertyOrStaticPropertyOrFieldValue("mapWith", String.class) != null) {
            this.mappingStrategy = (String)this.getPropertyOrStaticPropertyOrFieldValue("mapWith", String.class);
        }
        this.mappedBy = (Map)this.getPropertyOrStaticPropertyOrFieldValue("mappedBy", Map.class);
        if (this.mappedBy == null) {
            this.mappedBy = Collections.EMPTY_MAP;
        }
        this.establishRelationshipOwners();
        this.populateDomainClassProperties(propertyDescriptors);
        if (this.identifier == null) {
            throw new GrailsDomainException("Identity property not found, but required in domain class [" + this.getFullName() + "]");
        }
        if (this.version == null) {
            throw new GrailsDomainException("Version property not found, but required in domain class [" + this.getFullName() + "]");
        }
        this.properties = this.propertyMap.values().toArray(new GrailsDomainClassProperty[this.propertyMap.size()]);
        this.establishRelationships();
        this.establishPersistentProperties();
        try {
            this.constraints = GrailsDomainConfigurationUtil.evaluateConstraints(this.getReference().getWrappedInstance(), this.persistentProperties);
        }
        catch (IntrospectionException e) {
            LOG.error((Object)("Error reading class [" + this.getClazz() + "] constraints: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean hasSubClasses() {
        return this.getSubClasses().size() > 0;
    }

    private void establishPersistentProperties() {
        ArrayList<GrailsDomainClassProperty> tempList = new ArrayList<GrailsDomainClassProperty>();
        for (GrailsDomainClassProperty currentProp : this.propertyMap.values()) {
            if (currentProp.getType() == Object.class || !currentProp.isPersistent() || currentProp.isIdentity() || currentProp.getName().equals("version")) continue;
            tempList.add(currentProp);
        }
        this.persistentProperties = tempList.toArray(new GrailsDomainClassProperty[tempList.size()]);
    }

    private void establishRelationshipOwners() {
        Class belongsTo = (Class)this.getPropertyOrStaticPropertyOrFieldValue("belongsTo", Class.class);
        if (belongsTo == null) {
            List ownersProp = (List)this.getPropertyOrStaticPropertyOrFieldValue("belongsTo", List.class);
            if (ownersProp != null) {
                this.owners = ownersProp;
            } else {
                Map ownersMap = (Map)this.getPropertyOrStaticPropertyOrFieldValue("belongsTo", Map.class);
                if (ownersMap != null) {
                    this.owners = new ArrayList(ownersMap.values());
                }
            }
        } else {
            this.owners = new ArrayList();
            this.owners.add(belongsTo);
        }
    }

    private void populateDomainClassProperties(PropertyDescriptor[] propertyDescriptors) {
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            if (!GrailsDomainConfigurationUtil.isNotConfigurational(descriptor)) continue;
            DefaultGrailsDomainClassProperty property = new DefaultGrailsDomainClassProperty(this, descriptor);
            this.propertyMap.put(property.getName(), property);
            if (property.isIdentity()) {
                this.identifier = property;
                continue;
            }
            if (!property.getName().equals("version")) continue;
            this.version = property;
        }
    }

    public Map getAssociationMap() {
        if (this.relationshipMap == null) {
            this.relationshipMap = (Map)this.getPropertyOrStaticPropertyOrFieldValue("hasMany", Map.class);
            if (this.relationshipMap == null) {
                this.relationshipMap = new HashMap();
            }
            Class theClass = this.getClazz();
            while (theClass != Object.class) {
                Map superRelationshipMap = (Map)GrailsClassUtils.getStaticPropertyValue(theClass = theClass.getSuperclass(), "hasMany");
                if (superRelationshipMap == null || ((Object)superRelationshipMap).equals(this.relationshipMap)) continue;
                this.relationshipMap.putAll(superRelationshipMap);
            }
        }
        return this.relationshipMap;
    }

    private Collection getEmbeddedList() {
        Object potentialList = GrailsClassUtils.getStaticPropertyValue(this.getClazz(), "embedded");
        if (potentialList instanceof Collection) {
            return (Collection)potentialList;
        }
        return Collections.EMPTY_LIST;
    }

    private void establishRelationships() {
        for (DefaultGrailsDomainClassProperty currentProp : this.propertyMap.values()) {
            Class currentPropType = currentProp.getType();
            if (Collection.class.isAssignableFrom(currentPropType) || Map.class.isAssignableFrom(currentPropType) && currentProp.isPersistent()) {
                this.establishRelationshipForCollection(currentProp);
                continue;
            }
            if (DomainClassArtefactHandler.isDomainClass(currentPropType) && currentProp.isPersistent()) {
                this.establishDomainClassRelationship(currentProp);
                continue;
            }
            if (GrailsDomainConfigurationUtil.isBasicType(currentProp)) continue;
            this.establishDomainClassRelationship(currentProp);
        }
    }

    private void establishRelationshipForCollection(DefaultGrailsDomainClassProperty property) {
        Class relatedClassType = this.getRelatedClassType(property.getName());
        if (relatedClassType != null) {
            property.setReferencedPropertyType(relatedClassType);
            if (DomainClassArtefactHandler.isDomainClass(relatedClassType)) {
                Map relatedClassRelationships = GrailsDomainConfigurationUtil.getAssociationMap(relatedClassType);
                Class<?> relatedClassPropertyType = null;
                String mappingProperty = (String)this.mappedBy.get(property.getName());
                if (!StringUtils.isBlank((String)mappingProperty)) {
                    PropertyDescriptor pd = this.findProperty(GrailsClassUtils.getPropertiesOfType(relatedClassType, this.getClazz()), mappingProperty);
                    if (pd == null) {
                        pd = this.findProperty(GrailsClassUtils.getPropertiesAssignableToType(relatedClassType, Collection.class), mappingProperty);
                    }
                    if (pd == null) {
                        throw new GrailsDomainException("Non-existent mapping property [" + mappingProperty + "] specified for property [" + property.getName() + "] in class [" + this.getClazz() + "]");
                    }
                    relatedClassPropertyType = pd.getPropertyType();
                    property.setReferencePropertyName(pd.getName());
                } else {
                    if (this.isRelationshipManyToMany(property, relatedClassType, relatedClassRelationships)) {
                        String relatedClassPropertyName = null;
                        for (String currentKey : relatedClassRelationships.keySet()) {
                            Class currentClass = (Class)relatedClassRelationships.get(currentKey);
                            if (!currentClass.isAssignableFrom(this.getClazz())) continue;
                            relatedClassPropertyName = currentKey;
                            break;
                        }
                        if (relatedClassPropertyName != null) {
                            relatedClassPropertyType = GrailsClassUtils.getPropertyType(relatedClassType, relatedClassPropertyName);
                        }
                    }
                    if (relatedClassPropertyType == null) {
                        PropertyDescriptor[] descriptors = GrailsClassUtils.getPropertiesOfType(relatedClassType, this.getClazz());
                        if (descriptors.length == 1) {
                            relatedClassPropertyType = descriptors[0].getPropertyType();
                            property.setReferencePropertyName(descriptors[0].getName());
                        } else if (descriptors.length > 1) {
                            String classPropertyName = this.getPropertyName();
                            PropertyDescriptor pd = this.findProperty(descriptors, classPropertyName);
                            if (pd == null) {
                                throw new GrailsDomainException("Property [" + property.getName() + "] in class [" + this.getClazz() + "] is a bidirectional one-to-many with two possible properties on the inverse side. " + "Either name one of the properties on other side of the relationship [" + classPropertyName + "] or use the 'mappedBy' static to define the property " + "that the relationship is mapped with. Example: static mappedBy = [" + property.getName() + ":'myprop']");
                            }
                            relatedClassPropertyType = pd.getPropertyType();
                            property.setReferencePropertyName(pd.getName());
                        }
                    }
                }
                this.establishRelationshipForSetToType(property, relatedClassPropertyType);
                if (property.isManyToMany()) {
                    this.establishOwnerOfManyToMany(property, relatedClassType);
                }
            } else {
                property.setBasicCollectionType(true);
            }
        } else if (!Map.class.isAssignableFrom(property.getType())) {
            property.setPersistant(false);
        }
    }

    private PropertyDescriptor findProperty(PropertyDescriptor[] descriptors, String propertyName) {
        PropertyDescriptor d = null;
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            if (!descriptor.getName().equals(propertyName)) continue;
            d = descriptor;
            break;
        }
        return d;
    }

    private boolean isRelationshipManyToMany(DefaultGrailsDomainClassProperty property, Class relatedClassType, Map relatedClassRelationships) {
        return relatedClassRelationships != null && !relatedClassRelationships.isEmpty() && !relatedClassType.equals(property.getDomainClass().getClazz());
    }

    private void establishOwnerOfManyToMany(DefaultGrailsDomainClassProperty property, Class relatedClassType) {
        Object related = BeanUtils.instantiateClass((Class)relatedClassType);
        Object relatedBelongsTo = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(related, "belongsTo");
        boolean owningSide = false;
        boolean relatedOwner = this.owners.contains(relatedClassType);
        Class propertyClass = property.getDomainClass().getClazz();
        if (relatedBelongsTo instanceof Collection) {
            owningSide = ((Collection)relatedBelongsTo).contains(propertyClass);
        } else if (relatedBelongsTo != null) {
            owningSide = relatedBelongsTo.equals(propertyClass);
        }
        property.setOwningSide(owningSide);
        if (relatedOwner && property.isOwningSide()) {
            throw new GrailsDomainException("Domain classes [" + propertyClass + "] and [" + relatedClassType + "] cannot own each other in a many-to-many relationship. Both contain belongsTo definitions that reference each other.");
        }
        if (!relatedOwner && !property.isOwningSide()) {
            throw new GrailsDomainException("No owner defined between domain classes [" + propertyClass + "] and [" + relatedClassType + "] in a many-to-many relationship. Example: def belongsTo = " + relatedClassType.getName());
        }
    }

    private void establishRelationshipForSetToType(DefaultGrailsDomainClassProperty property, Class relatedClassPropertyType) {
        if (relatedClassPropertyType == null) {
            property.setOneToMany(true);
            property.setBidirectional(false);
        } else if (Collection.class.isAssignableFrom(relatedClassPropertyType)) {
            property.setManyToMany(true);
            property.setBidirectional(true);
        } else if (DomainClassArtefactHandler.isDomainClass(relatedClassPropertyType)) {
            property.setOneToMany(true);
            property.setBidirectional(true);
        }
    }

    private void establishDomainClassRelationship(DefaultGrailsDomainClassProperty property) {
        PropertyDescriptor[] descriptors;
        Class propType = property.getType();
        if (this.embedded.contains(property.getName())) {
            property.setEmbedded(true);
            return;
        }
        Map relatedClassRelationships = GrailsDomainConfigurationUtil.getAssociationMap(propType);
        Map mappedBy = GrailsDomainConfigurationUtil.getMappedByMap(propType);
        Class relatedClassPropertyType = null;
        if (relatedClassRelationships != null && !relatedClassRelationships.isEmpty()) {
            String relatedClassPropertyName = this.findOneToManyThatMatchesType(property, relatedClassRelationships);
            PropertyDescriptor[] descriptors2 = GrailsClassUtils.getPropertiesOfType(this.getClazz(), property.getType());
            if (descriptors2.length == 1 && this.isNotMappedToDifferentProperty(property, relatedClassPropertyName, mappedBy)) {
                if (!StringUtils.isBlank((String)relatedClassPropertyName)) {
                    property.setReferencePropertyName(relatedClassPropertyName);
                    relatedClassPropertyType = GrailsClassUtils.getPropertyType(propType, relatedClassPropertyName);
                }
            } else if (descriptors2.length > 1) {
                if (mappedBy.containsValue(property.getName())) {
                    for (String mappedByPropertyName : mappedBy.keySet()) {
                        Class mappedByRelatedType;
                        if (!property.getName().equals(mappedBy.get(mappedByPropertyName)) || (mappedByRelatedType = (Class)relatedClassRelationships.get(mappedByPropertyName)) == null || !propType.isAssignableFrom(mappedByRelatedType)) continue;
                        relatedClassPropertyType = GrailsClassUtils.getPropertyType(propType, mappedByPropertyName);
                    }
                } else {
                    String classNameAsProperty = GrailsNameUtils.getPropertyName((Class)propType);
                    if (property.getName().equals(classNameAsProperty) && !mappedBy.containsKey(relatedClassPropertyName)) {
                        relatedClassPropertyType = GrailsClassUtils.getPropertyType(propType, relatedClassPropertyName);
                    }
                }
            }
        }
        if (relatedClassPropertyType == null && (descriptors = GrailsClassUtils.getPropertiesOfType(propType, this.getClazz())).length == 1) {
            relatedClassPropertyType = descriptors[0].getPropertyType();
        }
        this.establishDomainClassRelationshipToType(property, relatedClassPropertyType);
    }

    private boolean isNotMappedToDifferentProperty(GrailsDomainClassProperty property, String relatedClassPropertyName, Map mappedBy) {
        String mappedByForRelation = (String)mappedBy.get(relatedClassPropertyName);
        if (mappedByForRelation == null) {
            return true;
        }
        return property.getName().equals(mappedByForRelation);
    }

    private String findOneToManyThatMatchesType(DefaultGrailsDomainClassProperty property, Map relatedClassRelationships) {
        String relatedClassPropertyName = null;
        for (String currentKey : relatedClassRelationships.keySet()) {
            Class currentClass = (Class)relatedClassRelationships.get(currentKey);
            if (!property.getDomainClass().getClazz().getName().equals(currentClass.getName())) continue;
            relatedClassPropertyName = currentKey;
            break;
        }
        return relatedClassPropertyName;
    }

    private void establishDomainClassRelationshipToType(DefaultGrailsDomainClassProperty property, Class relatedClassPropertyType) {
        if (relatedClassPropertyType == null) {
            property.setOneToOne(true);
            property.setBidirectional(false);
        } else if (Collection.class.isAssignableFrom(relatedClassPropertyType) || Map.class.isAssignableFrom(relatedClassPropertyType)) {
            property.setManyToOne(true);
            property.setBidirectional(true);
        } else if (DomainClassArtefactHandler.isDomainClass(relatedClassPropertyType)) {
            property.setOneToOne(true);
            if (!this.getClazz().equals(relatedClassPropertyType)) {
                property.setBidirectional(true);
            }
        }
    }

    public boolean isOwningClass(Class domainClass) {
        return this.owners.contains(domainClass);
    }

    public GrailsDomainClassProperty[] getProperties() {
        return this.properties;
    }

    public GrailsDomainClassProperty getIdentifier() {
        return this.identifier;
    }

    public GrailsDomainClassProperty getVersion() {
        return this.version;
    }

    public GrailsDomainClassProperty[] getPersistantProperties() {
        return this.persistentProperties;
    }

    public GrailsDomainClassProperty[] getPersistentProperties() {
        return this.persistentProperties;
    }

    public GrailsDomainClassProperty getPropertyByName(String name) {
        if (this.propertyMap.containsKey(name)) {
            return (GrailsDomainClassProperty)this.propertyMap.get(name);
        }
        throw new InvalidPropertyException("No property found for name [" + name + "] for class [" + this.getClazz() + "]");
    }

    public String getFieldName(String propertyName) {
        return this.getPropertyByName(propertyName).getFieldName();
    }

    public String getName() {
        return ClassUtils.getShortClassName((String)super.getName());
    }

    public boolean isOneToMany(String propertyName) {
        return this.getPropertyByName(propertyName).isOneToMany();
    }

    public boolean isManyToOne(String propertyName) {
        return this.getPropertyByName(propertyName).isManyToOne();
    }

    protected Object getPropertyOrStaticPropertyOrFieldValue(String name, Class type) {
        return super.getPropertyOrStaticPropertyOrFieldValue(name, type);
    }

    public Class getRelatedClassType(String propertyName) {
        return (Class)this.relationshipMap.get(propertyName);
    }

    public String getPropertyName() {
        return GrailsNameUtils.getPropertyNameRepresentation((Class)this.getClazz());
    }

    public boolean isBidirectional(String propertyName) {
        return this.getPropertyByName(propertyName).isBidirectional();
    }

    public Map getConstrainedProperties() {
        return Collections.unmodifiableMap(this.constraints);
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String getMappingStrategy() {
        return this.mappingStrategy;
    }

    public boolean isRoot() {
        return this.root;
    }

    public Set getSubClasses() {
        return this.subClasses;
    }

    public void refreshConstraints() {
        try {
            this.constraints = GrailsDomainConfigurationUtil.evaluateConstraints(this.getReference().getWrappedInstance(), this.persistentProperties);
            for (int i = 0; i < this.persistentProperties.length; ++i) {
                GrailsDomainClassProperty property = this.persistentProperties[i];
                if (!property.isEmbedded()) continue;
                property.getComponent().refreshConstraints();
            }
        }
        catch (IntrospectionException e) {
            LOG.error((Object)("Error reading class [" + this.getClazz() + "] constraints: " + e.getMessage()), (Throwable)e);
        }
    }

    public Map getMappedBy() {
        return this.mappedBy;
    }

    public boolean hasPersistentProperty(String propertyName) {
        for (int i = 0; i < this.persistentProperties.length; ++i) {
            GrailsDomainClassProperty persistentProperty = this.persistentProperties[i];
            if (!persistentProperty.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public void setMappingStrategy(String strategy) {
        this.mappingStrategy = strategy;
    }
}

