/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import groovy.lang.GroovyClassLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerHolder;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class GrailsPluginManagerFactoryBean
implements FactoryBean,
InitializingBean,
ApplicationContextAware {
    private GrailsApplication application;
    private GrailsPluginManager pluginManager;
    private static final Log LOG = LogFactory.getLog(GrailsPluginManagerFactoryBean.class);
    private Resource descriptor;
    private ResourceLoader resourceLoader;
    private ApplicationContext applicationContext;

    public void setApplication(GrailsApplication application) {
        this.application = application;
    }

    public Object getObject() throws Exception {
        return this.pluginManager;
    }

    public Class getObjectType() {
        return GrailsPluginManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        this.pluginManager = PluginManagerHolder.getPluginManager();
        if (this.pluginManager == null) {
            if (this.descriptor == null) {
                throw new IllegalStateException("Cannot create PluginManager, /WEB-INF/grails.xml not found!");
            }
            GroovyClassLoader classLoader = this.application.getClassLoader();
            ArrayList<Class> classes = new ArrayList<Class>();
            SAXReader reader = new SAXReader();
            InputStream inputStream = null;
            try {
                inputStream = this.descriptor.getInputStream();
                Document doc = reader.read(inputStream);
                List grailsClasses = doc.selectNodes("/grails/plugins/plugin");
                for (Node node : grailsClasses) {
                    String pluginName = node.getText();
                    classes.add(classLoader.loadClass(pluginName));
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            Class[] loadedPlugins = classes.toArray(new Class[classes.size()]);
            this.pluginManager = new DefaultGrailsPluginManager(loadedPlugins, this.application);
            this.pluginManager.setApplicationContext(this.applicationContext);
            PluginManagerHolder.setPluginManager(this.pluginManager);
            this.pluginManager.loadPlugins();
        }
        this.pluginManager.setApplication(this.application);
        this.pluginManager.doArtefactConfiguration();
        this.application.initialise();
    }

    public void setGrailsDescriptor(Resource grailsDescriptor) {
        this.descriptor = grailsDescriptor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

