/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.PluginMetaManager;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DefaultPluginMetaManager
implements PluginMetaManager,
GrailsApplicationAware,
InitializingBean,
ResourceLoaderAware {
    private static final Log LOG = LogFactory.getLog(DefaultPluginMetaManager.class);
    private Map pluginInfo = new HashMap();
    private Map resourceToPluginMap = new HashMap();
    private GrailsPluginManager pluginManager;
    private static final String PLUGINS_PATH = "/plugins/";
    private GrailsApplication grailsApplication;
    private String resourcePattern;
    private ResourceLoader resourceLoader;

    public DefaultPluginMetaManager() {
    }

    public DefaultPluginMetaManager(Resource[] pluginDescriptors) {
        this.configureMetaManager(pluginDescriptors);
    }

    public void setResourcePattern(String resourcePattern) {
        this.resourcePattern = resourcePattern;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void afterPropertiesSet() throws Exception {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        Resource[] pluginDescriptors = new Resource[]{};
        try {
            if (this.grailsApplication != null && this.grailsApplication.isWarDeployed()) {
                pluginDescriptors = patternResolver.getResources(this.resourcePattern);
            } else {
                File pluginDir;
                BuildSettings settings = BuildSettingsHolder.getSettings();
                File file = pluginDir = settings != null ? settings.getProjectPluginsDir() : null;
                if (pluginDir != null) {
                    pluginDescriptors = GrailsPluginUtils.getPluginXmlMetadata(pluginDir.getPath());
                }
            }
        }
        catch (Throwable e) {
            LOG.debug((Object)("Error resolving plug-in descriptors: " + e.getMessage()));
        }
        this.configureMetaManager(pluginDescriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureMetaManager(Resource[] pluginDescriptors) {
        for (int i = 0; i < pluginDescriptors.length; ++i) {
            Resource pluginDescriptor = pluginDescriptors[i];
            SAXReader reader = new SAXReader();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = pluginDescriptor.getInputStream();
                    Document doc = reader.read(inputStream);
                    Element pluginElement = doc.getRootElement();
                    String pluginName = pluginElement.attributeValue("name");
                    String pluginVersion = pluginElement.attributeValue("version");
                    if (StringUtils.isBlank((String)pluginName)) {
                        throw new GrailsConfigurationException("Plug-in descriptor [" + pluginDescriptor + "] doesn't specify a plug-in name. It must be corrupted, try re-install the plug-in");
                    }
                    if (StringUtils.isBlank((String)pluginVersion)) {
                        throw new GrailsConfigurationException("Plug-in descriptor [" + pluginDescriptor + "] with name [" + pluginName + "] doesn't specify a plug-in version. It must be corrupted, try re-install the plug-in");
                    }
                    List grailsClasses = new ArrayList();
                    try {
                        grailsClasses = doc.selectNodes("/plugin/resources/resource");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ArrayList<String> pluginResources = new ArrayList<String>();
                    for (Node node : grailsClasses) {
                        pluginResources.add(node.getText());
                    }
                    PluginMeta pluginMeta = new PluginMeta(pluginName, pluginVersion);
                    pluginMeta.pluginResources = pluginResources.toArray(new String[pluginResources.size()]);
                    this.pluginInfo.put(pluginName, pluginMeta);
                    for (int j = 0; j < pluginMeta.pluginResources.length; ++j) {
                        String pluginResource = pluginMeta.pluginResources[j];
                        this.resourceToPluginMap.put(pluginResource, pluginMeta);
                    }
                    continue;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("Error loading plug-in descriptor [" + pluginDescriptor + "]:" + e.getMessage(), e);
            }
            catch (DocumentException e) {
                throw new GrailsConfigurationException("Error loading plug-in descriptor [" + pluginDescriptor + "]:" + e.getMessage(), e);
            }
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String[] getPluginResources(String pluginName) {
        PluginMeta pluginMeta = (PluginMeta)this.pluginInfo.get(pluginName);
        return pluginMeta.pluginResources;
    }

    public GrailsPlugin getPluginForResource(String name) {
        PluginMeta pluginMeta = (PluginMeta)this.resourceToPluginMap.get(name);
        if (pluginMeta != null) {
            if (this.pluginManager == null) {
                throw new IllegalStateException("Property [pluginManager] not set!");
            }
            return this.pluginManager.getGrailsPlugin(pluginMeta.name, pluginMeta.version);
        }
        return null;
    }

    public String getPluginPathForResource(String resourceName) {
        PluginMeta pluginMeta = (PluginMeta)this.resourceToPluginMap.get(resourceName);
        if (pluginMeta != null) {
            return PLUGINS_PATH + pluginMeta.name + '-' + pluginMeta.version;
        }
        return null;
    }

    public String getPluginViewsPathForResource(String resourceName) {
        PluginMeta pluginMeta = (PluginMeta)this.resourceToPluginMap.get(resourceName);
        if (pluginMeta != null) {
            return PLUGINS_PATH + pluginMeta.name + '-' + pluginMeta.version + '/' + "grails-app" + "/views";
        }
        return null;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    private class PluginMeta {
        String name;
        String version;
        String[] pluginResources;

        private PluginMeta(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginMeta that = (PluginMeta)o;
            return !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

