/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import grails.util.GrailsUtil;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObjectSupport;
import groovy.util.ConfigObject;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.BootstrapArtefactHandler;
import org.codehaus.groovy.grails.commons.CodecArtefactHandler;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.commons.ControllerArtefactHandler;
import org.codehaus.groovy.grails.commons.DefaultArtefactInfo;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.ServiceArtefactHandler;
import org.codehaus.groovy.grails.commons.TagLibArtefactHandler;
import org.codehaus.groovy.grails.commons.UrlMappingsArtefactHandler;
import org.codehaus.groovy.grails.commons.cfg.ConfigurationHelper;
import org.codehaus.groovy.grails.commons.spring.GrailsResourceHolder;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.codehaus.groovy.grails.compiler.injection.DefaultGrailsDomainClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareClassLoader;
import org.codehaus.groovy.grails.compiler.support.GrailsResourceLoader;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class DefaultGrailsApplication
extends GroovyObjectSupport
implements GrailsApplication,
BeanClassLoaderAware {
    private static final Pattern GETCLASSESPROP_PATTERN = Pattern.compile("(\\w+)(Classes)");
    private static final Pattern GETCLASSESMETH_PATTERN = Pattern.compile("(get)(\\w+)(Classes)");
    private static final Pattern ISCLASS_PATTERN = Pattern.compile("(is)(\\w+)(Class)");
    private static final Pattern GETCLASS_PATTERN = Pattern.compile("(get)(\\w+)Class");
    private static final String PROJECT_META_FILE = "application.properties";
    private static final String META_GRAILS_WAR_DEPLOYED = "grails.war.deployed";
    private GroovyClassLoader cl = null;
    private Class[] allClasses = new Class[0];
    private static Log log = LogFactory.getLog(DefaultGrailsApplication.class);
    private ApplicationContext parentContext;
    private ApplicationContext mainContext;
    private Set loadedClasses = new HashSet();
    private GrailsResourceLoader resourceLoader;
    private ArtefactHandler[] artefactHandlers;
    private Map artefactHandlersByName = new HashMap();
    private Set allArtefactClasses = new HashSet();
    private Map artefactInfo = new HashMap();
    private boolean suspectArtefactInit;
    private Class[] allArtefactClassesArray;
    private Map applicationMeta;
    private Resource[] resources;
    private boolean initialised = false;
    private ClassLoader beanClassLoader;

    public DefaultGrailsApplication() {
        this.cl = new GroovyClassLoader();
        this.applicationMeta = this.loadMetadata();
    }

    public DefaultGrailsApplication(Class[] classes, GroovyClassLoader classLoader) {
        if (classes == null) {
            throw new IllegalArgumentException("Constructor argument 'classes' cannot be null");
        }
        for (int i = 0; i < classes.length; ++i) {
            Class aClass = classes[i];
            this.loadedClasses.add(aClass);
        }
        this.allClasses = classes;
        this.cl = classLoader;
        this.applicationMeta = this.loadMetadata();
    }

    public DefaultGrailsApplication(Resource[] resources) throws IOException {
        this(new GrailsResourceLoader(resources));
    }

    public DefaultGrailsApplication(GrailsResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        try {
            this.applicationMeta = this.loadMetadata();
            this.loadGrailsApplicationFromResources(resourceLoader.getResources());
        }
        catch (IOException e) {
            throw new GrailsConfigurationException("I/O exception loading Grails: " + e.getMessage(), e);
        }
    }

    private void loadGrailsApplicationFromResources(Resource[] resources) throws IOException {
        GrailsResourceHolder resourceHolder = new GrailsResourceHolder();
        this.cl = this.configureClassLoader(this.resourceLoader);
        List loadedResources = new ArrayList();
        this.loadedClasses = new HashSet();
        try {
            for (int i = 0; resources != null && i < resources.length; ++i) {
                if (!loadedResources.contains(resources[i])) {
                    try {
                        String className = resourceHolder.getClassName(resources[i]);
                        log.debug((Object)("Loading groovy file from resource loader :[" + resources[i].getFile().getAbsolutePath() + "] with name [" + className + "]"));
                        if (StringUtils.isBlank((String)className)) continue;
                        Class c = this.cl.loadClass(className, true, false);
                        Assert.notNull((Object)c, (String)"Groovy Bug! GCL loadClass method returned a null class!");
                        this.loadedClasses.add(c);
                        log.debug((Object)("Added Groovy class [" + c + "] to loaded classes"));
                        loadedResources = this.resourceLoader.getLoadedResources();
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("The class [" + e.getMessage() + "] was not found when attempting to load Grails application. Skipping."));
                    }
                    continue;
                }
                Class c = null;
                try {
                    log.debug((Object)("Loading groovy file from class loader :[" + resources[i].getFile().getAbsolutePath() + "]"));
                    c = this.cl.loadClass(resourceHolder.getClassName(resources[i]));
                }
                catch (ClassNotFoundException e) {
                    GrailsUtil.deepSanitize(e);
                    log.error((Object)("Class not found attempting to load class " + e.getMessage()), (Throwable)e);
                }
                if (c != null) {
                    this.loadedClasses.add(c);
                }
                log.debug((Object)("Added Groovy class [" + c + "] to loaded classes"));
            }
        }
        catch (CompilationFailedException e) {
            if (GrailsUtil.isDevelopmentEnv()) {
                log.fatal((Object)("Compilation error loading Grails application: " + e.getMessage()), (Throwable)e);
                System.exit(1);
            }
            throw e;
        }
    }

    protected Map loadMetadata() {
        Properties meta = new Properties();
        ClassPathResource r = new ClassPathResource(PROJECT_META_FILE, (ClassLoader)this.getClassLoader());
        try {
            meta.load(r.getInputStream());
        }
        catch (IOException e) {
            GrailsUtil.deepSanitize(e);
            log.warn((Object)("No application metadata file found at " + r));
        }
        if (System.getProperty(BuildSettings.ENVIRONMENT) != null) {
            meta.setProperty(BuildSettings.ENVIRONMENT, System.getProperty(BuildSettings.ENVIRONMENT));
        }
        return Collections.unmodifiableMap(meta);
    }

    private void initArtefactHandlers() {
        this.registerArtefactHandler(new DomainClassArtefactHandler());
        this.registerArtefactHandler(new ControllerArtefactHandler());
        this.registerArtefactHandler(new ServiceArtefactHandler());
        this.registerArtefactHandler(new TagLibArtefactHandler());
        this.registerArtefactHandler(new BootstrapArtefactHandler());
        this.registerArtefactHandler(new CodecArtefactHandler());
        this.registerArtefactHandler(new UrlMappingsArtefactHandler());
        this.artefactHandlers = this.artefactHandlersByName.values().toArray(new ArtefactHandler[this.artefactHandlersByName.size()]);
    }

    private GroovyClassLoader configureClassLoader(GrailsResourceLoader resourceLoader) {
        GroovyClassLoader cl;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        CompilerConfiguration config = CompilerConfiguration.DEFAULT;
        config.setSourceEncoding("UTF-8");
        ClassLoader rootLoader = DefaultGroovyMethods.getRootLoader((ClassLoader)contextLoader);
        if (rootLoader != null) {
            cl = new GrailsClassLoader(contextLoader, config, resourceLoader);
        } else {
            GrailsAwareClassLoader gcl = new GrailsAwareClassLoader(contextLoader, config);
            if (resourceLoader != null) {
                gcl.setResourceLoader(resourceLoader);
            }
            gcl.setClassInjectors(new ClassInjector[]{new DefaultGrailsDomainClassInjector()});
            cl = gcl;
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        return cl;
    }

    public Class[] getAllArtefacts() {
        return this.allArtefactClassesArray;
    }

    private Class[] populateAllClasses() {
        this.allClasses = this.loadedClasses.toArray(new Class[this.loadedClasses.size()]);
        return this.allClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLoadedClasses(Class[] classes) {
        this.initArtefactHandlers();
        this.artefactInfo.clear();
        this.allArtefactClasses.clear();
        this.allArtefactClassesArray = null;
        this.allClasses = classes;
        this.suspectArtefactInit = true;
        try {
            log.debug((Object)"Going to inspect artefact classes.");
            block3: for (int i = 0; i < classes.length; ++i) {
                Class theClass = classes[i];
                log.debug((Object)("Inspecting [" + theClass.getName() + "]"));
                if (Modifier.isAbstract(theClass.getModifiers())) {
                    log.debug((Object)("[" + theClass.getName() + "] is abstract."));
                    continue;
                }
                if (this.allArtefactClasses.contains(theClass)) continue;
                for (int j = 0; j < this.artefactHandlers.length; ++j) {
                    if (!this.artefactHandlers[j].isArtefact(theClass)) continue;
                    log.debug((Object)("Adding artefact " + theClass + " of kind " + this.artefactHandlers[j].getType()));
                    GrailsClass gclass = this.addArtefact(this.artefactHandlers[j].getType(), theClass);
                    this.allArtefactClasses.add(theClass);
                    DefaultArtefactInfo info = this.getArtefactInfo(this.artefactHandlers[j].getType(), true);
                    info.addGrailsClass(gclass);
                    continue block3;
                }
            }
            this.refreshArtefactGrailsClassCaches();
        }
        finally {
            this.suspectArtefactInit = false;
        }
        this.allArtefactClassesArray = this.allArtefactClasses.toArray(new Class[this.allArtefactClasses.size()]);
        for (int j = 0; j < this.artefactHandlers.length; ++j) {
            this.initializeArtefacts(this.artefactHandlers[j]);
        }
    }

    private void refreshArtefactGrailsClassCaches() {
        for (DefaultArtefactInfo info : this.artefactInfo.values()) {
            info.updateComplete();
        }
    }

    private void addToLoaded(Class clazz) {
        this.loadedClasses.add(clazz);
        this.populateAllClasses();
    }

    public GrailsResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public GroovyClassLoader getClassLoader() {
        return this.cl;
    }

    public ConfigObject getConfig() {
        ConfigObject c = ConfigurationHolder.getConfig();
        if (c == null) {
            c = ConfigurationHelper.loadConfigFromClasspath(this);
        }
        return c;
    }

    public Map getFlatConfig() {
        return ConfigurationHolder.getFlatConfig();
    }

    private int getArtefactCount(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? 0 : info.getClasses().length;
    }

    public Class[] getAllClasses() {
        return this.allClasses;
    }

    public ApplicationContext getMainContext() {
        return this.mainContext;
    }

    public void setMainContext(ApplicationContext context) {
        this.mainContext = context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public Class getClassForName(String className) {
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        for (int i = 0; i < this.allClasses.length; ++i) {
            Class c = this.allClasses[i];
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    public void refreshConstraints() {
        DefaultArtefactInfo info = this.getArtefactInfo("Domain", true);
        GrailsClass[] domainClasses = info.getGrailsClasses();
        for (int i = 0; i < domainClasses.length; ++i) {
            ((GrailsDomainClass)domainClasses[i]).refreshConstraints();
        }
    }

    public void refresh() {
        this.configureLoadedClasses(this.cl.getLoadedClasses());
    }

    public void rebuild() {
        this.initialised = false;
        this.loadedClasses.clear();
        this.initArtefactHandlers();
        if (GrailsUtil.isDevelopmentEnv()) {
            try {
                this.loadGrailsApplicationFromResources(this.resources);
                this.initialise();
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("I/O error rebuilding GrailsApplication: " + e.getMessage(), e);
            }
        } else {
            throw new IllegalStateException("Cannot rebuild GrailsApplication when not in development mode!");
        }
    }

    public Resource getResourceForClass(Class theClazz) {
        if (this.resourceLoader == null) {
            return null;
        }
        return this.resourceLoader.getResourceForClass(theClazz);
    }

    public boolean isArtefact(Class theClazz) {
        String className = theClazz.getName();
        for (Class artefactClass : this.allArtefactClasses) {
            if (!className.equals(artefactClass.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isArtefactOfType(String artefactType, Class theClazz) {
        ArtefactHandler handler = (ArtefactHandler)this.artefactHandlersByName.get(artefactType);
        if (handler == null) {
            throw new GrailsConfigurationException("Unable to locate arefact handler for specified type: " + artefactType);
        }
        return handler.isArtefact(theClazz);
    }

    public boolean isArtefactOfType(String artefactType, String className) {
        return this.getArtefact(artefactType, className) != null;
    }

    public GrailsClass getArtefact(String artefactType, String name) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClass(name);
    }

    private GrailsClass getFirstArtefact(String artefactType) {
        ArtefactInfo info = this.getArtefactInfo(artefactType);
        return info == null ? null : info.getGrailsClasses()[0];
    }

    public GrailsClass[] getArtefacts(String artefactType) {
        DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
        return info.getGrailsClasses();
    }

    public GrailsClass getArtefactForFeature(String artefactType, Object featureID) {
        ArtefactHandler handler = (ArtefactHandler)this.artefactHandlersByName.get(artefactType);
        return handler.getArtefactForFeature(featureID);
    }

    public GrailsClass addArtefact(String artefactType, Class artefactClass) {
        if (Modifier.isAbstract(artefactClass.getModifiers())) {
            return null;
        }
        ArtefactHandler handler = (ArtefactHandler)this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefact(artefactClass)) {
            GrailsClass artefactGrailsClass = handler.newArtefactClass(artefactClass);
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            info.addGrailsClass(artefactGrailsClass);
            info.updateComplete();
            this.addToLoaded(artefactClass);
            if (this.isInitialised()) {
                this.initializeArtefacts(artefactType);
            }
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactClass + "]. It is not a " + artefactType + "!");
    }

    public GrailsClass addArtefact(String artefactType, GrailsClass artefactGrailsClass) {
        if (Modifier.isAbstract(artefactGrailsClass.getClazz().getModifiers())) {
            return null;
        }
        ArtefactHandler handler = (ArtefactHandler)this.artefactHandlersByName.get(artefactType);
        if (handler.isArtefactGrailsClass(artefactGrailsClass)) {
            DefaultArtefactInfo info = this.getArtefactInfo(artefactType, true);
            info.addGrailsClass(artefactGrailsClass);
            info.updateComplete();
            this.initializeArtefacts(artefactType);
            return artefactGrailsClass;
        }
        throw new GrailsConfigurationException("Cannot add " + artefactType + " class [" + artefactGrailsClass + "]. It is not a " + artefactType + "!");
    }

    public void registerArtefactHandler(ArtefactHandler handler) {
        this.artefactHandlersByName.put(handler.getType(), handler);
    }

    public ArtefactHandler[] getArtefactHandlers() {
        return this.artefactHandlers;
    }

    private void initializeArtefacts(String artefactType) {
        ArtefactHandler handler = (ArtefactHandler)this.artefactHandlersByName.get(artefactType);
        this.initializeArtefacts(handler);
    }

    private void initializeArtefacts(ArtefactHandler handler) {
        ArtefactInfo info;
        if (handler != null && (info = this.getArtefactInfo(handler.getType())) != null) {
            handler.initialize(info);
        }
    }

    private DefaultArtefactInfo getArtefactInfo(String artefactType, boolean create) {
        DefaultArtefactInfo cache = (DefaultArtefactInfo)this.artefactInfo.get(artefactType);
        if (cache == null && create) {
            cache = new DefaultArtefactInfo();
            this.artefactInfo.put(artefactType, cache);
            cache.updateComplete();
        }
        return cache;
    }

    public ArtefactInfo getArtefactInfo(String artefactType) {
        return this.getArtefactInfo(artefactType, false);
    }

    public Object invokeMethod(String methodName, Object args) {
        Object[] argsv = (Object[])args;
        Matcher match = GETCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length > 0) {
                if (argsv[0] instanceof GString) {
                    argsv[0] = argsv[0].toString();
                }
                if (argsv.length != 1 || !(argsv[0] instanceof String)) {
                    throw new IllegalArgumentException("Dynamic method get<Artefact>Class(artefactName) requires a single String parameter");
                }
                return this.getArtefact(match.group(2), argsv[0].toString());
            }
            return super.invokeMethod(methodName, args);
        }
        match = ISCLASS_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            if (argsv.length != 1 || !(argsv[0] instanceof Class)) {
                throw new IllegalArgumentException("Dynamic method is<Artefact>Class(artefactClass) requires a single Class parameter");
            }
            return this.isArtefactOfType(match.group(2), (Class)argsv[0]);
        }
        match = GETCLASSESMETH_PATTERN.matcher(methodName);
        match.find();
        if (match.matches()) {
            String artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(2));
            if (this.artefactHandlersByName.containsKey(artefactName)) {
                return this.getArtefacts(match.group(2));
            }
            throw new IllegalArgumentException("Dynamic method get<Artefact>Classes() called for unrecognized artefact: " + match.group(2));
        }
        return super.invokeMethod(methodName, args);
    }

    public Object getProperty(String propertyName) {
        String artefactName;
        Matcher match = GETCLASSESPROP_PATTERN.matcher(propertyName);
        match.find();
        if (match.matches() && this.artefactHandlersByName.containsKey(artefactName = GrailsNameUtils.getClassNameRepresentation((String)match.group(1)))) {
            return this.getArtefacts(artefactName);
        }
        return super.getProperty(propertyName);
    }

    public void initialise() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loaded classes: [" + this.loadedClasses + "]"));
        }
        Class[] classes = this.populateAllClasses();
        this.configureLoadedClasses(classes);
        this.initialised = true;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public Map getMetadata() {
        return this.applicationMeta;
    }

    public GrailsClass getArtefactByLogicalPropertyName(String type, String logicalName) {
        ArtefactInfo info = this.getArtefactInfo(type);
        return info == null ? null : info.getGrailsClassByLogicalPropertyName(logicalName);
    }

    public void addArtefact(Class artefact) {
        for (int i = 0; i < this.artefactHandlers.length; ++i) {
            ArtefactHandler artefactHandler = this.artefactHandlers[i];
            if (!artefactHandler.isArtefact(artefact)) continue;
            this.addArtefact(artefactHandler.getType(), artefact);
        }
    }

    public boolean isWarDeployed() {
        Object val;
        Map metadata = this.getMetadata();
        return metadata != null && (val = metadata.get(META_GRAILS_WAR_DEPLOYED)) != null && val.equals("true");
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

