/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsTagLibClass;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsTagLibClass;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;

public class TagLibArtefactHandler
extends ArtefactHandlerAdapter {
    private static Log LOG = LogFactory.getLog(TagLibArtefactHandler.class);
    public static final String TYPE = "TagLib";
    private Map tag2libMap = new HashMap();
    private Map namespace2tagLibMap = new HashMap();

    public TagLibArtefactHandler() {
        super(TYPE, GrailsTagLibClass.class, DefaultGrailsTagLibClass.class, TYPE);
    }

    public void initialize(ArtefactInfo artefacts) {
        this.tag2libMap = new HashMap();
        GrailsClass[] classes = artefacts.getGrailsClasses();
        for (int i = 0; i < classes.length; ++i) {
            GrailsTagLibClass taglibClass = (GrailsTagLibClass)classes[i];
            String namespace = taglibClass.getNamespace();
            this.namespace2tagLibMap.put(namespace, taglibClass);
            Iterator<String> j = taglibClass.getTagNames().iterator();
            while (j.hasNext()) {
                String tagName = namespace + ":" + j.next();
                if (!this.tag2libMap.containsKey(tagName)) {
                    this.tag2libMap.put(tagName, taglibClass);
                    continue;
                }
                GrailsTagLibClass current = (GrailsTagLibClass)this.tag2libMap.get(tagName);
                if (!taglibClass.equals(current)) {
                    LOG.info((Object)("There are conflicting tags: " + taglibClass.getFullName() + "." + tagName + " vs. " + current.getFullName() + "." + tagName + ". The former will take precedence."));
                    this.tag2libMap.put(tagName, taglibClass);
                    continue;
                }
                throw new GrailsConfigurationException("Cannot configure tag library [" + taglibClass.getName() + "]. Library [" + current.getName() + "] already contains a tag called [" + tagName + "]");
            }
        }
    }

    public GrailsClass getArtefactForFeature(Object feature) {
        Object tagLib = this.tag2libMap.get(feature);
        if (tagLib != null) {
            return (GrailsClass)tagLib;
        }
        return (GrailsClass)this.namespace2tagLibMap.get(feature);
    }
}

