/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.exceptions.PluginException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class CorePluginFinder {
    private static final Log LOG = LogFactory.getLog(CorePluginFinder.class);
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private final GrailsApplication application;
    private final Set foundPluginClasses;

    public CorePluginFinder(GrailsApplication application) {
        this.application = application;
        this.foundPluginClasses = new HashSet();
    }

    public Set getPluginClasses() {
        this.foundPluginClasses.clear();
        try {
            Resource[] resources = this.resolver.getResources("classpath*:org/codehaus/groovy/grails/**/plugins/**/*GrailsPlugin.class");
            if (resources.length > 0) {
                this.loadCorePluginsFromResources(resources);
            } else {
                LOG.warn((Object)"WARNING: Grails was unable to load core plugins dynamically. This is normally a problem with the container class loader configuration, see troubleshooting and FAQ for more info. ");
                this.loadCorePluginsStatically();
            }
        }
        catch (IOException e) {
            throw new PluginException("I/O exception configuring core plug-ins: " + e.getMessage(), e);
        }
        return this.foundPluginClasses;
    }

    private void loadCorePluginsStatically() {
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.CoreGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.LoggingGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.CodecsGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.i18n.I18nGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.datasource.DataSourceGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.DomainClassGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.ValidationGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.ServletsGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.ControllersGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.GroovyPagesGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.mapping.UrlMappingsGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.filters.FiltersGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.web.mimes.MimeTypesGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.webflow.WebFlowGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.services.ServicesGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.converters.ConvertersGrailsPlugin");
        this.loadCorePlugin("org.codehaus.groovy.grails.plugins.scaffolding.ScaffoldingGrailsPlugin");
    }

    private void loadCorePluginsFromResources(Resource[] resources) throws IOException {
        LOG.debug((Object)("Attempting to load [" + resources.length + "] core plugins"));
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            String url = resource.getURL().toString();
            int packageIndex = url.indexOf("org/codehaus/groovy/grails");
            url = url.substring(packageIndex, url.length());
            url = url.substring(0, url.length() - 6);
            String className = url.replace('/', '.');
            this.loadCorePlugin(className);
        }
    }

    private Class attemptCorePluginClassLoad(String pluginClassName) {
        try {
            return this.application.getClassLoader().loadClass(pluginClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("[GrailsPluginManager] Core plugin [" + pluginClassName + "] not found, resuming load without.."));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private void loadCorePlugin(String pluginClassName) {
        Class pluginClass = this.attemptCorePluginClassLoad(pluginClassName);
        if (pluginClass != null) {
            this.addPlugin(pluginClass);
        }
    }

    private void addPlugin(Class plugin) {
        this.foundPluginClasses.add(plugin);
    }
}

